/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Vec3f;

public final class Source {
    private final AL al;
    private final int sourceID;
    private Buffer buffer;

    Source(AL aL, int n) {
        this.al = aL;
        this.sourceID = n;
    }

    public void play() {
        this.al.alSourcePlay(this.sourceID);
    }

    public void pause() {
        this.al.alSourcePause(this.sourceID);
    }

    public void stop() {
        this.al.alSourceStop(this.sourceID);
    }

    public void rewind() {
        this.al.alSourceRewind(this.sourceID);
    }

    public void delete() {
        this.al.alDeleteSources(1, new int[]{this.sourceID}, 0);
    }

    public boolean isPlaying() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4112, nArray, 0);
        return nArray[0] == 4114;
    }

    public void setPitch(float f) {
        this.al.alSourcef(this.sourceID, 4099, f);
    }

    public float getPitch() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4099, fArray, 0);
        return fArray[0];
    }

    public void setGain(float f) {
        this.al.alSourcef(this.sourceID, 4106, f);
    }

    public float getGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4106, fArray, 0);
        return fArray[0];
    }

    public void setMaxDistance(float f) {
        this.al.alSourcef(this.sourceID, 4131, f);
    }

    public float getMaxDistance() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4131, fArray, 0);
        return fArray[0];
    }

    public void setRolloffFactor(float f) {
        this.al.alSourcef(this.sourceID, 4129, f);
    }

    public float getRolloffFactor() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4129, fArray, 0);
        return fArray[0];
    }

    public void setReferenceDistance(float f) {
        this.al.alSourcef(this.sourceID, 4128, f);
    }

    public float getReferenceDistance() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4128, fArray, 0);
        return fArray[0];
    }

    public void setMinGain(float f) {
        this.al.alSourcef(this.sourceID, 4109, f);
    }

    public float getMinGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4109, fArray, 0);
        return fArray[0];
    }

    public void setMaxGain(float f) {
        this.al.alSourcef(this.sourceID, 4110, f);
    }

    public float getMaxGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4110, fArray, 0);
        return fArray[0];
    }

    public void setConeOuterGain(float f) {
        this.al.alSourcef(this.sourceID, 4130, f);
    }

    public float getConeOuterGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4130, fArray, 0);
        return fArray[0];
    }

    public void setPosition(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4100, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setPosition(float f, float f2, float f3) {
        this.al.alSource3f(this.sourceID, 4100, f, f2, f3);
    }

    public Vec3f getPosition() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4100, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setVelocity(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4102, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setVelocity(float f, float f2, float f3) {
        this.al.alSource3f(this.sourceID, 4102, f, f2, f3);
    }

    public Vec3f getVelocity() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4102, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setDirection(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4101, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setDirection(float f, float f2, float f3) {
        this.al.alSource3f(this.sourceID, 4101, f, f2, f3);
    }

    public Vec3f getDirection() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4101, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setSourceRelative(boolean bl) {
        int n = bl ? 1 : 0;
        this.al.alSourcei(this.sourceID, 514, n);
    }

    public boolean isSourceRelative() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 514, nArray, 0);
        return nArray[0] == 1;
    }

    public void setLooping(boolean bl) {
        int n = bl ? 1 : 0;
        this.al.alSourcei(this.sourceID, 4103, n);
    }

    public boolean getLooping() {
        boolean bl = false;
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4103, nArray, 0);
        return nArray[0] == 1;
    }

    public int getBuffersQueued() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4117, nArray, 0);
        return nArray[0];
    }

    public int getBuffersProcessed() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4118, nArray, 0);
        return nArray[0];
    }

    public void setBuffer(Buffer buffer) {
        this.al.alSourcei(this.sourceID, 4105, buffer.bufferID);
        this.buffer = buffer;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void queueBuffers(Buffer[] bufferArray) {
        int n = bufferArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bufferArray[i].bufferID;
        }
        this.al.alSourceQueueBuffers(this.sourceID, n, nArray, 0);
    }

    public void unqueueBuffers(Buffer[] bufferArray) {
        int n = bufferArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = bufferArray[i].bufferID;
        }
        this.al.alSourceUnqueueBuffers(this.sourceID, n, nArray, 0);
    }
}

