/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.ByteArray;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatByte3D;
import mitiv.array.impl.StriddenByte3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte3D
extends Array3D
implements ByteArray {
    protected Byte3D(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected Byte3D(int[] nArray) {
        super(nArray);
    }

    protected Byte3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, byte var4);

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, by);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, by);
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (byte)(this.get(i, j, k) + by));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (byte)(this.get(k, j, i) + by));
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (byte)(this.get(i, j, k) - by));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (byte)(this.get(k, j, i) - by));
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (byte)(this.get(i, j, k) * by));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (byte)(this.get(k, j, i) * by));
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, byteFunction.apply(this.get(i, j, k)));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, byteFunction.apply(this.get(k, j, i)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, byteGenerator.nextByte());
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, byteGenerator.nextByte());
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            byteScanner.update(this.get(i, j, k));
                            continue;
                        }
                        byteScanner.initialize(this.get(i, j, k));
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            byteScanner.update(this.get(k, j, i));
                            continue;
                        }
                        byteScanner.initialize(this.get(k, j, i));
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n2 = this.get(i, j, k) & 0xFF;
                        if (n2 >= n) continue;
                        n = n2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(k, j, i) & 0xFF;
                        if (n3 >= n) continue;
                        n = n3;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n2 = this.get(i, j, k) & 0xFF;
                        if (n2 <= n) continue;
                        n = n2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(k, j, i) & 0xFF;
                        if (n3 <= n) continue;
                        n = n3;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(i, j, k) & 0xFF;
                        if (n3 < n) {
                            n = n3;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n4 = this.get(k, j, i) & 0xFF;
                        if (n4 < n) {
                            n = n4;
                        }
                        if (n4 <= n2) continue;
                        n2 = n4;
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        n += this.get(i, j, k) & 0xFF;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        n += this.get(k, j, i) & 0xFF;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        return this;
    }

    @Override
    public Short3D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        sArray[++n] = (short)(this.get(k, j, i) & 0xFF);
                    }
                }
            }
        }
        return Short3D.wrap(sArray, this.getShape());
    }

    @Override
    public Int3D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        nArray[++n] = this.get(k, j, i) & 0xFF;
                    }
                }
            }
        }
        return Int3D.wrap(nArray, this.getShape());
    }

    @Override
    public Long3D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        lArray[++n] = this.get(k, j, i) & 0xFF;
                    }
                }
            }
        }
        return Long3D.wrap(lArray, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        fArray[++n] = this.get(k, j, i) & 0xFF;
                    }
                }
            }
        }
        return Float3D.wrap(fArray, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        dArray[++n] = this.get(k, j, i) & 0xFF;
                    }
                }
            }
        }
        return Double3D.wrap(dArray, this.getShape());
    }

    @Override
    public Byte3D copy() {
        return new FlatByte3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte3D byte3D = shapedArray.getType() == 0 ? (Byte3D)shapedArray : (Byte3D)shapedArray.toByte();
        if (this.getOrder() == 2 && byte3D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, byte3D.get(i, j, k));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, byte3D.get(k, j, i));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (byte)doubleShapedVector.get(++n));
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (byte)floatShapedVector.get(++n));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte3D create() {
        return new FlatByte3D(this.getShape());
    }

    public static Byte3D create(int n, int n2, int n3) {
        return new FlatByte3D(n, n2, n3);
    }

    public static Byte3D create(int[] nArray) {
        return new FlatByte3D(nArray);
    }

    public static Byte3D create(Shape shape) {
        return new FlatByte3D(shape);
    }

    public static Byte3D wrap(byte[] byArray, int n, int n2, int n3) {
        return new FlatByte3D(byArray, n, n2, n3);
    }

    public static Byte3D wrap(byte[] byArray, int[] nArray) {
        return new FlatByte3D(byArray, nArray);
    }

    public static Byte3D wrap(byte[] byArray, Shape shape) {
        return new FlatByte3D(byArray, shape);
    }

    public static Byte3D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new StriddenByte3D(byArray, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public abstract Byte2D slice(int var1);

    @Override
    public abstract Byte2D slice(int var1, int var2);

    @Override
    public abstract Byte3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Byte3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Byte1D as1D();
}

