/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix3D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix1D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix1D(long[] values) {
        this(values.length);
        this.assign(values);
    }

    public DenseLongMatrix1D(int size) {
        this.setUp(size);
        this.elements = new long[size];
    }

    public DenseLongMatrix1D(int size, long[] elements, int zero, int stride, boolean isView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        long a = f.apply(DenseLongMatrix1D.this.elements[idx]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride]));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero]);
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride]));
                ++i;
            }
        }
        return a;
    }

    @Override
    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = DenseLongMatrix1D.this.zero + indexElements[firstIdx] * DenseLongMatrix1D.this.stride;
                        long a = f.apply(DenseLongMatrix1D.this.elements[idx]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            idx = DenseLongMatrix1D.this.zero + indexElements[i] * DenseLongMatrix1D.this.stride;
                            long elem = DenseLongMatrix1D.this.elements[idx];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero + indexElements[0] * this.stride;
            a = f.apply(this.elements[idx]);
            int i = 1;
            while (i < size) {
                idx = this.zero + indexElements[i] * this.stride;
                long elem = this.elements[idx];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public long aggregate(LongMatrix1D other, final LongLongFunction aggr, final LongLongFunction f) {
        if (!(other instanceof DenseLongMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final long[] elemsOther = (long[])other.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        long a = f.apply(DenseLongMatrix1D.this.elements[idx], elemsOther[idxOther]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride], elemsOther[idxOther += strideOther]));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[this.zero], elemsOther[zeroOther]);
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.elements[idx += this.stride], elemsOther[idxOther += strideOther]));
                ++i;
            }
        }
        return a;
    }

    @Override
    public LongMatrix1D assign(final LongFunction function) {
        int nthreads;
        long multiplicator;
        if (function instanceof LongMult) {
            multiplicator = ((LongMult)function).multiplicator;
            if (multiplicator == 1L) {
                return this;
            }
        } else {
            multiplicator = 0L;
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        if (function instanceof LongMult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] * multiplicator;
                                idx += DenseLongMatrix1D.this.stride;
                                ++k;
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseLongMatrix1D.this.elements[idx] = function.apply(DenseLongMatrix1D.this.elements[idx]);
                                idx += DenseLongMatrix1D.this.stride;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero - this.stride;
            if (function instanceof LongMult) {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = this.elements[idx] * multiplicator;
                }
            } else {
                int k = this.size;
                while (--k >= 0) {
                    this.elements[idx += this.stride] = function.apply(this.elements[idx]);
                }
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(final LongProcedure cond, final LongFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseLongMatrix1D.this.elements[idx])) {
                                DenseLongMatrix1D.this.elements[idx] = function.apply(DenseLongMatrix1D.this.elements[idx]);
                            }
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = function.apply(this.elements[idx]);
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(final LongProcedure cond, final long value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (cond.apply(DenseLongMatrix1D.this.elements[idx])) {
                                DenseLongMatrix1D.this.elements[idx] = value;
                            }
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (cond.apply(this.elements[idx])) {
                    this.elements[idx] = value;
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(final long value) {
        final long[] elems = this.elements;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            elems[idx] = value;
                            idx += DenseLongMatrix1D.this.stride;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                elems[idx] = value;
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(final long[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseLongMatrix1D.this.elements[idx] = values[i];
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = values[i];
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(final int[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseLongMatrix1D.this.elements[idx] = values[i];
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = values[i];
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(LongMatrix1D source) {
        if (!(source instanceof DenseLongMatrix1D)) {
            super.assign(source);
            return this;
        }
        DenseLongMatrix1D other = (DenseLongMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            LongMatrix1D c = other.copy();
            if (!(c instanceof DenseLongMatrix1D)) {
                super.assign(source);
                return this;
            }
            other = (DenseLongMatrix1D)c;
        }
        final long[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            DenseLongMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            idx += DenseLongMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                this.elements[idx] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
        return this;
    }

    @Override
    public LongMatrix1D assign(LongMatrix1D y, final LongLongFunction function) {
        if (!(y instanceof DenseLongMatrix1D)) {
            super.assign(y, function);
            return this;
        }
        this.checkSize(y);
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        final long[] elemsOther = (long[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == LongFunctions.mult) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] * elemsOther[idxOther];
                                idx += DenseLongMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == LongFunctions.div) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] / elemsOther[idxOther];
                                idx += DenseLongMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function instanceof LongPlusMultFirst) {
                            long multiplicator = ((LongPlusMultFirst)function).multiplicator;
                            if (multiplicator == 0L) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseLongMatrix1D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == 1L) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] + elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1L) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseLongMatrix1D.this.elements[idx] = elemsOther[idxOther] - DenseLongMatrix1D.this.elements[idx];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    DenseLongMatrix1D.this.elements[idx] = multiplicator * DenseLongMatrix1D.this.elements[idx] + elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else if (function instanceof LongPlusMultSecond) {
                            long multiplicator = ((LongPlusMultSecond)function).multiplicator;
                            if (multiplicator == 0L) {
                                return;
                            }
                            if (multiplicator == 1L) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] + elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else if (multiplicator == -1L) {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] - elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            } else {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int n = idx;
                                    DenseLongMatrix1D.this.elements[n] = DenseLongMatrix1D.this.elements[n] + multiplicator * elemsOther[idxOther];
                                    idx += DenseLongMatrix1D.this.stride;
                                    idxOther += strideOther;
                                    ++k;
                                }
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseLongMatrix1D.this.elements[idx] = function.apply(DenseLongMatrix1D.this.elements[idx], elemsOther[idxOther]);
                                idx += DenseLongMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == LongFunctions.mult) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] * elemsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == LongFunctions.div) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] / elemsOther[idxOther];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function instanceof LongPlusMultSecond) {
                long multiplicator = ((LongPlusMultSecond)function).multiplicator;
                if (multiplicator == 0L) {
                    return this;
                }
                if (multiplicator == 1L) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else if (multiplicator == -1L) {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] - elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                } else {
                    int k = 0;
                    while (k < this.size) {
                        int n = idx;
                        this.elements[n] = this.elements[n] + multiplicator * elemsOther[idxOther];
                        idx += this.stride;
                        idxOther += strideOther;
                        ++k;
                    }
                }
            } else {
                int k = 0;
                while (k < this.size) {
                    this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (DenseLongMatrix1D.this.elements[idx] != 0L) {
                                ++cardinality;
                            }
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                if (this.elements[idx] != 0L) {
                    ++cardinality;
                }
                idx += this.stride;
                ++i;
            }
        }
        return cardinality;
    }

    public long[] elements() {
        return this.elements;
    }

    public void getNonZeros(LongArrayList indexList, LongArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            long value = this.elements[idx];
            if (value != 0L) {
                indexList.add(0L);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            long value = this.elements[idx];
            if (value != 0L) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) != 0L) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    public void getPositiveValues(LongArrayList indexList, LongArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            long value = this.elements[idx];
            if (value > 0L) {
                indexList.add(0L);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            long value = this.elements[idx];
            if (value > 0L) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) > 0L) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    public void getNegativeValues(LongArrayList indexList, LongArrayList valueList) {
        indexList.clear();
        valueList.clear();
        int idx = this.zero;
        int rem = this.size % 2;
        if (rem == 1) {
            long value = this.elements[idx];
            if (value < 0L) {
                indexList.add(0L);
                valueList.add(value);
            }
            idx += this.stride;
        }
        int i = rem;
        while (i < this.size) {
            long value = this.elements[idx];
            if (value < 0L) {
                indexList.add(i);
                valueList.add(value);
            }
            if ((value = this.elements[idx += this.stride]) < 0L) {
                indexList.add(i + 1);
                valueList.add(value);
            }
            idx += this.stride;
            i += 2;
        }
    }

    @Override
    public long[] getMaxLocation() {
        int location = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        long maxValue = DenseLongMatrix1D.this.elements[idx];
                        int location = (idx - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (maxValue < DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride]) {
                                maxValue = DenseLongMatrix1D.this.elements[idx];
                                location = (idx - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new long[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (maxValue < this.elements[idx += this.stride]) {
                    maxValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new long[]{maxValue, location};
    }

    @Override
    public long[] getMinLocation() {
        int location = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        long minValue = DenseLongMatrix1D.this.elements[idx];
                        int location = (idx - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            if (minValue > DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride]) {
                                minValue = DenseLongMatrix1D.this.elements[idx];
                                location = (idx - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                            }
                            ++i;
                        }
                        return new long[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[this.zero];
            location = 0;
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                if (minValue > this.elements[idx += this.stride]) {
                    minValue = this.elements[idx];
                    location = (idx - this.zero) / this.stride;
                }
                ++i;
            }
        }
        return new long[]{minValue, location};
    }

    @Override
    public long getQuick(int index) {
        return this.elements[this.zero + index * this.stride];
    }

    @Override
    public LongMatrix1D like(int size) {
        return new DenseLongMatrix1D(size);
    }

    @Override
    public LongMatrix2D like2D(int rows, int columns) {
        return new DenseLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseLongMatrix2D M = new DenseLongMatrix2D(rows, columns);
        final long[] elemsOther = (long[])((LongMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, columns);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idxOther = zeroOther + c * colStrideOther;
                            int idx = DenseLongMatrix1D.this.zero + c * rows * DenseLongMatrix1D.this.stride;
                            int r = 0;
                            while (r < rows) {
                                elemsOther[idxOther] = DenseLongMatrix1D.this.elements[idx];
                                idxOther += rowStrideOther;
                                idx += DenseLongMatrix1D.this.stride;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int c = 0;
            while (c < columns) {
                int idxOther = zeroOther + c * colStrideOther;
                int r = 0;
                while (r < rows) {
                    elemsOther[idxOther] = this.elements[idx];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                    ++r;
                }
                ++c;
            }
        }
        return M;
    }

    @Override
    public LongMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseLongMatrix3D M = new DenseLongMatrix3D(slices, rows, columns);
        final long[] elemsOther = (long[])((LongMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int colStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < columns) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                                int idx = DenseLongMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseLongMatrix1D.this.stride;
                                int r = 0;
                                while (r < rows) {
                                    elemsOther[idxOther] = DenseLongMatrix1D.this.elements[idx];
                                    idxOther += rowStrideOther;
                                    idx += DenseLongMatrix1D.this.stride;
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int s = 0;
            while (s < slices) {
                int c = 0;
                while (c < columns) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * colStrideOther;
                    int r = 0;
                    while (r < rows) {
                        elemsOther[idxOther] = this.elements[idx];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
        }
        return M;
    }

    @Override
    public void setQuick(int index, long value) {
        this.elements[this.zero + index * this.stride] = value;
    }

    @Override
    public void swap(LongMatrix1D other) {
        DenseLongMatrix1D y;
        if (!(other instanceof DenseLongMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseLongMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final long[] elemsOther = y.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            long tmp = DenseLongMatrix1D.this.elements[idx];
                            DenseLongMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            elemsOther[idxOther] = tmp;
                            idx += DenseLongMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                long tmp = this.elements[idx];
                this.elements[idx] = elemsOther[idxOther];
                elemsOther[idxOther] = tmp;
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
    }

    @Override
    public void toArray(long[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    public long zDotProduct(LongMatrix1D y) {
        if (!(y instanceof DenseLongMatrix1D)) {
            return super.zDotProduct(y);
        }
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        final long[] elemsOther = yy.elements;
        int zeroThis = (int)this.index(0);
        int zeroOther = (int)yy.index(0);
        int strideOther = yy.stride;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        long sum = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Long[] results = new Long[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseLongMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        long sum = 0L;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseLongMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseLongMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseLongMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseLongMatrix1D.this.elements[n] * elemsOther[n2] + DenseLongMatrix1D.this.elements[n3] * elemsOther[n4] + DenseLongMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride] * elemsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride] * elemsOther[idxOther += strideOtherF];
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Long)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].longValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int k = this.size / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elemsOther[n2] + this.elements[n3] * elemsOther[n4] + this.elements[zeroThis] * elemsOther[zeroOther] + this.elements[zeroThis += this.stride] * elemsOther[zeroOther += strideOther];
            }
            k = this.size % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elemsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    @Override
    public long zDotProduct(LongMatrix1D y, int from, int length) {
        if (!(y instanceof DenseLongMatrix1D)) {
            return super.zDotProduct(y, from, length);
        }
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        int tail = from + length;
        if (from < 0 || length < 0) {
            return 0L;
        }
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        final long[] elementsOther = yy.elements;
        int zeroThis = (int)this.index(from);
        int zeroOther = (int)yy.index(from);
        int strideOther = yy.stride;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        long sum = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            final int zeroThisF = zeroThis;
            final int zeroOtherF = zeroOther;
            final int strideOtherF = strideOther;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Long[] results = new Long[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int idx = zeroThisF + firstIdx * DenseLongMatrix1D.this.stride;
                        int idxOther = zeroOtherF + firstIdx * strideOtherF;
                        idx -= DenseLongMatrix1D.this.stride;
                        idxOther -= strideOtherF;
                        long sum = 0L;
                        int min = lastIdx - firstIdx;
                        int k = min / 4;
                        while (--k >= 0) {
                            int n = idx + DenseLongMatrix1D.this.stride;
                            idx = n;
                            int n2 = idxOther + strideOtherF;
                            idxOther = n2;
                            int n3 = idx + DenseLongMatrix1D.this.stride;
                            idx = n3;
                            int n4 = idxOther + strideOtherF;
                            idxOther = n4;
                            idx = idx + DenseLongMatrix1D.this.stride;
                            idxOther = idxOther + strideOtherF;
                            sum += DenseLongMatrix1D.this.elements[n] * elementsOther[n2] + DenseLongMatrix1D.this.elements[n3] * elementsOther[n4] + DenseLongMatrix1D.this.elements[idx] * elementsOther[idxOther] + DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        k = min % 4;
                        while (--k >= 0) {
                            sum += DenseLongMatrix1D.this.elements[idx += DenseLongMatrix1D.this.stride] * elementsOther[idxOther += strideOtherF];
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Long)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].longValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            zeroThis -= this.stride;
            zeroOther -= strideOther;
            int min = tail - from;
            int k = min / 4;
            while (--k >= 0) {
                int n = zeroThis + this.stride;
                zeroThis = n;
                int n2 = zeroOther + strideOther;
                zeroOther = n2;
                int n3 = zeroThis + this.stride;
                zeroThis = n3;
                int n4 = zeroOther + strideOther;
                zeroOther = n4;
                zeroThis = zeroThis + this.stride;
                zeroOther = zeroOther + strideOther;
                sum += this.elements[n] * elementsOther[n2] + this.elements[n3] * elementsOther[n4] + this.elements[zeroThis] * elementsOther[zeroOther] + this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
            k = min % 4;
            while (--k >= 0) {
                sum += this.elements[zeroThis += this.stride] * elementsOther[zeroOther += strideOther];
            }
        }
        return sum;
    }

    @Override
    public long zSum() {
        long sum = 0L;
        final long[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Long[] results = new Long[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int sum = 0;
                        int idx = DenseLongMatrix1D.this.zero + firstIdx * DenseLongMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            sum = (int)((long)sum + elems[idx]);
                            idx += DenseLongMatrix1D.this.stride;
                            ++i;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Long)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].longValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int k = 0;
            while (k < this.size) {
                sum += elems[idx];
                idx += this.stride;
                ++k;
            }
        }
        return sum;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int index = this.zero;
        long[] elems = this.elements;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (elems[index] != 0L) {
                ++cardinality;
            }
            index += this.stride;
        }
        return cardinality;
    }

    @Override
    protected boolean haveSharedCellsRaw(LongMatrix1D other) {
        if (other instanceof SelectedDenseLongMatrix1D) {
            SelectedDenseLongMatrix1D otherMatrix = (SelectedDenseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseLongMatrix1D) {
            DenseLongMatrix1D otherMatrix = (DenseLongMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    protected LongMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseLongMatrix1D(this.elements, offsets);
    }
}

