/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import java.util.concurrent.Future;

public class DenseLargeFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    private float[][] elements;
    private FloatFFT_2D fft2;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;

    public DenseLargeFComplexMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new float[rows][2 * columns];
        this.content = this;
    }

    @Override
    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public void fftColumns() {
        int nthreads;
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            float[] column = (float[])DenseLargeFComplexMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFComplexMatrix2D.this.fftColumns.complexForward(column);
                            DenseLargeFComplexMatrix2D.this.viewColumn(c).assign(column);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.fftColumns.complexForward(column);
                this.viewColumn(c).assign(column);
                ++c;
            }
        }
    }

    @Override
    public void fftRows() {
        int nthreads;
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            DenseLargeFComplexMatrix2D.this.fftRows.complexForward(DenseLargeFComplexMatrix2D.this.elements[r]);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftRows.complexForward(this.elements[r]);
                ++r;
            }
        }
    }

    @Override
    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public void ifftColumns(final boolean scale) {
        int nthreads;
        if (this.fftColumns == null) {
            this.fftColumns = new FloatFFT_1D(this.rows);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            float[] column = (float[])DenseLargeFComplexMatrix2D.this.viewColumn(c).copy().elements();
                            DenseLargeFComplexMatrix2D.this.fftColumns.complexInverse(column, scale);
                            DenseLargeFComplexMatrix2D.this.viewColumn(c).assign(column);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                float[] column = (float[])this.viewColumn(c).copy().elements();
                this.fftColumns.complexInverse(column, scale);
                this.viewColumn(c).assign(column);
                ++c;
            }
        }
    }

    @Override
    public void ifftRows(final boolean scale) {
        int nthreads;
        if (this.fftRows == null) {
            this.fftRows = new FloatFFT_1D(this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            DenseLargeFComplexMatrix2D.this.fftRows.complexInverse(DenseLargeFComplexMatrix2D.this.elements[r], scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                this.fftRows.complexInverse(this.elements[r], scale);
                ++r;
            }
        }
    }

    @Override
    public float[] getQuick(int row, int column) {
        return new float[]{this.elements[row][2 * column], this.elements[row][2 * column + 1]};
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        this.elements[row][2 * column] = value[0];
        this.elements[row][2 * column + 1] = value[1];
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        this.elements[row][2 * column] = re;
        this.elements[row][2 * column + 1] = im;
    }

    public float[][] elements() {
        return this.elements;
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this;
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new DenseLargeFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new DenseFComplexMatrix1D(size);
    }
}

