/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class FloatBoxedSet
extends SimpleBoxedSet {
    private float[] lo = null;
    private float[] up = null;
    private int bound = 0;

    public FloatBoxedSet(FloatShapedVectorSpace floatShapedVectorSpace) {
        super(floatShapedVectorSpace);
    }

    private float[] getData(Vector vector) {
        this.space.check(vector);
        return ((FloatShapedVector)vector).getData();
    }

    @Override
    public void setLowerBound(double d) {
        float f = (float)d;
        if (f > Float.NEGATIVE_INFINITY) {
            this.lo = new float[]{f};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vector) {
        if (vector != null) {
            this.lo = this.getData(vector);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double d) {
        float f = (float)d;
        if (f < Float.POSITIVE_INFINITY) {
            this.up = new float[]{f};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vector) {
        if (vector != null) {
            this.up = this.getData(vector);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector vector, Vector vector2) {
        float[] fArray = this.getData(vector);
        float[] fArray2 = this.getData(vector2);
        int n = fArray2.length;
        switch (this.bound) {
            case 0: {
                if (fArray == fArray2) break;
                System.arraycopy(fArray, 0, fArray2, 0, n);
                break;
            }
            case 1: {
                float f = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    float f2 = fArray2[i];
                    if (f2 < f) {
                        f2 = f;
                    }
                    fArray[i] = f2;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    float f = fArray2[i];
                    float f3 = this.lo[i];
                    if (f < f3) {
                        f = f3;
                    }
                    fArray[i] = f;
                }
                break;
            }
            case 3: {
                float f = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float f4 = fArray2[i];
                    if (f4 > f) {
                        f4 = f;
                    }
                    fArray[i] = f4;
                }
                break;
            }
            case 4: {
                float f = this.lo[0];
                float f5 = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float f6 = fArray2[i];
                    if (f6 < f) {
                        f6 = f;
                    }
                    if (f6 > f5) {
                        f6 = f5;
                    }
                    fArray[i] = f6;
                }
                break;
            }
            case 5: {
                float f = this.up[0];
                for (int i = 0; i < n; ++i) {
                    float f7 = fArray2[i];
                    float f8 = this.lo[i];
                    if (f7 < f8) {
                        f7 = f8;
                    }
                    if (f7 > f) {
                        f7 = f;
                    }
                    fArray[i] = f7;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    float f = fArray2[i];
                    float f9 = this.up[i];
                    if (f > f9) {
                        f = f9;
                    }
                    fArray[i] = f;
                }
                break;
            }
            case 7: {
                float f = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    float f10 = fArray2[i];
                    float f11 = this.up[i];
                    if (f10 < f) {
                        f10 = f;
                    }
                    if (f10 > f11) {
                        f10 = f11;
                    }
                    fArray[i] = f10;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    float f = this.lo[i];
                    float f12 = fArray2[i];
                    float f13 = this.up[i];
                    if (f12 < f) {
                        f12 = f;
                    }
                    if (f12 > f13) {
                        f12 = f13;
                    }
                    fArray[i] = f12;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector vector, Vector vector2, Vector vector3, int n) {
        float[] fArray = this.getData(vector);
        float[] fArray2 = this.getData(vector2);
        float[] fArray3 = this.getData(vector3);
        int n2 = fArray2.length;
        switch (this.bound) {
            case 0: {
                if (fArray == fArray3) break;
                System.arraycopy(fArray, 0, fArray3, 0, n2);
                break;
            }
            case 1: {
                float f = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] >= 0.0f || fArray2[i] > f ? fArray3[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] <= 0.0f || fArray2[i] > f ? fArray3[i] : 0.0f;
                    }
                }
                break;
            }
            case 2: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] >= 0.0f || fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] <= 0.0f || fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f;
                    }
                }
                break;
            }
            case 3: {
                float f = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] <= 0.0f || fArray2[i] < f ? fArray3[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] >= 0.0f || fArray2[i] < f ? fArray3[i] : 0.0f;
                    }
                }
                break;
            }
            case 4: {
                float f = this.lo[0];
                float f2 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (fArray2[i] > f ? fArray3[i] : 0.0f) : (fArray3[i] > 0.0f ? (fArray2[i] < f2 ? fArray3[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (fArray2[i] > f ? fArray3[i] : 0.0f) : (fArray3[i] < 0.0f ? (fArray2[i] < f2 ? fArray3[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 5: {
                float f = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f) : (fArray3[i] > 0.0f ? (fArray2[i] < f ? fArray3[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f) : (fArray3[i] < 0.0f ? (fArray2[i] < f ? fArray3[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 6: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] <= 0.0f || fArray2[i] < this.up[i] ? fArray3[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] >= 0.0f || fArray2[i] < this.up[i] ? fArray3[i] : 0.0f;
                    }
                }
                break;
            }
            case 7: {
                float f = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (fArray2[i] > f ? fArray3[i] : 0.0f) : (fArray3[i] > 0.0f ? (fArray2[i] < this.up[i] ? fArray3[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (fArray2[i] > f ? fArray3[i] : 0.0f) : (fArray3[i] < 0.0f ? (fArray2[i] < this.up[i] ? fArray3[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
            case 8: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f) : (fArray3[i] > 0.0f ? (fArray2[i] < this.up[i] ? fArray3[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (fArray2[i] > this.lo[i] ? fArray3[i] : 0.0f) : (fArray3[i] < 0.0f ? (fArray2[i] < this.up[i] ? fArray3[i] : 0.0f) : 0.0f);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector vector, Vector vector2, Vector vector3, int n) {
        float[] fArray = this.getData(vector);
        float[] fArray2 = this.getData(vector2);
        float[] fArray3 = this.getData(vector3);
        int n2 = fArray2.length;
        switch (this.bound) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = 1.0f;
                }
                break;
            }
            case 1: {
                float f = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] > 0.0f ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] < 0.0f ? 1 : 0);
                    }
                }
                break;
            }
            case 2: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] > 0.0f ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] < 0.0f ? 1 : 0);
                    }
                }
                break;
            }
            case 3: {
                float f = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? 1.0f : (float)(fArray3[i] > 0.0f ? fArray2[i] < f : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? 1.0f : (float)(fArray3[i] < 0.0f ? fArray2[i] < f : false);
                }
                break;
            }
            case 4: {
                float f = this.lo[0];
                float f2 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] > 0.0f ? fArray2[i] < f2 : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] < 0.0f ? fArray2[i] < f2 : false);
                }
                break;
            }
            case 5: {
                float f = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] > 0.0f ? fArray2[i] < f : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] < 0.0f ? fArray2[i] < f : false);
                }
                break;
            }
            case 6: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? 1.0f : (float)(fArray3[i] > 0.0f ? fArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? 1.0f : (float)(fArray3[i] < 0.0f ? fArray2[i] < this.up[i] : false);
                }
                break;
            }
            case 7: {
                float f = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] > 0.0f ? fArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > f ? 1 : 0) : (float)(fArray3[i] < 0.0f ? fArray2[i] < this.up[i] : false);
                }
                break;
            }
            case 8: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = fArray3[i] < 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] > 0.0f ? fArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    fArray[i] = fArray3[i] > 0.0f ? (float)(fArray2[i] > this.lo[i] ? 1 : 0) : (float)(fArray3[i] < 0.0f ? fArray2[i] < this.up[i] : false);
                }
                break;
            }
        }
    }

    @Override
    public double[] findStepLimits(Vector vector, Vector vector2, int n) {
        float[] fArray = this.getData(vector);
        float[] fArray2 = this.getData(vector2);
        int n2 = fArray.length;
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        switch (this.bound) {
            case 1: {
                f = 0.0f;
                float f4 = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f5 = fArray2[i];
                        if (f5 < 0.0f) {
                            float f6 = (f4 - fArray[i]) / f5;
                            if (f6 < f3) {
                                f3 = f6;
                            }
                            if (f6 < f2 && f6 > 0.0f) {
                                f2 = f6;
                            }
                            if (!(f6 > f)) continue;
                            f = f6;
                            continue;
                        }
                        if (!(f5 > 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f7 = fArray2[i];
                        if (f7 > 0.0f) {
                            float f8 = (fArray[i] - f4) / f7;
                            if (f8 < f3) {
                                f3 = f8;
                            }
                            if (f8 < f2 && f8 > 0.0f) {
                                f2 = f8;
                            }
                            if (!(f8 > f)) continue;
                            f = f8;
                            continue;
                        }
                        if (!(f7 < 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 2: {
                f = 0.0f;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f9 = fArray2[i];
                        if (f9 < 0.0f) {
                            float f10 = (this.lo[i] - fArray[i]) / f9;
                            if (f10 < f3) {
                                f3 = f10;
                            }
                            if (f10 < f2 && f10 > 0.0f) {
                                f2 = f10;
                            }
                            if (!(f10 > f)) continue;
                            f = f10;
                            continue;
                        }
                        if (!(f9 > 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f11 = fArray2[i];
                        if (f11 > 0.0f) {
                            float f12 = (fArray[i] - this.lo[i]) / f11;
                            if (f12 < f3) {
                                f3 = f12;
                            }
                            if (f12 < f2 && f12 > 0.0f) {
                                f2 = f12;
                            }
                            if (!(f12 > f)) continue;
                            f = f12;
                            continue;
                        }
                        if (!(f11 < 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 3: {
                f = 0.0f;
                float f13 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f14 = fArray2[i];
                        if (f14 > 0.0f) {
                            float f15 = (f13 - fArray[i]) / f14;
                            if (f15 < f3) {
                                f3 = f15;
                            }
                            if (f15 < f2 && f15 > 0.0f) {
                                f2 = f15;
                            }
                            if (!(f15 > f)) continue;
                            f = f15;
                            continue;
                        }
                        if (!(f14 < 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f16 = fArray2[i];
                        if (f16 < 0.0f) {
                            float f17 = (fArray[i] - f13) / f16;
                            if (f17 < f3) {
                                f3 = f17;
                            }
                            if (f17 < f2 && f17 > 0.0f) {
                                f2 = f17;
                            }
                            if (!(f17 > f)) continue;
                            f = f17;
                            continue;
                        }
                        if (!(f16 > 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 4: {
                f = 0.0f;
                float f18 = this.lo[0];
                float f19 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f20;
                        float f21 = fArray2[i];
                        if (f21 > 0.0f) {
                            f20 = (f19 - fArray[i]) / f21;
                        } else {
                            if (!(f21 < 0.0f)) continue;
                            f20 = (f18 - fArray[i]) / f21;
                        }
                        if (f20 < f3) {
                            f3 = f20;
                        }
                        if (f20 < f2 && f20 > 0.0f) {
                            f2 = f20;
                        }
                        if (!(f20 > f)) continue;
                        f = f20;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f22;
                        float f23 = fArray2[i];
                        if (f23 < 0.0f) {
                            f22 = (fArray[i] - f19) / f23;
                        } else {
                            if (!(f23 > 0.0f)) continue;
                            f22 = (fArray[i] - f18) / f23;
                        }
                        if (f22 < f3) {
                            f3 = f22;
                        }
                        if (f22 < f2 && f22 > 0.0f) {
                            f2 = f22;
                        }
                        if (!(f22 > f)) continue;
                        f = f22;
                    }
                }
                break;
            }
            case 5: {
                f = 0.0f;
                float f24 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f25;
                        float f26 = fArray2[i];
                        if (f26 > 0.0f) {
                            f25 = (f24 - fArray[i]) / f26;
                        } else {
                            if (!(f26 < 0.0f)) continue;
                            f25 = (this.lo[i] - fArray[i]) / f26;
                        }
                        if (f25 < f3) {
                            f3 = f25;
                        }
                        if (f25 < f2 && f25 > 0.0f) {
                            f2 = f25;
                        }
                        if (!(f25 > f)) continue;
                        f = f25;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f27;
                        float f28 = fArray2[i];
                        if (f28 < 0.0f) {
                            f27 = (fArray[i] - f24) / f28;
                        } else {
                            if (!(f28 > 0.0f)) continue;
                            f27 = (fArray[i] - this.lo[i]) / f28;
                        }
                        if (f27 < f3) {
                            f3 = f27;
                        }
                        if (f27 < f2 && f27 > 0.0f) {
                            f2 = f27;
                        }
                        if (!(f27 > f)) continue;
                        f = f27;
                    }
                }
                break;
            }
            case 6: {
                f = 0.0f;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f29 = fArray2[i];
                        if (f29 > 0.0f) {
                            float f30 = (this.up[i] - fArray[i]) / f29;
                            if (f30 < f3) {
                                f3 = f30;
                            }
                            if (f30 < f2 && f30 > 0.0f) {
                                f2 = f30;
                            }
                            if (!(f30 > f)) continue;
                            f = f30;
                            continue;
                        }
                        if (!(f29 < 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f31 = fArray2[i];
                        if (f31 < 0.0f) {
                            float f32 = (fArray[i] - this.up[i]) / f31;
                            if (f32 < f3) {
                                f3 = f32;
                            }
                            if (f32 < f2 && f32 > 0.0f) {
                                f2 = f32;
                            }
                            if (!(f32 > f)) continue;
                            f = f32;
                            continue;
                        }
                        if (!(f31 > 0.0f)) continue;
                        f = Float.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 7: {
                f = 0.0f;
                float f33 = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f34;
                        float f35 = fArray2[i];
                        if (f35 > 0.0f) {
                            f34 = (this.up[i] - fArray[i]) / f35;
                        } else {
                            if (!(f35 < 0.0f)) continue;
                            f34 = (f33 - fArray[i]) / f35;
                        }
                        if (f34 < f3) {
                            f3 = f34;
                        }
                        if (f34 < f2 && f34 > 0.0f) {
                            f2 = f34;
                        }
                        if (!(f34 > f)) continue;
                        f = f34;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f36;
                        float f37 = fArray2[i];
                        if (f37 < 0.0f) {
                            f36 = (fArray[i] - this.up[i]) / f37;
                        } else {
                            if (!(f37 > 0.0f)) continue;
                            f36 = (fArray[i] - f33) / f37;
                        }
                        if (f36 < f3) {
                            f3 = f36;
                        }
                        if (f36 < f2 && f36 > 0.0f) {
                            f2 = f36;
                        }
                        if (!(f36 > f)) continue;
                        f = f36;
                    }
                }
                break;
            }
            case 8: {
                f = 0.0f;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        float f38;
                        float f39 = fArray2[i];
                        if (f39 > 0.0f) {
                            f38 = (this.up[i] - fArray[i]) / f39;
                        } else {
                            if (!(f39 < 0.0f)) continue;
                            f38 = (this.lo[i] - fArray[i]) / f39;
                        }
                        if (f38 < f3) {
                            f3 = f38;
                        }
                        if (f38 < f2 && f38 > 0.0f) {
                            f2 = f38;
                        }
                        if (!(f38 > f)) continue;
                        f = f38;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        float f40;
                        float f41 = fArray2[i];
                        if (f41 < 0.0f) {
                            f40 = (fArray[i] - this.up[i]) / f41;
                        } else {
                            if (!(f41 > 0.0f)) continue;
                            f40 = (fArray[i] - this.lo[i]) / f41;
                        }
                        if (f40 < f3) {
                            f3 = f40;
                        }
                        if (f40 < f2 && f40 > 0.0f) {
                            f2 = f40;
                        }
                        if (!(f40 > f)) continue;
                        f = f40;
                    }
                }
                break;
            }
        }
        return new double[]{f3, f2, f};
    }
}

