/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.grid.impl;

import java.io.IOException;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.grid.FmrcCS;
import ucar.nc2.ft.grid.impl.CoverageCSFactory;
import ucar.nc2.ft.grid.impl.CoverageCSImpl;
import ucar.nc2.time.CalendarDate;

public class FmrcCSImpl
extends CoverageCSImpl
implements FmrcCS {
    private CoordinateAxis1DTime[] timeAxisForRun;

    protected FmrcCSImpl(NetcdfDataset ds, CoordinateSystem cs, CoverageCSFactory fac) {
        super(ds, cs, fac);
    }

    @Override
    public CoordinateAxis1DTime getRunTimeAxis() {
        return (CoordinateAxis1DTime)this.cs.findAxis(AxisType.RunTime);
    }

    @Override
    public CoordinateAxis1DTime getTimeAxisForRun(CalendarDate runTime) {
        CoordinateAxis1DTime runTimeAxis = this.getRunTimeAxis();
        int runIndex = runTimeAxis.findTimeIndexFromCalendarDate(runTime);
        int nruns = (int)runTimeAxis.getSize();
        if (runIndex < 0 || runIndex >= nruns) {
            throw new IllegalArgumentException("getTimeAxisForRun index out of bounds= " + runIndex);
        }
        if (this.timeAxisForRun == null) {
            this.timeAxisForRun = new CoordinateAxis1DTime[nruns];
        }
        if (this.timeAxisForRun[runIndex] == null) {
            this.timeAxisForRun[runIndex] = this.makeTimeAxisForRun(runIndex);
        }
        return this.timeAxisForRun[runIndex];
    }

    private CoordinateAxis1DTime makeTimeAxisForRun(int run_index) {
        CoordinateAxis tAxis = this.getTimeAxis();
        try {
            VariableDS section = (VariableDS)tAxis.slice(0, run_index);
            return CoordinateAxis1DTime.factory(this.ds, section, null);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

