/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.IOException;
import java.io.RandomAccessFile;
import ucar.atd.dorade.DoradeDescriptor;
import ucar.atd.dorade.DoradePARM;

class DoradeRDAT
extends DoradeDescriptor {
    private String paramName;
    private byte[] paramData;

    public DoradeRDAT(RandomAccessFile file2, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file2, littleEndianData, "RDAT");
        this.paramName = new String(data, 8, 8).trim();
        this.paramData = new byte[data.length - 16];
        System.arraycopy(data, 16, this.paramData, 0, data.length - 16);
        if (this.verbose) {
            System.out.println(this);
        }
    }

    public String toString() {
        String s = "RDAT\n";
        s = s + "  param name: " + this.paramName + "\n";
        s = s + "  data length: " + this.paramData.length;
        return s;
    }

    public String getParamName() {
        return this.paramName;
    }

    public byte[] getRawData() {
        return this.paramData;
    }

    public static DoradeRDAT getNextOf(DoradePARM parm, RandomAccessFile file2, boolean littleEndianData) throws DoradeDescriptor.DescriptorException, IOException {
        while (true) {
            long pos = DoradeRDAT.findNextWithName("RDAT", file2, littleEndianData);
            if (DoradeRDAT.peekParamName(file2).equals(parm.getName())) {
                return new DoradeRDAT(file2, littleEndianData);
            }
            DoradeRDAT.skipDescriptor(file2, littleEndianData);
        }
    }

    private static String peekParamName(RandomAccessFile file2) throws DoradeDescriptor.DescriptorException {
        try {
            long filepos = file2.getFilePointer();
            file2.skipBytes(8);
            byte[] nameBytes = new byte[8];
            if (file2.read(nameBytes) == -1) {
                throw new DoradeDescriptor.DescriptorException("unexpected EOF");
            }
            file2.seek(filepos);
            return new String(nameBytes).trim();
        }
        catch (Exception ex) {
            throw new DoradeDescriptor.DescriptorException(ex);
        }
    }
}

