/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array3D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;

    protected Array3D(int n, int n2, int n3) {
        this.shape = new Shape(n, n2, n3);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
        this.dim3 = n3;
    }

    protected Array3D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array3D(Shape shape) {
        if (shape.rank() != 3) {
            throw new IllegalArgumentException("Bad number of dimensions for 3-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
    }

    @Override
    public final int getRank() {
        return 3;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array3D copy();

    public abstract Array2D slice(int var1);

    public abstract Array2D slice(int var1, int var2);

    public abstract Array3D view(Range var1, Range var2, Range var3);

    public abstract Array3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11 = (n6 - 1) * n3;
        if (n11 >= 0) {
            n10 = n2;
            n9 = n2 + n11;
        } else {
            n10 = n2 + n11;
            n9 = n2;
        }
        n11 = (n7 - 1) * n4;
        if (n11 >= 0) {
            n9 += n11;
        } else {
            n10 += n11;
        }
        n11 = (n8 - 1) * n5;
        if (n11 >= 0) {
            n9 += n11;
        } else {
            n10 += n11;
        }
        if (n10 < 0 || n9 >= n) {
            throw new IndexOutOfBoundsException("3D view is not within available space");
        }
        int n12 = Math.abs(n3);
        int n13 = Math.abs(n4);
        int n14 = Math.abs(n5);
        if (n12 <= n13 && n13 <= n14) {
            return 1;
        }
        if (n12 >= n13 && n13 >= n14) {
            return 2;
        }
        return 0;
    }
}

