/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double1D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatDouble4D;
import mitiv.array.impl.StriddenDouble4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double4D
extends Array4D
implements DoubleArray {
    protected Double4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected Double4D(int[] nArray) {
        super(nArray);
    }

    protected Double4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, double var5);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, d);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, d);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) + d);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) + d);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) - d);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) - d);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) * d);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) * d);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, doubleFunction.apply(this.get(i, j, k, i2)));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, doubleFunction.apply(this.get(i3, k, j, i)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, doubleGenerator.nextDouble());
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, doubleGenerator.nextDouble());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                doubleScanner.update(this.get(i, j, k, i2));
                                continue;
                            }
                            doubleScanner.initialize(this.get(i, j, k, i2));
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                doubleScanner.update(this.get(i3, k, j, i));
                                continue;
                            }
                            doubleScanner.initialize(this.get(i3, k, j, i));
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d2 = this.get(i, j, k, i2);
                            if (!(d2 < d)) continue;
                            d = d2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d3 = this.get(i3, k, j, i);
                            if (!(d3 < d)) continue;
                            d = d3;
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d2 = this.get(i, j, k, i2);
                            if (!(d2 > d)) continue;
                            d = d2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d3 = this.get(i3, k, j, i);
                            if (!(d3 > d)) continue;
                            d = d3;
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d3 = this.get(i, j, k, i2);
                            if (d3 < d) {
                                d = d3;
                            }
                            if (!(d3 > d2)) continue;
                            d2 = d3;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            double d4 = this.get(i3, k, j, i);
                            if (d4 < d) {
                                d = d4;
                            }
                            if (!(d4 > d2)) continue;
                            d2 = d4;
                        }
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            d += this.get(i, j, k, i2);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            d += this.get(i3, k, j, i);
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            byArray[++n] = (byte)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(byArray, this.getShape());
    }

    @Override
    public Short4D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            sArray[++n] = (short)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(sArray, this.getShape());
    }

    @Override
    public Int4D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            nArray[++n] = (int)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Int4D.wrap(nArray, this.getShape());
    }

    @Override
    public Long4D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            lArray[++n] = (long)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Long4D.wrap(lArray, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            fArray[++n] = (float)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Float4D.wrap(fArray, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        return this;
    }

    @Override
    public Double4D copy() {
        return new FlatDouble4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double4D double4D = shapedArray.getType() == 5 ? (Double4D)shapedArray : (Double4D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double4D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, double4D.get(i, j, k, i2));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, double4D.get(i3, k, j, i));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            this.set(i2, k, j, i, doubleShapedVector.get(++n));
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, floatShapedVector.get(++n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double4D create() {
        return new FlatDouble4D(this.getShape());
    }

    public static Double4D create(int n, int n2, int n3, int n4) {
        return new FlatDouble4D(n, n2, n3, n4);
    }

    public static Double4D create(int[] nArray) {
        return new FlatDouble4D(nArray);
    }

    public static Double4D create(Shape shape) {
        return new FlatDouble4D(shape);
    }

    public static Double4D wrap(double[] dArray, int n, int n2, int n3, int n4) {
        return new FlatDouble4D(dArray, n, n2, n3, n4);
    }

    public static Double4D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble4D(dArray, nArray);
    }

    public static Double4D wrap(double[] dArray, Shape shape) {
        return new FlatDouble4D(dArray, shape);
    }

    public static Double4D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new StriddenDouble4D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public abstract Double3D slice(int var1);

    @Override
    public abstract Double3D slice(int var1, int var2);

    @Override
    public abstract Double4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Double4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Double1D as1D();
}

