/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double4D;
import mitiv.array.Float1D;
import mitiv.array.Float3D;
import mitiv.array.FloatArray;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatFloat4D;
import mitiv.array.impl.StriddenFloat4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float4D
extends Array4D
implements FloatArray {
    protected Float4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected Float4D(int[] nArray) {
        super(nArray);
    }

    protected Float4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, float var5);

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, f);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) + f);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) + f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) - f);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) - f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) * f);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) * f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, floatFunction.apply(this.get(i, j, k, i2)));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, floatFunction.apply(this.get(i3, k, j, i)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, floatGenerator.nextFloat());
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, floatGenerator.nextFloat());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                floatScanner.update(this.get(i, j, k, i2));
                                continue;
                            }
                            floatScanner.initialize(this.get(i, j, k, i2));
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                floatScanner.update(this.get(i3, k, j, i));
                                continue;
                            }
                            floatScanner.initialize(this.get(i3, k, j, i));
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float f = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f2 = this.get(i, j, k, i2);
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f3 = this.get(i3, k, j, i);
                            if (!(f3 < f)) continue;
                            f = f3;
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float max() {
        float f = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f2 = this.get(i, j, k, i2);
                            if (!(f2 > f)) continue;
                            f = f2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f3 = this.get(i3, k, j, i);
                            if (!(f3 > f)) continue;
                            f = f3;
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        float f2 = f = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f3 = this.get(i, j, k, i2);
                            if (f3 < f) {
                                f = f3;
                            }
                            if (!(f3 > f2)) continue;
                            f2 = f3;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            float f4 = this.get(i3, k, j, i);
                            if (f4 < f) {
                                f = f4;
                            }
                            if (!(f4 > f2)) continue;
                            f2 = f4;
                        }
                    }
                }
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    @Override
    public float sum() {
        float f = 0.0f;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            f += this.get(i, j, k, i2);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            f += this.get(i3, k, j, i);
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            byArray[++n] = (byte)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(byArray, this.getShape());
    }

    @Override
    public Short4D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            sArray[++n] = (short)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(sArray, this.getShape());
    }

    @Override
    public Int4D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            nArray[++n] = (int)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Int4D.wrap(nArray, this.getShape());
    }

    @Override
    public Long4D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            lArray[++n] = (long)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Long4D.wrap(lArray, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        return this;
    }

    @Override
    public Double4D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            dArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Double4D.wrap(dArray, this.getShape());
    }

    @Override
    public Float4D copy() {
        return new FlatFloat4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float4D float4D = shapedArray.getType() == 4 ? (Float4D)shapedArray : (Float4D)shapedArray.toFloat();
        if (this.getOrder() == 2 && float4D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, float4D.get(i, j, k, i2));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, float4D.get(i3, k, j, i));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            this.set(i2, k, j, i, (float)doubleShapedVector.get(++n));
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (float)floatShapedVector.get(++n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float4D create() {
        return new FlatFloat4D(this.getShape());
    }

    public static Float4D create(int n, int n2, int n3, int n4) {
        return new FlatFloat4D(n, n2, n3, n4);
    }

    public static Float4D create(int[] nArray) {
        return new FlatFloat4D(nArray);
    }

    public static Float4D create(Shape shape) {
        return new FlatFloat4D(shape);
    }

    public static Float4D wrap(float[] fArray, int n, int n2, int n3, int n4) {
        return new FlatFloat4D(fArray, n, n2, n3, n4);
    }

    public static Float4D wrap(float[] fArray, int[] nArray) {
        return new FlatFloat4D(fArray, nArray);
    }

    public static Float4D wrap(float[] fArray, Shape shape) {
        return new FlatFloat4D(fArray, shape);
    }

    public static Float4D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new StriddenFloat4D(fArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public abstract Float3D slice(int var1);

    @Override
    public abstract Float3D slice(int var1, int var2);

    @Override
    public abstract Float4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Float4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Float1D as1D();
}

