/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int1D;
import mitiv.array.IntArray;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatInt2D;
import mitiv.array.impl.StriddenInt2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int2D
extends Array2D
implements IntArray {
    protected Int2D(int n, int n2) {
        super(n, n2);
    }

    protected Int2D(int[] nArray) {
        super(nArray);
    }

    protected Int2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2);

    public abstract void set(int var1, int var2, int var3);

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, n);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, n);
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) + n);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) + n);
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) - n);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) - n);
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) * n);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) * n);
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, intFunction.apply(this.get(i, j)));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, intFunction.apply(this.get(j, i)));
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, intGenerator.nextInt());
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, intGenerator.nextInt());
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        intScanner.update(this.get(i, j));
                        continue;
                    }
                    intScanner.initialize(this.get(i, j));
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        intScanner.update(this.get(j, i));
                        continue;
                    }
                    intScanner.initialize(this.get(j, i));
                    bl = true;
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n2 = this.get(i, j);
                    if (n2 >= n) continue;
                    n = n2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(j, i);
                    if (n3 >= n) continue;
                    n = n3;
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n2 = this.get(i, j);
                    if (n2 <= n) continue;
                    n = n2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(j, i);
                    if (n3 <= n) continue;
                    n = n3;
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n3 = this.get(i, j);
                    if (n3 < n) {
                        n = n3;
                    }
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    int n4 = this.get(j, i);
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    n += this.get(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    n += this.get(j, i);
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    byArray[++n] = (byte)this.get(j, i);
                }
            }
        }
        return Byte2D.wrap(byArray, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    sArray[++n] = (short)this.get(j, i);
                }
            }
        }
        return Short2D.wrap(sArray, this.getShape());
    }

    @Override
    public Int2D toInt() {
        return this;
    }

    @Override
    public Long2D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    lArray[++n] = this.get(j, i);
                }
            }
        }
        return Long2D.wrap(lArray, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    fArray[++n] = this.get(j, i);
                }
            }
        }
        return Float2D.wrap(fArray, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    dArray[++n] = this.get(j, i);
                }
            }
        }
        return Double2D.wrap(dArray, this.getShape());
    }

    @Override
    public Int2D copy() {
        return new FlatInt2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int2D int2D = shapedArray.getType() == 2 ? (Int2D)shapedArray : (Int2D)shapedArray.toInt();
        if (this.getOrder() == 2 && int2D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, int2D.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, int2D.get(j, i));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (int)doubleShapedVector.get(++n));
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (int)floatShapedVector.get(++n));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int2D create() {
        return new FlatInt2D(this.getShape());
    }

    public static Int2D create(int n, int n2) {
        return new FlatInt2D(n, n2);
    }

    public static Int2D create(int[] nArray) {
        return new FlatInt2D(nArray);
    }

    public static Int2D create(Shape shape) {
        return new FlatInt2D(shape);
    }

    public static Int2D wrap(int[] nArray, int n, int n2) {
        return new FlatInt2D(nArray, n, n2);
    }

    public static Int2D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt2D(nArray, nArray2);
    }

    public static Int2D wrap(int[] nArray, Shape shape) {
        return new FlatInt2D(nArray, shape);
    }

    public static Int2D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        return new StriddenInt2D(nArray, n, n2, n3, n4, n5);
    }

    @Override
    public abstract Int1D slice(int var1);

    @Override
    public abstract Int1D slice(int var1, int var2);

    @Override
    public abstract Int2D view(Range var1, Range var2);

    @Override
    public abstract Int2D view(int[] var1, int[] var2);

    @Override
    public abstract Int1D as1D();
}

