/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double5D;
import mitiv.array.Float5D;
import mitiv.array.Int1D;
import mitiv.array.Int4D;
import mitiv.array.IntArray;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatInt5D;
import mitiv.array.impl.StriddenInt5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int5D
extends Array5D
implements IntArray {
    protected Int5D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    protected Int5D(int[] nArray) {
        super(nArray);
    }

    protected Int5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6);

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, n);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, n);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) + n);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) + n);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) - n);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) - n);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) * n);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) * n);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, intFunction.apply(this.get(i, j, k, i2, i3)));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, intFunction.apply(this.get(i5, i4, k, j, i)));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, intGenerator.nextInt());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, intGenerator.nextInt());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    intScanner.update(this.get(i, j, k, i2, i3));
                                    continue;
                                }
                                intScanner.initialize(this.get(i, j, k, i2, i3));
                                bl = true;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    intScanner.update(this.get(i5, i4, k, j, i));
                                    continue;
                                }
                                intScanner.initialize(this.get(i5, i4, k, j, i));
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n2 = this.get(i, j, k, i2, i3);
                                if (n2 >= n) continue;
                                n = n2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i5, i4, k, j, i);
                                if (n3 >= n) continue;
                                n = n3;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n2 = this.get(i, j, k, i2, i3);
                                if (n2 <= n) continue;
                                n = n2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i5, i4, k, j, i);
                                if (n3 <= n) continue;
                                n = n3;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i, j, k, i2, i3);
                                if (n3 < n) {
                                    n = n3;
                                }
                                if (n3 <= n2) continue;
                                n2 = n3;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n4 = this.get(i5, i4, k, j, i);
                                if (n4 < n) {
                                    n = n4;
                                }
                                if (n4 <= n2) continue;
                                n2 = n4;
                            }
                        }
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                n += this.get(i, j, k, i2, i3);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                n += this.get(i5, i4, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                byArray[++n] = (byte)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Byte5D.wrap(byArray, this.getShape());
    }

    @Override
    public Short5D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                sArray[++n] = (short)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Short5D.wrap(sArray, this.getShape());
    }

    @Override
    public Int5D toInt() {
        return this;
    }

    @Override
    public Long5D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                lArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Long5D.wrap(lArray, this.getShape());
    }

    @Override
    public Float5D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                fArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Float5D.wrap(fArray, this.getShape());
    }

    @Override
    public Double5D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                dArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Double5D.wrap(dArray, this.getShape());
    }

    @Override
    public Int5D copy() {
        return new FlatInt5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int5D int5D = shapedArray.getType() == 2 ? (Int5D)shapedArray : (Int5D)shapedArray.toInt();
        if (this.getOrder() == 2 && int5D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, int5D.get(i, j, k, i2, i3));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, int5D.get(i5, i4, k, j, i));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                this.set(i3, i2, k, j, i, (int)doubleShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (int)floatShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int5D create() {
        return new FlatInt5D(this.getShape());
    }

    public static Int5D create(int n, int n2, int n3, int n4, int n5) {
        return new FlatInt5D(n, n2, n3, n4, n5);
    }

    public static Int5D create(int[] nArray) {
        return new FlatInt5D(nArray);
    }

    public static Int5D create(Shape shape) {
        return new FlatInt5D(shape);
    }

    public static Int5D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        return new FlatInt5D(nArray, n, n2, n3, n4, n5);
    }

    public static Int5D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt5D(nArray, nArray2);
    }

    public static Int5D wrap(int[] nArray, Shape shape) {
        return new FlatInt5D(nArray, shape);
    }

    public static Int5D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new StriddenInt5D(nArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @Override
    public abstract Int4D slice(int var1);

    @Override
    public abstract Int4D slice(int var1, int var2);

    @Override
    public abstract Int5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Int5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Int1D as1D();
}

