/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double7D;
import mitiv.array.Float7D;
import mitiv.array.Int1D;
import mitiv.array.Int6D;
import mitiv.array.IntArray;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short7D;
import mitiv.array.impl.FlatInt7D;
import mitiv.array.impl.StriddenInt7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int7D
extends Array7D
implements IntArray {
    protected Int7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    protected Int7D(int[] nArray) {
        super(nArray);
    }

    protected Int7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) + n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) + n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) - n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) - n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) * n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) * n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, intFunction.apply(this.get(i, j, k, i2, i3, i4, i5)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, intFunction.apply(this.get(i9, i8, i7, i6, k, j, i)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, intGenerator.nextInt());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, intGenerator.nextInt());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            intScanner.update(this.get(i, j, k, i2, i3, i4, i5));
                                            continue;
                                        }
                                        intScanner.initialize(this.get(i, j, k, i2, i3, i4, i5));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            intScanner.update(this.get(i9, i8, i7, i6, k, j, i));
                                            continue;
                                        }
                                        intScanner.initialize(this.get(i9, i8, i7, i6, k, j, i));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (n2 >= n) continue;
                                        n = n2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (n3 >= n) continue;
                                        n = n3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (n2 <= n) continue;
                                        n = n2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (n3 <= n) continue;
                                        n = n3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n3 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (n3 < n) {
                                            n = n3;
                                        }
                                        if (n3 <= n2) continue;
                                        n2 = n3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        int n4 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (n4 < n) {
                                            n = n4;
                                        }
                                        if (n4 <= n2) continue;
                                        n2 = n4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        n += this.get(i, j, k, i2, i3, i4, i5);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        n += this.get(i9, i8, i7, i6, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        byArray[++n] = (byte)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(byArray, this.getShape());
    }

    @Override
    public Short7D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        sArray[++n] = (short)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short7D.wrap(sArray, this.getShape());
    }

    @Override
    public Int7D toInt() {
        return this;
    }

    @Override
    public Long7D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        lArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long7D.wrap(lArray, this.getShape());
    }

    @Override
    public Float7D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        fArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float7D.wrap(fArray, this.getShape());
    }

    @Override
    public Double7D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        dArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double7D.wrap(dArray, this.getShape());
    }

    @Override
    public Int7D copy() {
        return new FlatInt7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int7D int7D = shapedArray.getType() == 2 ? (Int7D)shapedArray : (Int7D)shapedArray.toInt();
        if (this.getOrder() == 2 && int7D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, int7D.get(i, j, k, i2, i3, i4, i5));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, int7D.get(i9, i8, i7, i6, k, j, i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        this.set(i5, i4, i3, i2, k, j, i, (int)doubleShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (int)floatShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int7D create() {
        return new FlatInt7D(this.getShape());
    }

    public static Int7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatInt7D(n, n2, n3, n4, n5, n6, n7);
    }

    public static Int7D create(int[] nArray) {
        return new FlatInt7D(nArray);
    }

    public static Int7D create(Shape shape) {
        return new FlatInt7D(shape);
    }

    public static Int7D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatInt7D(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Int7D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt7D(nArray, nArray2);
    }

    public static Int7D wrap(int[] nArray, Shape shape) {
        return new FlatInt7D(nArray, shape);
    }

    public static Int7D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return new StriddenInt7D(nArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    @Override
    public abstract Int6D slice(int var1);

    @Override
    public abstract Int6D slice(int var1, int var2);

    @Override
    public abstract Int7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Int7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Int1D as1D();
}

