/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double4D;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short3D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort4D;
import mitiv.array.impl.StriddenShort4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short4D
extends Array4D
implements ShortArray {
    protected Short4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected Short4D(int[] nArray) {
        super(nArray);
    }

    protected Short4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, short var5);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, s);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, s);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (short)(this.get(i, j, k, i2) + s));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (short)(this.get(i3, k, j, i) + s));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (short)(this.get(i, j, k, i2) - s));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (short)(this.get(i3, k, j, i) - s));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (short)(this.get(i, j, k, i2) * s));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (short)(this.get(i3, k, j, i) * s));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, shortFunction.apply(this.get(i, j, k, i2)));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, shortFunction.apply(this.get(i3, k, j, i)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, shortGenerator.nextShort());
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, shortGenerator.nextShort());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                shortScanner.update(this.get(i, j, k, i2));
                                continue;
                            }
                            shortScanner.initialize(this.get(i, j, k, i2));
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                shortScanner.update(this.get(i3, k, j, i));
                                continue;
                            }
                            shortScanner.initialize(this.get(i3, k, j, i));
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s2 = this.get(i, j, k, i2);
                            if (s2 >= s) continue;
                            s = s2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s3 = this.get(i3, k, j, i);
                            if (s3 >= s) continue;
                            s = s3;
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s2 = this.get(i, j, k, i2);
                            if (s2 <= s) continue;
                            s = s2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s3 = this.get(i3, k, j, i);
                            if (s3 <= s) continue;
                            s = s3;
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s3 = this.get(i, j, k, i2);
                            if (s3 < s) {
                                s = s3;
                            }
                            if (s3 <= s2) continue;
                            s2 = s3;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            short s4 = this.get(i3, k, j, i);
                            if (s4 < s) {
                                s = s4;
                            }
                            if (s4 <= s2) continue;
                            s2 = s4;
                        }
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            n += this.get(i, j, k, i2);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            n += this.get(i3, k, j, i);
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            byArray[++n] = (byte)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(byArray, this.getShape());
    }

    @Override
    public Short4D toShort() {
        return this;
    }

    @Override
    public Int4D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            nArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Int4D.wrap(nArray, this.getShape());
    }

    @Override
    public Long4D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            lArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Long4D.wrap(lArray, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            fArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Float4D.wrap(fArray, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            dArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Double4D.wrap(dArray, this.getShape());
    }

    @Override
    public Short4D copy() {
        return new FlatShort4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short4D short4D = shapedArray.getType() == 1 ? (Short4D)shapedArray : (Short4D)shapedArray.toShort();
        if (this.getOrder() == 2 && short4D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, short4D.get(i, j, k, i2));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, short4D.get(i3, k, j, i));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            this.set(i2, k, j, i, (short)doubleShapedVector.get(++n));
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (short)floatShapedVector.get(++n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short4D create() {
        return new FlatShort4D(this.getShape());
    }

    public static Short4D create(int n, int n2, int n3, int n4) {
        return new FlatShort4D(n, n2, n3, n4);
    }

    public static Short4D create(int[] nArray) {
        return new FlatShort4D(nArray);
    }

    public static Short4D create(Shape shape) {
        return new FlatShort4D(shape);
    }

    public static Short4D wrap(short[] sArray, int n, int n2, int n3, int n4) {
        return new FlatShort4D(sArray, n, n2, n3, n4);
    }

    public static Short4D wrap(short[] sArray, int[] nArray) {
        return new FlatShort4D(sArray, nArray);
    }

    public static Short4D wrap(short[] sArray, Shape shape) {
        return new FlatShort4D(sArray, shape);
    }

    public static Short4D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new StriddenShort4D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public abstract Short3D slice(int var1);

    @Override
    public abstract Short3D slice(int var1, int var2);

    @Override
    public abstract Short4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Short4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Short1D as1D();
}

