/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte7D;
import mitiv.array.Byte8D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.FlatByte7D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte8D;
import mitiv.array.impl.StriddenByte7D;
import mitiv.array.impl.StriddenByte8D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte8D
extends Byte8D {
    static final int order = 1;
    final byte[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;
    final int dim1dim2dim3dim4dim5dim6;
    final int dim1dim2dim3dim4dim5dim6dim7;

    public FlatByte8D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n6, n7, n8);
        this.data = new byte[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * n6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * n7;
    }

    public FlatByte8D(int[] nArray) {
        super(nArray);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
    }

    public FlatByte8D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
    }

    public FlatByte8D(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n6, n7, n8);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * n6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * n7;
    }

    public FlatByte8D(byte[] byArray, int[] nArray) {
        super(nArray);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
    }

    public FlatByte8D(byte[] byArray, Shape shape) {
        super(shape);
        this.checkSize(byArray);
        this.data = byArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
        this.dim1dim2dim3dim4dim5dim6dim7 = this.dim1dim2dim3dim4dim5dim6 * this.dim7;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(byte[] byArray) {
        if (byArray == null || byArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.dim1dim2dim3dim4dim5dim6dim7 * n8 + this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final byte get(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.data[this.dim1dim2dim3dim4dim5dim6dim7 * n8 + this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte by) {
        this.data[this.dim1dim2dim3dim4dim5dim6dim7 * n8 + this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = by;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = by;
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteGenerator.nextByte();
        }
    }

    @Override
    public void increment(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] + by);
        }
    }

    @Override
    public void decrement(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] - by);
        }
    }

    @Override
    public void scale(byte by) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (byte)(this.data[n2] * by);
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = byteFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        byteScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            byteScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (bl) {
            byte[] byArray = new byte[this.number];
            System.arraycopy(this.data, 0, byArray, 0, this.number);
            return byArray;
        }
        return this.data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public Byte7D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim8)) == 0) {
            return new FlatByte7D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
        }
        return new StriddenByte7D(this.data, this.dim1dim2dim3dim4dim5dim6dim7 * n, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1dim2dim3dim4dim5, this.dim1dim2dim3dim4dim5dim6, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Byte7D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        if ((n2 = Helper.fixSliceIndex(n2, 8)) == 0) {
            n17 = Helper.fixIndex(n, this.dim1);
            n16 = this.dim1;
            n15 = this.dim1dim2;
            n14 = this.dim1dim2dim3;
            n13 = this.dim1dim2dim3dim4;
            n12 = this.dim1dim2dim3dim4dim5;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim2;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 1) {
            n17 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n16 = 1;
            n15 = this.dim1dim2;
            n14 = this.dim1dim2dim3;
            n13 = this.dim1dim2dim3dim4;
            n12 = this.dim1dim2dim3dim4dim5;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim3;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 2) {
            n17 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2dim3;
            n13 = this.dim1dim2dim3dim4;
            n12 = this.dim1dim2dim3dim4dim5;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim4;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 3) {
            n17 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2;
            n13 = this.dim1dim2dim3dim4;
            n12 = this.dim1dim2dim3dim4dim5;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim5;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 4) {
            n17 = this.dim1dim2dim3dim4 * Helper.fixIndex(n, this.dim5);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2;
            n13 = this.dim1dim2dim3;
            n12 = this.dim1dim2dim3dim4dim5;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim6;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 5) {
            n17 = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(n, this.dim6);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2;
            n13 = this.dim1dim2dim3;
            n12 = this.dim1dim2dim3dim4;
            n11 = this.dim1dim2dim3dim4dim5dim6;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim7;
            n3 = this.dim8;
        } else if (n2 == 6) {
            n17 = this.dim1dim2dim3dim4dim5dim6 * Helper.fixIndex(n, this.dim7);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2;
            n13 = this.dim1dim2dim3;
            n12 = this.dim1dim2dim3dim4;
            n11 = this.dim1dim2dim3dim4dim5;
            n10 = this.dim1dim2dim3dim4dim5dim6dim7;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim8;
        } else {
            n17 = this.dim1dim2dim3dim4dim5dim6dim7 * Helper.fixIndex(n, this.dim8);
            n16 = 1;
            n15 = this.dim1;
            n14 = this.dim1dim2;
            n13 = this.dim1dim2dim3;
            n12 = this.dim1dim2dim3dim4;
            n11 = this.dim1dim2dim3dim4dim5;
            n10 = this.dim1dim2dim3dim4dim5dim6;
            n9 = this.dim1;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        }
        return new StriddenByte7D(this.data, n17, n16, n15, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Byte8D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6, Range range7, Range range8) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        CompiledRange compiledRange7 = new CompiledRange(range7, this.dim7, 0, this.dim1dim2dim3dim4dim5dim6);
        CompiledRange compiledRange8 = new CompiledRange(range8, this.dim8, 0, this.dim1dim2dim3dim4dim5dim6dim7);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing() && compiledRange7.doesNothing() && compiledRange8.doesNothing()) {
            return this;
        }
        return new StriddenByte8D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset() + compiledRange7.getOffset() + compiledRange8.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange7.getStride(), compiledRange8.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber(), compiledRange7.getNumber(), compiledRange8.getNumber());
    }

    @Override
    public Byte8D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8) {
        int[] nArray9 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray10 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray11 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray12 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        int[] nArray13 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, nArray5);
        int[] nArray14 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, nArray6);
        int[] nArray15 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6, this.dim7, nArray7);
        int[] nArray16 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6dim7, this.dim8, nArray8);
        return new SelectedByte8D(this.data, nArray9, nArray10, nArray11, nArray12, nArray13, nArray14, nArray15, nArray16);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.data, this.number);
    }
}

