/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.FlatDouble3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble4D;
import mitiv.array.impl.StriddenDouble3D;
import mitiv.array.impl.StriddenDouble4D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble4D
extends Double4D {
    static final int order = 1;
    final double[] data;
    final int dim1dim2;
    final int dim1dim2dim3;

    public FlatDouble4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.data = new double[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
    }

    public FlatDouble4D(int[] nArray) {
        super(nArray);
        this.data = new double[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatDouble4D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatDouble4D(double[] dArray, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
    }

    public FlatDouble4D(double[] dArray, int[] nArray) {
        super(nArray);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    public FlatDouble4D(double[] dArray, Shape shape) {
        super(shape);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] dArray) {
        if (dArray == null || dArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4) {
        return this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final double get(int n, int n2, int n3, int n4) {
        return this.data[this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, double d) {
        this.data[this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = d;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        doubleScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            doubleScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (bl) {
            double[] dArray = new double[this.number];
            System.arraycopy(this.data, 0, dArray, 0, this.number);
            return dArray;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public Double3D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim4)) == 0) {
            return new FlatDouble3D(this.data, this.dim1, this.dim2, this.dim3);
        }
        return new StriddenDouble3D(this.data, this.dim1dim2dim3 * n, 1, this.dim1, this.dim1dim2, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Double3D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if ((n2 = Helper.fixSliceIndex(n2, 4)) == 0) {
            n9 = Helper.fixIndex(n, this.dim1);
            n8 = this.dim1;
            n7 = this.dim1dim2;
            n6 = this.dim1dim2dim3;
            n5 = this.dim2;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 1) {
            n9 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n8 = 1;
            n7 = this.dim1dim2;
            n6 = this.dim1dim2dim3;
            n5 = this.dim1;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 2) {
            n9 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n8 = 1;
            n7 = this.dim1;
            n6 = this.dim1dim2dim3;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim4;
        } else {
            n9 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n8 = 1;
            n7 = this.dim1;
            n6 = this.dim1dim2;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim3;
        }
        return new StriddenDouble3D(this.data, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Double4D view(Range range, Range range2, Range range3, Range range4) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing()) {
            return this;
        }
        return new StriddenDouble4D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber());
    }

    @Override
    public Double4D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray6 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray7 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray8 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        return new SelectedDouble4D(this.data, nArray5, nArray6, nArray7, nArray8);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.data, this.number);
    }
}

