/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.FloatScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat1D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.FloatGenerator;

public class FlatFloat1D
extends Float1D {
    static final int order = 1;
    final float[] data;

    public FlatFloat1D(int n) {
        super(n);
        this.data = new float[this.number];
    }

    public FlatFloat1D(int[] nArray) {
        super(nArray);
        this.data = new float[this.number];
    }

    public FlatFloat1D(Shape shape) {
        super(shape);
        this.data = new float[this.number];
    }

    public FlatFloat1D(float[] fArray, int n) {
        super(n);
        this.checkSize(fArray);
        this.data = fArray;
    }

    public FlatFloat1D(float[] fArray, int[] nArray) {
        super(nArray);
        this.checkSize(fArray);
        this.data = fArray;
    }

    public FlatFloat1D(float[] fArray, Shape shape) {
        super(shape);
        this.checkSize(fArray);
        this.data = fArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(float[] fArray) {
        if (fArray == null || fArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final float get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, float f) {
        this.data[n] = f;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = f;
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatGenerator.nextFloat();
        }
    }

    @Override
    public void increment(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + f;
        }
    }

    @Override
    public void decrement(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - f;
        }
    }

    @Override
    public void scale(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * f;
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        floatScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            floatScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (bl) {
            float[] fArray = new float[this.number];
            System.arraycopy(this.data, 0, fArray, 0, this.number);
            return fArray;
        }
        return this.data;
    }

    @Override
    public float[] getData() {
        return this.data;
    }

    @Override
    public FloatScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new FloatScalar(this.data, n);
    }

    @Override
    public FloatScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new FloatScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Float1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenFloat1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Float1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedFloat1D(this.data, nArray2);
    }

    @Override
    public Float1D as1D() {
        return this;
    }
}

