/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long3D;
import mitiv.array.Long4D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong1D;
import mitiv.array.impl.SelectedLong3D;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class SelectedLong4D
extends Long4D {
    static final int order = 0;
    final long[] data;
    final int[] idx1;
    final int[] idx2;
    final int[] idx3;
    final int[] idx4;

    public SelectedLong4D(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        super(nArray.length, nArray2.length, nArray3.length, nArray4.length);
        this.data = lArray;
        this.idx1 = nArray;
        this.idx2 = nArray2;
        this.idx3 = nArray3;
        this.idx4 = nArray4;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 = this.idx1[0];
        for (n2 = 1; n2 < this.dim1; ++n2) {
            n = this.idx1[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx2[0];
        for (n2 = 1; n2 < this.dim2; ++n2) {
            n = this.idx2[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx3[0];
        for (n2 = 1; n2 < this.dim3; ++n2) {
            n = this.idx3[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx4[0];
        for (n2 = 1; n2 < this.dim4; ++n2) {
            n = this.idx4[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        if ((n4 += n6) < 0 || (n5 += n3) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n, int n2, int n3, int n4) {
        return this.idx4[n4] + this.idx3[n3] + this.idx2[n2] + this.idx1[n];
    }

    @Override
    public final long get(int n, int n2, int n3, int n4) {
        return this.data[this.idx4[n4] + this.idx3[n3] + this.idx2[n2] + this.idx1[n]];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, long l) {
        this.data[this.idx4[n4] + this.idx3[n3] + this.idx2[n2] + this.idx1[n]] = l;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4 = this.idx1[i2] + n3;
                        this.data[n4] = l;
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4 = this.idx1[i2] + n3;
                        this.data[n4] = longGenerator.nextLong();
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4;
                        int n5 = n4 = this.idx1[i2] + n3;
                        this.data[n5] = this.data[n5] + l;
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4;
                        int n5 = n4 = this.idx1[i2] + n3;
                        this.data[n5] = this.data[n5] - l;
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4;
                        int n5 = n4 = this.idx1[i2] + n3;
                        this.data[n5] = this.data[n5] * l;
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4 = this.idx1[i2] + n3;
                        this.data[n4] = longFunction.apply(this.data[n4]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim4; ++i) {
            int n = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n2 = this.idx3[j] + n;
                for (int k = 0; k < this.dim2; ++k) {
                    int n3 = this.idx2[k] + n2;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n4 = this.idx1[i2] + n3;
                        if (bl) {
                            longScanner.update(this.data[n4]);
                            continue;
                        }
                        longScanner.initialize(this.data[n4]);
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public long[] flatten(boolean bl) {
        long[] lArray = new long[this.number];
        int n = -1;
        for (int i = 0; i < this.dim4; ++i) {
            int n2 = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n3 = this.idx3[j] + n2;
                for (int k = 0; k < this.dim2; ++k) {
                    int n4 = this.idx2[k] + n3;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n5 = this.idx1[i2] + n4;
                        lArray[++n] = this.data[n5];
                    }
                }
            }
        }
        return lArray;
    }

    @Override
    public long[] getData() {
        return null;
    }

    @Override
    public Long3D slice(int n) {
        int[] nArray;
        int n2 = this.idx4[Helper.fixIndex(n, this.dim4)];
        if (n2 == 0) {
            nArray = this.idx1;
        } else {
            nArray = new int[this.dim1];
            for (int i = 0; i < this.dim1; ++i) {
                nArray[i] = this.idx1[i] + n2;
            }
        }
        return new SelectedLong3D(this.data, nArray, this.idx2, this.idx3);
    }

    @Override
    public Long3D slice(int n, int n2) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n3;
        if ((n2 = Helper.fixSliceIndex(n2, 4)) == 0) {
            n3 = this.idx1[Helper.fixIndex(n, this.dim1)];
            nArray3 = this.idx2;
            nArray2 = this.idx3;
            nArray = this.idx4;
        } else if (n2 == 1) {
            nArray3 = this.idx1;
            n3 = this.idx2[Helper.fixIndex(n, this.dim2)];
            nArray2 = this.idx3;
            nArray = this.idx4;
        } else if (n2 == 2) {
            nArray3 = this.idx1;
            nArray2 = this.idx2;
            n3 = this.idx3[Helper.fixIndex(n, this.dim3)];
            nArray = this.idx4;
        } else {
            nArray3 = this.idx1;
            nArray2 = this.idx2;
            nArray = this.idx3;
            n3 = this.idx4[Helper.fixIndex(n, this.dim4)];
        }
        if (n3 != 0) {
            int n4 = nArray3.length;
            int[] nArray4 = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray4[i] = n3 + nArray3[i];
            }
            nArray3 = nArray4;
        }
        return new SelectedLong3D(this.data, nArray3, nArray2, nArray);
    }

    @Override
    public Long4D view(Range range, Range range2, Range range3, Range range4) {
        int[] nArray = Helper.select(this.idx1, range);
        int[] nArray2 = Helper.select(this.idx2, range2);
        int[] nArray3 = Helper.select(this.idx3, range3);
        int[] nArray4 = Helper.select(this.idx4, range4);
        if (nArray == this.idx1 && nArray2 == this.idx2 && nArray3 == this.idx3 && nArray4 == this.idx4) {
            return this;
        }
        return new SelectedLong4D(this.data, nArray, nArray2, nArray3, nArray4);
    }

    @Override
    public Long4D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = Helper.select(this.idx1, nArray);
        int[] nArray6 = Helper.select(this.idx2, nArray2);
        int[] nArray7 = Helper.select(this.idx3, nArray3);
        int[] nArray8 = Helper.select(this.idx4, nArray4);
        if (nArray5 == this.idx1 && nArray6 == this.idx2 && nArray7 == this.idx3 && nArray8 == this.idx4) {
            return this;
        }
        return new SelectedLong4D(this.data, nArray5, nArray6, nArray7, nArray8);
    }

    @Override
    public Long1D as1D() {
        int[] nArray = new int[this.number];
        int n = -1;
        for (int i = 0; i < this.dim4; ++i) {
            int n2 = this.idx4[i];
            for (int j = 0; j < this.dim3; ++j) {
                int n3 = this.idx3[j] + n2;
                for (int k = 0; k < this.dim2; ++k) {
                    int n4 = this.idx2[k] + n3;
                    for (int i2 = 0; i2 < this.dim1; ++i2) {
                        int n5 = this.idx1[i2] + n4;
                        nArray[++n] = n5;
                    }
                }
            }
        }
        return new SelectedLong1D(this.data, nArray);
    }
}

