/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat3D;
import mitiv.array.impl.StriddenFloat2D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.random.FloatGenerator;

public class StriddenFloat3D
extends Float3D {
    final int order;
    final float[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final boolean flat;

    public StriddenFloat3D(float[] fArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 3) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = fArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.order = Float3D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2;
    }

    public StriddenFloat3D(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n5, n6, n7);
        this.data = fArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.order = Float3D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7);
        this.flat = n == 0 && n2 == 1 && n3 == n5 && n4 == n6 * n3;
    }

    @Override
    public void checkSanity() {
        Float3D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    final int index(int n, int n2, int n3) {
        return this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final float get(int n, int n2, int n3) {
        return this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, float f) {
        this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = f;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = f;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = f;
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = floatGenerator.nextFloat();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = floatGenerator.nextFloat();
                    }
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] + f;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] + f;
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] - f;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] - f;
                    }
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = this.data[n4] * f;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = this.data[n7] * f;
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = floatFunction.apply(this.data[n3]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = floatFunction.apply(this.data[n5]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        if (bl) {
                            floatScanner.update(this.data[n3]);
                            continue;
                        }
                        floatScanner.initialize(this.data[n3]);
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        if (bl) {
                            floatScanner.update(this.data[n5]);
                            continue;
                        }
                        floatScanner.initialize(this.data[n5]);
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        float[] fArray = new float[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, fArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                int n2 = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n4 = this.stride1 * k + n3;
                        fArray[++n] = this.data[n4];
                    }
                }
            }
        }
        return fArray;
    }

    @Override
    public float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Float2D slice(int n) {
        return new StriddenFloat2D(this.data, this.offset + this.stride3 * n, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    @Override
    public Float2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 0) {
            n2 += 3;
        }
        if (n2 == 0) {
            n7 = this.offset + this.stride1 * n;
            n6 = this.stride2;
            n5 = this.stride3;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.offset + this.stride2 * n;
            n6 = this.stride1;
            n5 = this.stride3;
            n4 = this.dim1;
            n3 = this.dim3;
        } else if (n2 == 2) {
            n7 = this.offset + this.stride3 * n;
            n6 = this.stride1;
            n5 = this.stride2;
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenFloat2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Float3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenFloat3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Float3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.stride3, this.dim3, nArray3);
        return new SelectedFloat3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Float1D as1D() {
        return new FlatFloat1D(this.flatten(), this.number);
    }
}

