/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort3D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class StriddenShort3D
extends Short3D {
    final int order;
    final short[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final boolean flat;

    public StriddenShort3D(short[] sArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 3) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = sArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.order = Short3D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2;
    }

    public StriddenShort3D(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n5, n6, n7);
        this.data = sArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.order = Short3D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7);
        this.flat = n == 0 && n2 == 1 && n3 == n5 && n4 == n6 * n3;
    }

    @Override
    public void checkSanity() {
        Short3D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    final int index(int n, int n2, int n3) {
        return this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final short get(int n, int n2, int n3) {
        return this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, short s) {
        this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = s;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = s;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = s;
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = shortGenerator.nextShort();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = shortGenerator.nextShort();
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (short)(this.data[n4] + s);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (short)(this.data[n7] + s);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (short)(this.data[n4] - s);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (short)(this.data[n7] - s);
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (short)(this.data[n4] * s);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (short)(this.data[n7] * s);
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = shortFunction.apply(this.data[n3]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = shortFunction.apply(this.data[n5]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        if (bl) {
                            shortScanner.update(this.data[n3]);
                            continue;
                        }
                        shortScanner.initialize(this.data[n3]);
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        if (bl) {
                            shortScanner.update(this.data[n5]);
                            continue;
                        }
                        shortScanner.initialize(this.data[n5]);
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public short[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        short[] sArray = new short[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, sArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                int n2 = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n4 = this.stride1 * k + n3;
                        sArray[++n] = this.data[n4];
                    }
                }
            }
        }
        return sArray;
    }

    @Override
    public short[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Short2D slice(int n) {
        return new StriddenShort2D(this.data, this.offset + this.stride3 * n, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    @Override
    public Short2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 0) {
            n2 += 3;
        }
        if (n2 == 0) {
            n7 = this.offset + this.stride1 * n;
            n6 = this.stride2;
            n5 = this.stride3;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.offset + this.stride2 * n;
            n6 = this.stride1;
            n5 = this.stride3;
            n4 = this.dim1;
            n3 = this.dim3;
        } else if (n2 == 2) {
            n7 = this.offset + this.stride3 * n;
            n6 = this.stride1;
            n5 = this.stride2;
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenShort2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Short3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenShort3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Short3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.stride3, this.dim3, nArray3);
        return new SelectedShort3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.flatten(), this.number);
    }
}

