/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

import mitiv.exception.IllegalRangeException;

public class Range {
    private int first;
    private int last;
    private int step;
    public static final int FIRST = 0;
    public static final int LAST = -1;
    public static final Range ALL = new Range(0, -1, 1);
    public static final Range REVERSE = new Range(-1, 0, -1);
    public static final Range ODD = new Range(0, -1, 1);
    public static final Range EVEN = new Range(1, -1, 1);

    public Range() {
        this.first = 0;
        this.last = -1;
        this.step = 1;
    }

    public Range(int[] nArray) {
        switch (nArray == null ? 0 : nArray.length) {
            case 0: {
                this.first = 0;
                this.last = -1;
                this.step = 1;
                break;
            }
            case 2: {
                this.first = nArray[0];
                this.last = nArray[1];
                this.step = 1;
                break;
            }
            case 3: {
                this.first = nArray[0];
                this.last = nArray[1];
                this.setStep(nArray[2]);
                break;
            }
            default: {
                throw new IllegalRangeException();
            }
        }
    }

    public Range(int n, int n2) {
        this.first = n;
        this.last = n2;
        this.step = 1;
    }

    public Range(int n, int n2, int n3) {
        this.first = n;
        this.last = n2;
        this.setStep(n3);
    }

    public final int getFirst() {
        return this.first;
    }

    public final int getFirst(int n) {
        return Range.fixIndex(this.first, n);
    }

    public final void setFirst(int n) {
        this.first = n;
    }

    public final int getLast() {
        return this.last;
    }

    public final int getLast(int n) {
        return Range.fixIndex(this.last, n);
    }

    public final void setLast(int n) {
        this.last = n;
    }

    public final int getStep() {
        return this.step;
    }

    public final void setStep(int n) {
        if (n == 0) {
            throw new IllegalRangeException("Illegal 0 step.");
        }
        this.step = n;
    }

    public static final int fixIndex(int n, int n2) {
        return n >= 0 ? n : n2 + n;
    }

    public static final boolean doesNothing(Range range, int n) {
        return range == null || range.doesNothing(n);
    }

    public final boolean doesNothing(int n) {
        return this.step == 1 && Range.fixIndex(this.first, n) == 0 && Range.fixIndex(this.last, n) == n;
    }

    public static final int[] asIndexList(Range range, int n) {
        int n2;
        int n3;
        int n4;
        if (range == null) {
            n4 = 0;
            n3 = 1;
            n2 = n;
        } else {
            n4 = Range.fixIndex(range.first, n);
            int n5 = Range.fixIndex(range.last, n);
            n3 = range.step;
            n2 = 0;
            if (n3 > 0) {
                if (n4 <= n5) {
                    n2 = (n5 - n4) / n3 + 1;
                }
            } else if (n3 < 0 && n4 >= n5) {
                n2 = (n4 - n5) / -n3 + 1;
            }
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n4 + i * n3;
        }
        return nArray;
    }

    public final int[] asIndexList(int n) {
        int n2 = Range.fixIndex(this.first, n);
        int n3 = Range.fixIndex(this.last, n);
        int n4 = 0;
        if (this.step > 0) {
            if (n2 <= n3) {
                n4 = (n3 - n2) / this.step + 1;
            }
        } else if (this.step < 0 && n2 >= n3) {
            n4 = (n2 - n3) / -this.step + 1;
        }
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = n2 + i * this.step;
        }
        return nArray;
    }
}

