/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.Traits;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class GradientChecker {
    static final int FORWARD_DIFFERENCE = 1;
    static final int BACKWARD_DIFFERENCE = -1;
    static final int CENTERED_DIFFERENCE = 0;
    static final double MINIMAL_EPSILON = Traits.DBL_EPSILON;
    static final double DEFAULT_EPSILON = Math.max(MINIMAL_EPSILON, 0.001);
    private final VectorSpace space;
    private double stepScale = DEFAULT_EPSILON;
    private double minStep = Double.MIN_NORMAL;
    private Vector x = null;
    private Vector y = null;
    private double fx;
    private Vector gx = null;
    private final DifferentiableCostFunction f;
    private int method = 1;

    public GradientChecker(DifferentiableCostFunction differentiableCostFunction) {
        this.f = differentiableCostFunction;
        this.space = differentiableCostFunction.getInputSpace();
    }

    public void setVariables(Vector vector, boolean bl) {
        if (bl) {
            if (this.x == null) {
                this.x = vector.clone();
            } else {
                this.x.copy(vector);
            }
        } else {
            this.x = vector;
        }
        if (this.gx == null) {
            this.gx = this.space.create();
        }
        this.fx = this.f.computeCostAndGradient(1.0, vector, this.gx, true);
    }

    public void setStepScale(double d) {
        this.stepScale = d < MINIMAL_EPSILON ? d : DEFAULT_EPSILON;
    }

    public final double getStepScale() {
        return this.stepScale;
    }

    public void setMinStep(double d) {
        this.minStep = Math.max(d, 0.0);
    }

    public final double getMinStep() {
        return this.minStep;
    }

    public void setMethod(int n) {
        this.method = n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public final int getMethod() {
        return this.method;
    }

    public void check(int n) {
        this.check(new int[]{n});
    }

    public void check(int[] nArray) {
        if (this.gx == null) {
            System.err.println("Set variables first.");
            return;
        }
        if (this.y == null) {
            this.y = this.x.clone();
        } else {
            this.y.copy(this.x);
        }
        for (int i = 0; i < nArray.length; ++i) {
            double d;
            double d2;
            int n = nArray[i];
            double d3 = this.x.get(n);
            double d4 = this.stepSize(d3);
            double d5 = this.gx.get(n);
            if (this.method == -1) {
                this.y.set(n, d3 - d4);
                d2 = this.f.evaluate(1.0, this.y);
                d = (this.fx - d2) / d4;
            } else if (this.method == 0) {
                this.y.set(n, d3 - d4);
                d2 = this.f.evaluate(1.0, this.y);
                this.y.set(n, d3 + d4);
                double d6 = this.f.evaluate(1.0, this.y);
                d = (d6 - d2) / (d4 + d4);
            } else {
                this.y.set(n, d3 + d4);
                d2 = this.f.evaluate(1.0, this.y);
                d = (d2 - this.fx) / d4;
            }
            this.y.set(n, d3);
            d2 = Math.abs(GradientChecker.relativeDifference(d5, d));
            System.out.printf("gx[%6d] = %20.12E .:. (fx - fy)/h = %20.12E .:. relative error =%8.1E\n", n, d5, d, d2);
        }
    }

    public static double relativeDifference(double d, double d2) {
        if (d == d2) {
            return 0.0;
        }
        return (d - d2) / Math.max(Math.abs(d), Math.abs(d2));
    }

    public double stepSize(double d) {
        double d2 = Math.max(this.stepScale * Math.abs(d), this.minStep);
        if (d2 <= 0.0) {
            d2 = this.stepScale;
        }
        double d3;
        while ((d3 = d + d2) == d) {
            d2 += d2;
        }
        return d2;
    }
}

