/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;

public class RankOneOperator
extends LinearOperator {
    protected Vector u;
    protected Vector v;

    public RankOneOperator(Vector vector, Vector vector2) {
        super(vector2.getSpace(), vector.getSpace());
        this.u = vector;
        this.v = vector2;
    }

    public RankOneOperator(Vector vector, Vector vector2, boolean bl) throws IncorrectSpaceException {
        super(vector2.getSpace(), vector.getSpace());
        if (bl) {
            this.u = vector.clone();
            this.v = vector2.clone();
        } else {
            this.u = vector;
            this.v = vector2;
        }
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) {
        if (n == DIRECT) {
            vector.scale(this.v.dot(vector2), this.u);
        } else if (n == ADJOINT) {
            vector.scale(this.u.dot(vector2), this.v);
        } else {
            throw new NotImplementedException();
        }
    }

    public Vector getLeftVector() {
        return this.u;
    }

    public void setLeftVector(Vector vector) throws IncorrectSpaceException {
        if (vector.getSpace() != this.outputSpace) {
            throw new IncorrectSpaceException();
        }
        this.u = vector;
    }

    public Vector getRightVector() {
        return this.v;
    }

    public void setRightVector(Vector vector) throws IncorrectSpaceException {
        if (vector.getSpace() != this.inputSpace) {
            throw new IncorrectSpaceException();
        }
        this.v = vector;
    }
}

