/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class FloatShapedVectorSpace
extends ShapedVectorSpace {
    public FloatShapedVectorSpace(Shape shape) {
        super(4, shape);
    }

    public FloatShapedVectorSpace(int ... nArray) {
        super(4, nArray);
    }

    private float[] getData(Vector vector) {
        return ((FloatShapedVector)vector).getData();
    }

    @Override
    public FloatShapedVector create() {
        return new FloatShapedVector(this);
    }

    @Override
    public FloatShapedVector create(double d) {
        FloatShapedVector floatShapedVector = new FloatShapedVector(this);
        ArrayOps.fill(floatShapedVector.getData(), this.number, d);
        return floatShapedVector;
    }

    @Override
    public FloatShapedVector create(ShapedArray shapedArray) {
        return this.create(shapedArray, false);
    }

    @Override
    public FloatShapedVector create(ShapedArray shapedArray, boolean bl) {
        this.checkShape(shapedArray);
        FloatArray floatArray = shapedArray.toFloat();
        return new FloatShapedVector(this, floatArray.flatten(bl && floatArray == shapedArray));
    }

    public FloatShapedVector create(FloatArray floatArray) {
        return this.create(floatArray, false);
    }

    public FloatShapedVector create(FloatArray floatArray, boolean bl) {
        this.checkShape(floatArray);
        return new FloatShapedVector(this, floatArray.flatten(bl));
    }

    public FloatShapedVector clone(FloatShapedVector floatShapedVector) {
        this.check(floatShapedVector);
        return this._clone(floatShapedVector);
    }

    protected FloatShapedVector _clone(FloatShapedVector floatShapedVector) {
        FloatShapedVector floatShapedVector2 = new FloatShapedVector(this);
        this._copy(floatShapedVector2, floatShapedVector);
        return floatShapedVector2;
    }

    @Override
    protected FloatShapedVector _clone(Vector vector) {
        return this._clone((FloatShapedVector)vector);
    }

    public FloatShapedVector wrap(float[] fArray) {
        return new FloatShapedVector(this, fArray);
    }

    public void copy(Vector vector, float[] fArray) {
        this.check(vector);
        ArrayOps.copy(this.getData(vector), fArray);
    }

    @Override
    protected void _copy(Vector vector, Vector vector2) {
        if (vector != vector2) {
            System.arraycopy(this.getData(vector2), 0, this.getData(vector), 0, this.number);
        }
    }

    @Override
    protected void _swap(Vector vector, Vector vector2) {
        float[] fArray = this.getData(vector);
        float[] fArray2 = this.getData(vector2);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            fArray[i] = fArray2[i];
            fArray2[i] = f;
        }
    }

    @Override
    protected void _fill(Vector vector, double d) {
        float[] fArray = this.getData(vector);
        float f = (float)d;
        for (int i = 0; i < this.number; ++i) {
            fArray[i] = f;
        }
    }

    @Override
    protected double _dot(Vector vector, Vector vector2) {
        return ArrayOps.dot(this.number, this.getData(vector), this.getData(vector2));
    }

    @Override
    protected double _dot(Vector vector, Vector vector2, Vector vector3) {
        return ArrayOps.dot(this.number, this.getData(vector), this.getData(vector2), this.getData(vector3));
    }

    @Override
    protected double _norm2(Vector vector) {
        return ArrayOps.norm2(this.getData(vector));
    }

    @Override
    protected double _norm1(Vector vector) {
        return ArrayOps.norm1(this.getData(vector));
    }

    @Override
    protected double _normInf(Vector vector) {
        return ArrayOps.normInf(this.getData(vector));
    }

    @Override
    protected void _scale(Vector vector, double d) {
        if (d == 0.0) {
            this._fill(vector, 0.0);
        } else if (d != 1.0) {
            float[] fArray = this.getData(vector);
            float f = (float)d;
            int n = 0;
            while (n < this.number) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
    }

    @Override
    protected void _scale(Vector vector, double d, Vector vector2) {
        if (d == 0.0) {
            this._fill(vector, 0.0);
        } else if (d == 1.0) {
            this._copy(vector, vector2);
        } else {
            float[] fArray = this.getData(vector2);
            float[] fArray2 = this.getData(vector);
            float f = (float)d;
            for (int i = 0; i < this.number; ++i) {
                fArray2[i] = f * fArray[i];
            }
        }
    }

    @Override
    protected void _combine(Vector vector, double d, Vector vector2, double d2, Vector vector3) {
        ArrayOps.combine(this.getData(vector), this.number, d, this.getData(vector2), d2, this.getData(vector3));
    }

    @Override
    protected void _combine(Vector vector, double d, Vector vector2, double d2, Vector vector3, double d3, Vector vector4) {
        ArrayOps.combine(this.getData(vector), this.number, d, this.getData(vector2), d2, this.getData(vector3), d3, this.getData(vector4));
    }

    @Override
    protected void _multiply(Vector vector, Vector vector2, Vector vector3) {
        float[] fArray = this.getData(vector2);
        float[] fArray2 = this.getData(vector3);
        float[] fArray3 = this.getData(vector);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray3[i] = fArray[i] * fArray2[i];
        }
    }
}

