/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Typed;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;

public abstract class ShapedVectorSpace
extends VectorSpace
implements Shaped,
Typed {
    final ArrayDescriptor descr;

    ShapedVectorSpace(ArrayDescriptor arrayDescriptor) {
        super(arrayDescriptor.getNumber());
        this.descr = arrayDescriptor;
    }

    ShapedVectorSpace(int n, Shape shape) {
        this(new ArrayDescriptor(n, shape));
    }

    ShapedVectorSpace(int n, int ... nArray) {
        this(new ArrayDescriptor(n, nArray));
    }

    @Override
    public final int getType() {
        return this.descr.getType();
    }

    @Override
    public final int getRank() {
        return this.descr.getRank();
    }

    @Override
    public final int getOrder() {
        return this.descr.getOrder();
    }

    @Override
    public final Shape getShape() {
        return this.descr.getShape();
    }

    @Override
    public final int getDimension(int n) {
        return this.descr.getDimension(n);
    }

    public ShapedVector clone(ShapedVector shapedVector) {
        this.check(shapedVector);
        return this._clone(shapedVector);
    }

    protected ShapedVector _clone(ShapedVector shapedVector) {
        ShapedVector shapedVector2 = shapedVector.getType() == 5 ? new DoubleShapedVector((DoubleShapedVectorSpace)shapedVector.getOwner()) : new FloatShapedVector((FloatShapedVectorSpace)shapedVector.getOwner());
        this._copy(shapedVector2, shapedVector);
        return shapedVector2;
    }

    public void checkShape(ShapedArray shapedArray) {
        int n = this.getRank();
        if (n != shapedArray.getRank()) {
            throw new NonConformableArrayException("Shaped array rank mismatch.");
        }
        for (int i = 0; i < n; ++i) {
            if (this.getDimension(i) == shapedArray.getDimension(i)) continue;
            throw new NonConformableArrayException("Shaped array dimension mismatch.");
        }
    }

    @Override
    public abstract ShapedVector create();

    public abstract ShapedVector create(ShapedArray var1);

    public abstract ShapedVector create(ShapedArray var1, boolean var2);
}

