/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.ConvexSetProjector;

public abstract class BoundProjector
extends ConvexSetProjector {
    protected BoundProjector(VectorSpace vectorSpace) {
        super(vectorSpace);
    }

    public void projectDirection(Vector vector, Vector vector2, boolean bl, Vector vector3) {
        if (!(vector.belongsTo(this.space) && vector2.belongsTo(this.space) && vector3.belongsTo(this.space))) {
            throw new IncorrectSpaceException();
        }
        this._projectDirection(vector, vector2, bl, vector3, null);
    }

    public void projectDirection(Vector vector, Vector vector2, boolean bl, Vector vector3, double[] dArray) {
        if (!(vector.belongsTo(this.space) && vector2.belongsTo(this.space) && vector3.belongsTo(this.space))) {
            throw new IncorrectSpaceException();
        }
        if (dArray != null && dArray.length != 2) {
            throw new IllegalArgumentException("Bad array size for step bounds");
        }
        this._projectDirection(vector, vector2, bl, vector3, dArray);
    }

    protected abstract void _projectDirection(Vector var1, Vector var2, boolean var3, Vector var4, double[] var5);

    public final float convertToFloat(double d) {
        if (d < -3.4028234663852886E38) {
            return Float.NEGATIVE_INFINITY;
        }
        if (d < -3.4028234663852886E38) {
            return Float.POSITIVE_INFINITY;
        }
        return (float)d;
    }

    public final void checkLowerBound(double d, boolean bl) {
        if (Double.isNaN(d) || Double.isInfinite(d) && d != Double.NEGATIVE_INFINITY || bl && this.convertToFloat(d) == Float.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Invalid lower bound value");
        }
    }

    public final void checkUpperBound(double d, boolean bl) {
        if (Double.isNaN(d) || Double.isInfinite(d) && d != Double.POSITIVE_INFINITY || bl && this.convertToFloat(d) == Float.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Invalid upper bound value");
        }
    }

    public final void checkBounds(double d, double d2, boolean bl) {
        this.checkLowerBound(d, bl);
        this.checkUpperBound(d2, bl);
        if (d > d2) {
            throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
        }
    }

    public static final double min(double d, double d2) {
        return d <= d2 ? d : d2;
    }

    public static final double max(double d, double d2) {
        return d >= d2 ? d : d2;
    }

    public static final double clamp(double d, double d2, double d3) {
        if (d <= d2) {
            return d2;
        }
        if (d >= d3) {
            return d3;
        }
        return d;
    }

    public static final float min(float f, float f2) {
        return f <= f2 ? f : f2;
    }

    public static final float max(float f, float f2) {
        return f >= f2 ? f : f2;
    }

    public static final float clamp(float f, float f2, float f3) {
        if (f <= f2) {
            return f2;
        }
        if (f >= f3) {
            return f3;
        }
        return f;
    }
}

