/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleLowerBound
extends BoundProjector {
    private final double lowerBound;
    private final boolean single;

    public SimpleLowerBound(ShapedVectorSpace shapedVectorSpace, double d) {
        super(shapedVectorSpace);
        if (shapedVectorSpace.getType() == 5) {
            this.single = false;
        } else if (shapedVectorSpace.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkLowerBound(d, this.single);
        this.lowerBound = d;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    protected void _projectVariables(Vector vector, Vector vector2) {
        int n = vector2.getNumber();
        if (this.single) {
            float f = this.convertToFloat(this.getLowerBound());
            float[] fArray = ((FloatShapedVector)vector2).getData();
            float[] fArray2 = ((FloatShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                fArray2[i] = SimpleLowerBound.max(fArray[i], f);
            }
        } else {
            double d = this.getLowerBound();
            double[] dArray = ((DoubleShapedVector)vector2).getData();
            double[] dArray2 = ((DoubleShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                dArray2[i] = SimpleLowerBound.max(dArray[i], d);
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vector, Vector vector2, boolean bl, Vector vector3, double[] dArray) {
        int n = vector.getNumber();
        if (this.single) {
            float f = this.convertToFloat(this.getLowerBound());
            float[] fArray = ((FloatShapedVector)vector).getData();
            float[] fArray2 = ((FloatShapedVector)vector2).getData();
            float[] fArray3 = ((FloatShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        fArray3[i] = fArray2[i] < 0.0f || fArray[i] > f ? fArray2[i] : 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        fArray3[i] = fArray2[i] > 0.0f || fArray[i] > f ? fArray2[i] : 0.0f;
                    }
                }
            } else {
                float f2 = Float.POSITIVE_INFINITY;
                float f3 = 0.0f;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        if (fArray2[i] < 0.0f) {
                            fArray3[i] = fArray2[i];
                            f3 = Float.POSITIVE_INFINITY;
                            continue;
                        }
                        if (fArray2[i] > 0.0f) {
                            if (fArray[i] > f) {
                                fArray3[i] = fArray2[i];
                                if (f == Float.NEGATIVE_INFINITY) {
                                    f3 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                float f4 = (fArray[i] - f) / fArray2[i];
                                if (f4 < f2) {
                                    f2 = f4;
                                }
                                if (!(f4 > f3)) continue;
                                f3 = f4;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        fArray3[i] = 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (fArray2[i] > 0.0f) {
                            fArray3[i] = fArray2[i];
                            f3 = Float.POSITIVE_INFINITY;
                            continue;
                        }
                        if (fArray2[i] < 0.0f) {
                            if (fArray[i] > f) {
                                fArray3[i] = fArray2[i];
                                if (f == Float.NEGATIVE_INFINITY) {
                                    f3 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                float f5 = (f - fArray[i]) / fArray2[i];
                                if (f5 < f2) {
                                    f2 = f5;
                                }
                                if (!(f5 > f3)) continue;
                                f3 = f5;
                                continue;
                            }
                            fArray3[i] = 0.0f;
                            continue;
                        }
                        fArray3[i] = 0.0f;
                    }
                }
                dArray[0] = f2;
                dArray[1] = f3;
            }
        } else {
            double d = this.getLowerBound();
            double[] dArray2 = ((DoubleShapedVector)vector).getData();
            double[] dArray3 = ((DoubleShapedVector)vector2).getData();
            double[] dArray4 = ((DoubleShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        dArray4[i] = dArray3[i] < 0.0 || dArray2[i] > d ? dArray3[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dArray4[i] = dArray3[i] > 0.0 || dArray2[i] > d ? dArray3[i] : 0.0;
                    }
                }
            } else {
                double d2 = Double.POSITIVE_INFINITY;
                double d3 = 0.0;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        if (dArray3[i] < 0.0) {
                            dArray4[i] = dArray3[i];
                            d3 = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        if (dArray3[i] > 0.0) {
                            if (dArray2[i] > d) {
                                dArray4[i] = dArray3[i];
                                if (d == Double.NEGATIVE_INFINITY) {
                                    d3 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                double d4 = (dArray2[i] - d) / dArray3[i];
                                if (d4 < d2) {
                                    d2 = d4;
                                }
                                if (!(d4 > d3)) continue;
                                d3 = d4;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        dArray4[i] = 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (dArray3[i] > 0.0) {
                            dArray4[i] = dArray3[i];
                            d3 = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        if (dArray3[i] < 0.0) {
                            if (dArray2[i] > d) {
                                dArray4[i] = dArray3[i];
                                if (d == Double.NEGATIVE_INFINITY) {
                                    d3 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                double d5 = (d - dArray2[i]) / dArray3[i];
                                if (d5 < d2) {
                                    d2 = d5;
                                }
                                if (!(d5 > d3)) continue;
                                d3 = d5;
                                continue;
                            }
                            dArray4[i] = 0.0;
                            continue;
                        }
                        dArray4[i] = 0.0;
                    }
                }
                dArray[0] = d2;
                dArray[1] = d3;
            }
        }
    }
}

