/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfcomplex.impl.DelegateFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DiagonalFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import java.util.concurrent.Future;

public class WrapperFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix2D content;

    public WrapperFComplexMatrix2D(FComplexMatrix2D newContent) {
        if (newContent != null) {
            this.setUp(newContent.rows(), newContent.columns());
        }
        this.content = newContent;
    }

    @Override
    public FComplexMatrix2D assign(final float[] values) {
        if (this.content instanceof DiagonalFComplexMatrix2D) {
            int dlength = ((DiagonalFComplexMatrix2D)this.content).dlength;
            final float[] elems = ((DiagonalFComplexMatrix2D)this.content).elements;
            if (values.length != 2 * dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2 * dlength=" + 2 * dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstIdx;
                            while (i < lastIdx) {
                                elems[2 * i] = values[2 * i];
                                elems[2 * i + 1] = values[2 * i + 1];
                                ++i;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < dlength) {
                    elems[2 * i] = values[2 * i];
                    elems[2 * i + 1] = values[2 * i + 1];
                    ++i;
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public boolean equals(float[] value) {
        if (this.content instanceof DiagonalFComplexMatrix2D) {
            float epsilon = FComplexProperty.DEFAULT.tolerance();
            float[] elements = (float[])this.content.elements();
            int dlength = ((DiagonalFComplexMatrix2D)this.content).dlength;
            float[] x = new float[2];
            float[] diff = new float[2];
            int i = 0;
            while (i < dlength) {
                x[0] = elements[2 * i];
                x[1] = elements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0f;
                    diff[1] = 0.0f;
                }
                if (diff[0] > epsilon || diff[1] > epsilon) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.content instanceof DiagonalFComplexMatrix2D && obj instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D other = (DiagonalFComplexMatrix2D)obj;
            int dlength = ((DiagonalFComplexMatrix2D)this.content).dlength;
            float epsilon = FComplexProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            DiagonalFComplexMatrix2D A = (DiagonalFComplexMatrix2D)this.content;
            DiagonalFComplexMatrix2D B = (DiagonalFComplexMatrix2D)obj;
            if (A.columns() != B.columns() || A.rows() != B.rows() || A.diagonalIndex() != B.diagonalIndex() || A.diagonalLength() != B.diagonalLength()) {
                return false;
            }
            float[] otherElements = other.elements;
            float[] elements = ((DiagonalFComplexMatrix2D)this.content).elements;
            float[] x = new float[2];
            float[] value = new float[2];
            float[] diff = new float[2];
            int i = 0;
            while (i < dlength) {
                x[0] = elements[2 * i];
                x[1] = elements[2 * i + 1];
                value[0] = otherElements[2 * i];
                value[1] = otherElements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0f;
                    diff[1] = 0.0f;
                }
                if (diff[0] > epsilon || diff[1] > epsilon) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public synchronized float[] getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    public void fft2() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fft2();
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.fft2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftColumns() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fftColumns();
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.fftColumns();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fftRows() {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).fftRows();
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.fftRows();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftColumns(boolean scale) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifftColumns(scale);
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.ifftColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifftRows(boolean scale) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifftRows(scale);
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.ifftRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean scale) {
        if (this.content instanceof DenseLargeFComplexMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix2D)this.content).ifft2(scale);
            } else {
                DenseLargeFComplexMatrix2D copy = (DenseLargeFComplexMatrix2D)this.copy();
                copy.ifft2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, float[] value) {
        this.content.setQuick(row, column, value);
    }

    @Override
    public synchronized void setQuick(int row, int column, float re, float im) {
        this.content.setQuick(row, column, re, im);
    }

    @Override
    public FComplexMatrix1D vectorize() {
        final DenseFComplexMatrix1D v = new DenseFComplexMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstColumn * WrapperFComplexMatrix2D.this.rows;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < WrapperFComplexMatrix2D.this.rows) {
                                v.setQuick(idx++, WrapperFComplexMatrix2D.this.getQuick(r, c));
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    v.setQuick(idx++, this.getQuick(r, c));
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public FComplexMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    @Override
    public FComplexMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int row, int column) {
                return this.content.getQuick(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float[] value) {
                this.content.setQuick(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, float re, float im) {
                this.content.setQuick(row, this.columns - 1 - column, re, im);
            }

            @Override
            public synchronized float[] get(int row, int column) {
                return this.content.get(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int row, int column, float[] value) {
                this.content.set(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void set(int row, int column, float re, float im) {
                this.content.set(row, this.columns - 1 - column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewDice() {
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int row, int column) {
                return this.content.getQuick(column, row);
            }

            @Override
            public synchronized void setQuick(int row, int column, float[] value) {
                this.content.setQuick(column, row, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, float re, float im) {
                this.content.setQuick(column, row, re, im);
            }

            @Override
            public synchronized float[] get(int row, int column) {
                return this.content.get(column, row);
            }

            @Override
            public synchronized void set(int row, int column, float[] value) {
                this.content.set(column, row, value);
            }

            @Override
            public synchronized void set(int row, int column, float re, float im) {
                this.content.set(column, row, re, im);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i, int j) {
                return this.content.getQuick(row + i, column + j);
            }

            @Override
            public synchronized void setQuick(int i, int j, float[] value) {
                this.content.setQuick(row + i, column + j, value);
            }

            @Override
            public synchronized void setQuick(int i, int j, float re, float im) {
                this.content.setQuick(row + i, column + j, re, im);
            }

            @Override
            public synchronized float[] get(int i, int j) {
                return this.content.get(row + i, column + j);
            }

            @Override
            public synchronized void set(int i, int j, float[] value) {
                this.content.set(row + i, column + j, value);
            }

            @Override
            public synchronized void set(int i, int j, float re, float im) {
                this.content.set(row + i, column + j, re, im);
            }
        };
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateFComplexMatrix1D(this, row);
    }

    @Override
    public FComplexMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int row, int column) {
                return this.content.getQuick(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float[] value) {
                this.content.setQuick(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, float re, float im) {
                this.content.setQuick(this.rows - 1 - row, column, re, im);
            }

            @Override
            public synchronized float[] get(int row, int column) {
                return this.content.get(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int row, int column, float[] value) {
                this.content.set(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void set(int row, int column, float re, float im) {
                this.content.set(this.rows - 1 - row, column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i, int j) {
                return this.content.getQuick(rix[i], cix[j]);
            }

            @Override
            public synchronized void setQuick(int i, int j, float[] value) {
                this.content.setQuick(rix[i], cix[j], value);
            }

            @Override
            public synchronized void setQuick(int i, int j, float re, float im) {
                this.content.setQuick(rix[i], cix[j], re, im);
            }

            @Override
            public synchronized float[] get(int i, int j) {
                return this.content.get(rix[i], cix[j]);
            }

            @Override
            public synchronized void set(int i, int j, float[] value) {
                this.content.set(rix[i], cix[j], value);
            }

            @Override
            public synchronized void set(int i, int j, float re, float im) {
                this.content.set(rix[i], cix[j], re, im);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewStrides(final int _rowStride, final int _columnStride) {
        if (_rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFComplexMatrix2D view = new WrapperFComplexMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int row, int column) {
                return this.content.getQuick(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float[] value) {
                this.content.setQuick(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void setQuick(int row, int column, float re, float im) {
                this.content.setQuick(_rowStride * row, _columnStride * column, re, im);
            }

            @Override
            public synchronized float[] get(int row, int column) {
                return this.content.get(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int row, int column, float[] value) {
                this.content.set(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void set(int row, int column, float re, float im) {
                this.content.set(_rowStride * row, _columnStride * column, re, im);
            }
        };
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this.content;
    }

    @Override
    protected FComplexMatrix1D like1D(int size, int offset, int stride) {
        throw new InternalError();
    }

    @Override
    protected FComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }

    @Override
    public FloatMatrix2D getImaginaryPart() {
        final DenseLargeFloatMatrix2D Im = new DenseLargeFloatMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < WrapperFComplexMatrix2D.this.columns) {
                                Im.setQuick(r, c, WrapperFComplexMatrix2D.this.getQuick(r, c)[1]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Im.setQuick(r, c, this.getQuick(r, c)[1]);
                    ++c;
                }
                ++r;
            }
        }
        return Im;
    }

    @Override
    public FloatMatrix2D getRealPart() {
        final DenseLargeFloatMatrix2D Re = new DenseLargeFloatMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < WrapperFComplexMatrix2D.this.columns) {
                                Re.setQuick(r, c, WrapperFComplexMatrix2D.this.getQuick(r, c)[0]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Re.setQuick(r, c, this.getQuick(r, c)[0]);
                    ++c;
                }
                ++r;
            }
        }
        return Re;
    }
}

