/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import java.io.Serializable;

public class DenseFloatEigenvalueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private int n;
    private boolean issymmetric;
    private float[] d;
    private float[] e;
    private float[][] V;
    private float[][] H;
    private float[] ort;
    private transient float cdivr;
    private transient float cdivi;

    public DenseFloatEigenvalueDecomposition(FloatMatrix2D A) {
        FloatProperty.DEFAULT.checkSquare(A);
        this.n = A.columns();
        this.V = new float[this.n][this.n];
        this.d = new float[this.n];
        this.e = new float[this.n];
        this.issymmetric = FloatProperty.DEFAULT.isSymmetric(A);
        if (this.issymmetric) {
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    this.V[i][j] = A.getQuick(i, j);
                    ++j;
                }
                ++i;
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new float[this.n][this.n];
            this.ort = new float[this.n];
            int j = 0;
            while (j < this.n) {
                int i = 0;
                while (i < this.n) {
                    this.H[i][j] = A.getQuick(i, j);
                    ++i;
                }
                ++j;
            }
            this.orthes();
            this.hqr2();
        }
    }

    private void cdiv(float xr, float xi, float yr, float yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            float r = yi / yr;
            float d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            float r = yr / yi;
            float d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    public FloatMatrix2D getD() {
        float[][] D = new float[this.n][this.n];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                D[i][j] = 0.0f;
                ++j;
            }
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0f) {
                D[i][i + 1] = this.e[i];
            } else if (this.e[i] < 0.0f) {
                D[i][i - 1] = this.e[i];
            }
            ++i;
        }
        return FloatFactory2D.dense.make(D);
    }

    public FloatMatrix1D getImagEigenvalues() {
        return FloatFactory1D.dense.make(this.e);
    }

    public FloatMatrix1D getRealEigenvalues() {
        return FloatFactory1D.dense.make(this.d);
    }

    public FloatMatrix2D getV() {
        return FloatFactory2D.dense.make(this.V);
    }

    private void hqr2() {
        float y;
        int i;
        int j;
        float x;
        float w;
        int l;
        int j2;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        float eps = (float)Math.pow(2.0, -23.0);
        float exshift = 0.0f;
        float p = 0.0f;
        float q = 0.0f;
        float r = 0.0f;
        float s = 0.0f;
        float z = 0.0f;
        float norm = 0.0f;
        int i2 = 0;
        while (i2 < nn) {
            if (i2 < low | i2 > high) {
                this.d[i2] = this.H[i2][i2];
                this.e[i2] = 0.0f;
            }
            j2 = Math.max(i2 - 1, 0);
            while (j2 < nn) {
                norm += Math.abs(this.H[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        int iter = 0;
        block2: while (n >= low) {
            l = n;
            while (l > low) {
                s = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (s == 0.0f) {
                    s = norm;
                }
                if (Math.abs(this.H[l][l - 1]) < eps * s) break;
                --l;
            }
            if (l == n) {
                this.H[n][n] = this.H[n][n] + exshift;
                this.d[n] = this.H[n][n];
                this.e[n] = 0.0f;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H[n][n - 1] * this.H[n - 1][n];
                p = (this.H[n - 1][n - 1] - this.H[n][n]) / 2.0f;
                q = p * p + w;
                z = (float)Math.sqrt(Math.abs(q));
                this.H[n][n] = this.H[n][n] + exshift;
                this.H[n - 1][n - 1] = this.H[n - 1][n - 1] + exshift;
                x = this.H[n][n];
                if (q >= 0.0f) {
                    z = p >= 0.0f ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0f) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0f;
                    this.e[n] = 0.0f;
                    x = this.H[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = (float)Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    j = n - 1;
                    while (j < nn) {
                        z = this.H[n - 1][j];
                        this.H[n - 1][j] = q * z + p * this.H[n][j];
                        this.H[n][j] = q * this.H[n][j] - p * z;
                        ++j;
                    }
                    i = 0;
                    while (i <= n) {
                        z = this.H[i][n - 1];
                        this.H[i][n - 1] = q * z + p * this.H[i][n];
                        this.H[i][n] = q * this.H[i][n] - p * z;
                        ++i;
                    }
                    i = low;
                    while (i <= high) {
                        z = this.V[i][n - 1];
                        this.V[i][n - 1] = q * z + p * this.V[i][n];
                        this.V[i][n] = q * this.V[i][n] - p * z;
                        ++i;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H[n][n];
            y = 0.0f;
            w = 0.0f;
            if (l < n) {
                y = this.H[n - 1][n - 1];
                w = this.H[n][n - 1] * this.H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = low;
                while (i <= n) {
                    float[] fArray = this.H[i];
                    int n2 = i++;
                    fArray[n2] = fArray[n2] - x;
                }
                s = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                x = y = 0.75f * s;
                w = -0.4375f * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0f;
                if ((s = s * s + w) > 0.0f) {
                    s = (float)Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0f + s);
                    i = low;
                    while (i <= n) {
                        float[] fArray = this.H[i];
                        int n3 = i++;
                        fArray[n3] = fArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964f;
                    y = 0.964f;
                    x = 0.964f;
                }
            }
            ++iter;
            int m = n - 2;
            while (m >= l) {
                z = this.H[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H[m + 1][m] + this.H[m][m + 1];
                q = this.H[m + 1][m + 1] - z - r - s;
                r = this.H[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.H[m + 1][m + 1])))) break;
                --m;
            }
            int i3 = m + 2;
            while (i3 <= n) {
                this.H[i3][i3 - 2] = 0.0f;
                if (i3 > m + 2) {
                    this.H[i3][i3 - 3] = 0.0f;
                }
                ++i3;
            }
            int k = m;
            while (k <= n - 1) {
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H[k][k - 1];
                    q = this.H[k + 1][k - 1];
                    r = notlast ? this.H[k + 2][k - 1] : 0.0f;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0f) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0f) continue block2;
                s = (float)Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0f) {
                    s = -s;
                }
                if (s != 0.0f) {
                    if (k != m) {
                        this.H[k][k - 1] = -s * x;
                    } else if (l != m) {
                        this.H[k][k - 1] = -this.H[k][k - 1];
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    int j3 = k;
                    while (j3 < nn) {
                        p = this.H[k][j3] + q * this.H[k + 1][j3];
                        if (notlast) {
                            this.H[k + 2][j3] = this.H[k + 2][j3] - (p += r * this.H[k + 2][j3]) * z;
                        }
                        this.H[k][j3] = this.H[k][j3] - p * x;
                        this.H[k + 1][j3] = this.H[k + 1][j3] - p * y;
                        ++j3;
                    }
                    int i4 = 0;
                    while (i4 <= Math.min(n, k + 3)) {
                        p = x * this.H[i4][k] + y * this.H[i4][k + 1];
                        if (notlast) {
                            this.H[i4][k + 2] = this.H[i4][k + 2] - (p += z * this.H[i4][k + 2]) * r;
                        }
                        this.H[i4][k] = this.H[i4][k] - p;
                        this.H[i4][k + 1] = this.H[i4][k + 1] - p * q;
                        ++i4;
                    }
                    i4 = low;
                    while (i4 <= high) {
                        p = x * this.V[i4][k] + y * this.V[i4][k + 1];
                        if (notlast) {
                            this.V[i4][k + 2] = this.V[i4][k + 2] - (p += z * this.V[i4][k + 2]) * r;
                        }
                        this.V[i4][k] = this.V[i4][k] - p;
                        this.V[i4][k + 1] = this.V[i4][k + 1] - p * q;
                        ++i4;
                    }
                }
                ++k;
            }
        }
        if (norm == 0.0f) {
            return;
        }
        n = nn - 1;
        while (n >= 0) {
            float t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0f) {
                l = n;
                this.H[n][n] = 1.0f;
                i = n - 1;
                while (i >= 0) {
                    w = this.H[i][i] - p;
                    r = 0.0f;
                    int j4 = l;
                    while (j4 <= n) {
                        r += this.H[i][j4] * this.H[j4][n];
                        ++j4;
                    }
                    if (this.e[i] < 0.0f) {
                        z = w;
                        s = r;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0f) {
                            this.H[i][n] = w != 0.0f ? -r / w : -r / (eps * norm);
                        } else {
                            x = this.H[i][i + 1];
                            y = this.H[i + 1][i];
                            q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                            this.H[i][n] = t = (x * s - z * r) / q;
                            this.H[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                        }
                        t = Math.abs(this.H[i][n]);
                        if (eps * t * t > 1.0f) {
                            j4 = i;
                            while (j4 <= n) {
                                this.H[j4][n] = this.H[j4][n] / t;
                                ++j4;
                            }
                        }
                    }
                    --i;
                }
            } else if (q < 0.0f) {
                l = n - 1;
                if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                    this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                    this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
                } else {
                    this.cdiv(0.0f, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                    this.H[n - 1][n - 1] = this.cdivr;
                    this.H[n - 1][n] = this.cdivi;
                }
                this.H[n][n - 1] = 0.0f;
                this.H[n][n] = 1.0f;
                i = n - 2;
                while (i >= 0) {
                    float ra = 0.0f;
                    float sa = 0.0f;
                    int j5 = l;
                    while (j5 <= n) {
                        ra += this.H[i][j5] * this.H[j5][n - 1];
                        sa += this.H[i][j5] * this.H[j5][n];
                        ++j5;
                    }
                    w = this.H[i][i] - p;
                    if (this.e[i] < 0.0f) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0f) {
                            this.cdiv(-ra, -sa, w, q);
                            this.H[i][n - 1] = this.cdivr;
                            this.H[i][n] = this.cdivi;
                        } else {
                            float vi;
                            x = this.H[i][i + 1];
                            y = this.H[i + 1][i];
                            float vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                            if (vr == 0.0f & (vi = (this.d[i] - p) * 2.0f * q) == 0.0f) {
                                vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            }
                            this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            this.H[i][n - 1] = this.cdivr;
                            this.H[i][n] = this.cdivi;
                            if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                                this.H[i + 1][n - 1] = (-ra - w * this.H[i][n - 1] + q * this.H[i][n]) / x;
                                this.H[i + 1][n] = (-sa - w * this.H[i][n] - q * this.H[i][n - 1]) / x;
                            } else {
                                this.cdiv(-r - y * this.H[i][n - 1], -s - y * this.H[i][n], z, q);
                                this.H[i + 1][n - 1] = this.cdivr;
                                this.H[i + 1][n] = this.cdivi;
                            }
                        }
                        t = Math.max(Math.abs(this.H[i][n - 1]), Math.abs(this.H[i][n]));
                        if (eps * t * t > 1.0f) {
                            j5 = i;
                            while (j5 <= n) {
                                this.H[j5][n - 1] = this.H[j5][n - 1] / t;
                                this.H[j5][n] = this.H[j5][n] / t;
                                ++j5;
                            }
                        }
                    }
                    --i;
                }
            }
            --n;
        }
        int i5 = 0;
        while (i5 < nn) {
            if (i5 < low | i5 > high) {
                j = i5;
                while (j < nn) {
                    this.V[i5][j] = this.H[i5][j];
                    ++j;
                }
            }
            ++i5;
        }
        j2 = nn - 1;
        while (j2 >= low) {
            i = low;
            while (i <= high) {
                z = 0.0f;
                int k = low;
                while (k <= Math.min(j2, high)) {
                    z += this.V[i][k] * this.H[k][j2];
                    ++k;
                }
                this.V[i][j2] = z;
                ++i;
            }
            --j2;
        }
    }

    private void orthes() {
        int low = 0;
        int high = this.n - 1;
        int m = low + 1;
        while (m <= high - 1) {
            float scale = 0.0f;
            int i = m;
            while (i <= high) {
                scale += Math.abs(this.H[i][m - 1]);
                ++i;
            }
            if (scale != 0.0f) {
                float f;
                float h = 0.0f;
                int i2 = high;
                while (i2 >= m) {
                    this.ort[i2] = this.H[i2][m - 1] / scale;
                    h += this.ort[i2] * this.ort[i2];
                    --i2;
                }
                float g = (float)Math.sqrt(h);
                if (this.ort[m] > 0.0f) {
                    g = -g;
                }
                h -= this.ort[m] * g;
                this.ort[m] = this.ort[m] - g;
                int j = m;
                while (j < this.n) {
                    f = 0.0f;
                    int i3 = high;
                    while (i3 >= m) {
                        f += this.ort[i3] * this.H[i3][j];
                        --i3;
                    }
                    f /= h;
                    i3 = m;
                    while (i3 <= high) {
                        float[] fArray = this.H[i3];
                        int n = j;
                        fArray[n] = fArray[n] - f * this.ort[i3];
                        ++i3;
                    }
                    ++j;
                }
                int i4 = 0;
                while (i4 <= high) {
                    f = 0.0f;
                    int j2 = high;
                    while (j2 >= m) {
                        f += this.ort[j2] * this.H[i4][j2];
                        --j2;
                    }
                    f /= h;
                    j2 = m;
                    while (j2 <= high) {
                        float[] fArray = this.H[i4];
                        int n = j2;
                        fArray[n] = fArray[n] - f * this.ort[j2];
                        ++j2;
                    }
                    ++i4;
                }
                this.ort[m] = scale * this.ort[m];
                this.H[m][m - 1] = scale * g;
            }
            ++m;
        }
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.V[i][j] = i == j ? 1.0f : 0.0f;
                ++j;
            }
            ++i;
        }
        m = high - 1;
        while (m >= low + 1) {
            if (this.H[m][m - 1] != 0.0f) {
                int i5 = m + 1;
                while (i5 <= high) {
                    this.ort[i5] = this.H[i5][m - 1];
                    ++i5;
                }
                int j = m;
                while (j <= high) {
                    float g = 0.0f;
                    int i6 = m;
                    while (i6 <= high) {
                        g += this.ort[i6] * this.V[i6][j];
                        ++i6;
                    }
                    g = g / this.ort[m] / this.H[m][m - 1];
                    i6 = m;
                    while (i6 <= high) {
                        float[] fArray = this.V[i6];
                        int n = j;
                        fArray[n] = fArray[n] + g * this.ort[i6];
                        ++i6;
                    }
                    ++j;
                }
            }
            --m;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("---------------------------------------------------------------------\n");
        buf.append("EigenvalueDecomposition(A) --> D, V, realEigenvalues, imagEigenvalues\n");
        buf.append("---------------------------------------------------------------------\n");
        buf.append("realEigenvalues = ");
        try {
            buf.append(String.valueOf(this.getRealEigenvalues()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\nimagEigenvalues = ");
        try {
            buf.append(String.valueOf(this.getImagEigenvalues()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nD = ");
        try {
            buf.append(String.valueOf(this.getD()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nV = ");
        try {
            buf.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }

    private void tql2() {
        int i = 1;
        while (i < this.n) {
            this.e[i - 1] = this.e[i];
            ++i;
        }
        this.e[this.n - 1] = 0.0f;
        float f = 0.0f;
        float tst1 = 0.0f;
        float eps = (float)Math.pow(2.0, -23.0);
        int l = 0;
        while (l < this.n) {
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            int m = l;
            while (m < this.n) {
                if (Math.abs(this.e[m]) <= eps * tst1) break;
                ++m;
            }
            if (m > l) {
                int iter = 0;
                do {
                    float c;
                    ++iter;
                    float g = this.d[l];
                    float p = (this.d[l + 1] - g) / (2.0f * this.e[l]);
                    float r = DenseFloatAlgebra.hypot(p, 1.0f);
                    if (p < 0.0f) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    float dl1 = this.d[l + 1];
                    float h = g - this.d[l];
                    int i2 = l + 2;
                    while (i2 < this.n) {
                        int n = i2++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    float c2 = c = 1.0f;
                    float c3 = c;
                    float el1 = this.e[l + 1];
                    float s = 0.0f;
                    float s2 = 0.0f;
                    int i3 = m - 1;
                    while (i3 >= l) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i3];
                        h = c * p;
                        r = DenseFloatAlgebra.hypot(p, this.e[i3]);
                        this.e[i3 + 1] = s * r;
                        s = this.e[i3] / r;
                        c = p / r;
                        p = c * this.d[i3] - s * g;
                        this.d[i3 + 1] = h + s * (c * g + s * this.d[i3]);
                        int k = 0;
                        while (k < this.n) {
                            h = this.V[k][i3 + 1];
                            this.V[k][i3 + 1] = s * this.V[k][i3] + c * h;
                            this.V[k][i3] = c * this.V[k][i3] - s * h;
                            ++k;
                        }
                        --i3;
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0f;
            ++l;
        }
        int i4 = 0;
        while (i4 < this.n - 1) {
            int k = i4;
            float p = this.d[i4];
            int j = i4 + 1;
            while (j < this.n) {
                if (this.d[j] < p) {
                    k = j;
                    p = this.d[j];
                }
                ++j;
            }
            if (k != i4) {
                this.d[k] = this.d[i4];
                this.d[i4] = p;
                j = 0;
                while (j < this.n) {
                    p = this.V[j][i4];
                    this.V[j][i4] = this.V[j][k];
                    this.V[j][k] = p;
                    ++j;
                }
            }
            ++i4;
        }
    }

    private void tred2() {
        int j = 0;
        while (j < this.n) {
            this.d[j] = this.V[this.n - 1][j];
            ++j;
        }
        int i = this.n - 1;
        while (i > 0) {
            float scale = 0.0f;
            float h = 0.0f;
            int k = 0;
            while (k < i) {
                scale += Math.abs(this.d[k]);
                ++k;
            }
            if (scale == 0.0f) {
                this.e[i] = this.d[i - 1];
                int j2 = 0;
                while (j2 < i) {
                    this.d[j2] = this.V[i - 1][j2];
                    this.V[i][j2] = 0.0f;
                    this.V[j2][i] = 0.0f;
                    ++j2;
                }
            } else {
                k = 0;
                while (k < i) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                    ++k;
                }
                float f = this.d[i - 1];
                float g = (float)Math.sqrt(h);
                if (f > 0.0f) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                int j3 = 0;
                while (j3 < i) {
                    this.e[j3] = 0.0f;
                    ++j3;
                }
                j3 = 0;
                while (j3 < i) {
                    this.V[j3][i] = f = this.d[j3];
                    g = this.e[j3] + this.V[j3][j3] * f;
                    int k2 = j3 + 1;
                    while (k2 <= i - 1) {
                        g += this.V[k2][j3] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V[k2][j3] * f;
                        ++k2;
                    }
                    this.e[j3] = g;
                    ++j3;
                }
                f = 0.0f;
                j3 = 0;
                while (j3 < i) {
                    int n = j3;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j3] * this.d[j3];
                    ++j3;
                }
                float hh = f / (h + h);
                int j4 = 0;
                while (j4 < i) {
                    int n = j4;
                    this.e[n] = this.e[n] - hh * this.d[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < i) {
                    f = this.d[j4];
                    g = this.e[j4];
                    int k3 = j4;
                    while (k3 <= i - 1) {
                        float[] fArray = this.V[k3];
                        int n = j4;
                        fArray[n] = fArray[n] - (f * this.e[k3] + g * this.d[k3]);
                        ++k3;
                    }
                    this.d[j4] = this.V[i - 1][j4];
                    this.V[i][j4] = 0.0f;
                    ++j4;
                }
            }
            this.d[i] = h;
            --i;
        }
        i = 0;
        while (i < this.n - 1) {
            this.V[this.n - 1][i] = this.V[i][i];
            this.V[i][i] = 1.0f;
            float h = this.d[i + 1];
            if (h != 0.0f) {
                int k = 0;
                while (k <= i) {
                    this.d[k] = this.V[k][i + 1] / h;
                    ++k;
                }
                int j5 = 0;
                while (j5 <= i) {
                    float g = 0.0f;
                    int k4 = 0;
                    while (k4 <= i) {
                        g += this.V[k4][i + 1] * this.V[k4][j5];
                        ++k4;
                    }
                    k4 = 0;
                    while (k4 <= i) {
                        float[] fArray = this.V[k4];
                        int n = j5;
                        fArray[n] = fArray[n] - g * this.d[k4];
                        ++k4;
                    }
                    ++j5;
                }
            }
            int k = 0;
            while (k <= i) {
                this.V[k][i + 1] = 0.0f;
                ++k;
            }
            ++i;
        }
        j = 0;
        while (j < this.n) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0f;
            ++j;
        }
        this.V[this.n - 1][this.n - 1] = 1.0f;
        this.e[0] = 0.0f;
    }
}

