/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.Float9Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.function.tfloat.IntIntFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix2D
extends FloatMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private FloatFFT_2D fft2;
    private FloatDCT_2D dct2;
    private FloatDST_2D dst2;
    private FloatDHT_2D dht2;
    protected float[] elements;

    public DenseFloatMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseFloatMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new float[rows * columns];
    }

    public DenseFloatMatrix2D(int rows, int columns, float[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    public DenseFloatMatrix2D(MatrixVectorReader reader) throws IOException {
        block9: {
            int i;
            float[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block8: {
                info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = reader.readMatrixSize(info);
                this.setUp(size.numRows(), size.numColumns());
                this.elements = new float[this.rows * this.columns];
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new float[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                i = 0;
                while (i < numEntries) {
                    this.setQuick(rowIndexes[i], columnIndexes[i], values[i]);
                    ++i;
                }
                if (!info.isSymmetric()) break block8;
                i = 0;
                while (i < numEntries) {
                    if (rowIndexes[i] != columnIndexes[i]) {
                        this.setQuick(columnIndexes[i], rowIndexes[i], values[i]);
                    }
                    ++i;
                }
                break block9;
            }
            if (!info.isSkewSymmetric()) break block9;
            i = 0;
            while (i < numEntries) {
                if (rowIndexes[i] != columnIndexes[i]) {
                    this.setQuick(columnIndexes[i], rowIndexes[i], -values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = this.rows - j * k;
                final int lastRow = j == nthreads - 1 ? 0 : firstRow - k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseFloatMatrix2D.this.elements[zero + (firstRow - 1) * DenseFloatMatrix2D.this.rowStride + (DenseFloatMatrix2D.this.columns - 1) * DenseFloatMatrix2D.this.columnStride]);
                        int d = 1;
                        int r = firstRow;
                        while (--r >= lastRow) {
                            int ridx = zero + r * DenseFloatMatrix2D.this.rowStride;
                            int c = DenseFloatMatrix2D.this.columns - d;
                            while (--c >= 0) {
                                a = aggr.apply(a, f.apply(DenseFloatMatrix2D.this.elements[ridx + c * DenseFloatMatrix2D.this.columnStride]));
                            }
                            d = 0;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int d = 1;
            int r = this.rows;
            while (--r >= 0) {
                int ridx = zero + r * this.rowStride;
                int c = this.columns - d;
                while (--c >= 0) {
                    a = aggr.apply(a, f.apply(this.elements[ridx + c * this.columnStride]));
                }
                d = 0;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, final FloatProcedure cond) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float elem = DenseFloatMatrix2D.this.elements[zero + firstRow * DenseFloatMatrix2D.this.rowStride];
                        float a = 0.0f;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                elem = DenseFloatMatrix2D.this.elements[zero + r * DenseFloatMatrix2D.this.rowStride + c * DenseFloatMatrix2D.this.columnStride];
                                if (cond.apply(elem)) {
                                    a = aggr.apply(a, f.apply(elem));
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            float elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = f.apply(this.elements[zero]);
            }
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (cond.apply(elem)) {
                        a = aggr.apply(a, f.apply(elem));
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseFloatMatrix2D.this.elements[zero + rowElements[firstIdx] * DenseFloatMatrix2D.this.rowStride + columnElements[firstIdx] * DenseFloatMatrix2D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            float elem = DenseFloatMatrix2D.this.elements[zero + rowElements[i] * DenseFloatMatrix2D.this.rowStride + columnElements[i] * DenseFloatMatrix2D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                float elem = this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public float aggregate(FloatMatrix2D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        if (!(other instanceof DenseFloatMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final float[] elementsOther = (float[])other.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseFloatMatrix2D.this.elements[zero + firstRow * DenseFloatMatrix2D.this.rowStride], elementsOther[zeroOther + firstRow * rowStrideOther]);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(DenseFloatMatrix2D.this.elements[zero + r * DenseFloatMatrix2D.this.rowStride + c * DenseFloatMatrix2D.this.columnStride], elementsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero], elementsOther[zeroOther]);
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride], elementsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public FloatMatrix2D assign(final FloatFunction function) {
        final float[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof FloatMult) {
                float multiplicator = ((FloatMult)function).multiplicator;
                if (multiplicator == 1.0f) {
                    return this;
                }
                if (multiplicator == 0.0f) {
                    return this.assign(0.0f);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        if (function instanceof FloatMult) {
                            float multiplicator = ((FloatMult)function).multiplicator;
                            if (multiplicator == 1.0f) {
                                return;
                            }
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    int n = i;
                                    elems[n] = elems[n] * multiplicator;
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                ++r;
                            }
                        } else {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    elems[i] = function.apply(elems[i]);
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (function instanceof FloatMult) {
                float multiplicator = ((FloatMult)function).multiplicator;
                if (multiplicator == 1.0f) {
                    return this;
                }
                if (multiplicator == 0.0f) {
                    return this.assign(0.0f);
                }
                int r = this.rows;
                while (--r >= 0) {
                    int i = idx;
                    int c = this.columns;
                    while (--c >= 0) {
                        int n = i;
                        elems[n] = elems[n] * multiplicator;
                        i -= this.columnStride;
                    }
                    idx -= this.rowStride;
                }
            } else {
                int r = this.rows;
                while (--r >= 0) {
                    int i = idx;
                    int c = this.columns;
                    while (--c >= 0) {
                        elems[i] = function.apply(elems[i]);
                        i -= this.columnStride;
                    }
                    idx -= this.rowStride;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final FloatProcedure cond, final FloatFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                float elem = DenseFloatMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseFloatMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    float elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final FloatProcedure cond, final float value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                float elem = DenseFloatMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseFloatMatrix2D.this.elements[i] = value;
                                }
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    float elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float value) {
        final float[] elems = this.elements;
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                elems[i] = value;
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    elems[i] = value;
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstRow * DenseFloatMatrix2D.this.columns;
                            int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    DenseFloatMatrix2D.this.elements[i] = values[idxOther++];
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = values[idxOther++];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(final float[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstRow * DenseFloatMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                float[] currentRow = values[r];
                                if (currentRow.length != DenseFloatMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseFloatMatrix2D.this.columns());
                                }
                                System.arraycopy(currentRow, 0, DenseFloatMatrix2D.this.elements, i, DenseFloatMatrix2D.this.columns);
                                i += DenseFloatMatrix2D.this.columns;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i += this.columns;
                    ++r;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                float[] currentRow = values[r];
                                if (currentRow.length != DenseFloatMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseFloatMatrix2D.this.columns());
                                }
                                int i = idx;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    DenseFloatMatrix2D.this.elements[i] = currentRow[c];
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = currentRow[c];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
            return this;
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D source) {
        if (!(source instanceof DenseFloatMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseFloatMatrix2D other = (DenseFloatMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FloatMatrix2D c = other.copy();
            if (!(c instanceof DenseFloatMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseFloatMatrix2D)c;
        }
        final float[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                DenseFloatMatrix2D.this.elements[i] = elementsOther[j];
                                i += DenseFloatMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, final FloatFloatFunction function) {
        if (!(y instanceof DenseFloatMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseFloatMatrix2D other = (DenseFloatMatrix2D)y;
        this.checkShape(y);
        final float[] elementsOther = other.elements;
        if (this.elements == null || elementsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            float multiplicator;
            if (function instanceof FloatPlusMultSecond && (multiplicator = ((FloatPlusMultSecond)function).multiplicator) == 0.0f) {
                return this;
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (function == FloatFunctions.mult) {
                            int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    int n = i;
                                    DenseFloatMatrix2D.this.elements[n] = DenseFloatMatrix2D.this.elements[n] * elementsOther[j];
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function == FloatFunctions.div) {
                            int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    int n = i;
                                    DenseFloatMatrix2D.this.elements[n] = DenseFloatMatrix2D.this.elements[n] / elementsOther[j];
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function instanceof FloatPlusMultSecond) {
                            float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1.0f) {
                                int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseFloatMatrix2D.this.columns) {
                                        int n = i;
                                        DenseFloatMatrix2D.this.elements[n] = DenseFloatMatrix2D.this.elements[n] + elementsOther[j];
                                        i += DenseFloatMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseFloatMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            } else if (multiplicator == -1.0f) {
                                int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseFloatMatrix2D.this.columns) {
                                        int n = i;
                                        DenseFloatMatrix2D.this.elements[n] = DenseFloatMatrix2D.this.elements[n] - elementsOther[j];
                                        i += DenseFloatMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseFloatMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            } else {
                                int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseFloatMatrix2D.this.columns) {
                                        int n = i;
                                        DenseFloatMatrix2D.this.elements[n] = DenseFloatMatrix2D.this.elements[n] + multiplicator * elementsOther[j];
                                        i += DenseFloatMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseFloatMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            }
                        } else {
                            int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseFloatMatrix2D.this.columns) {
                                    DenseFloatMatrix2D.this.elements[i] = function.apply(DenseFloatMatrix2D.this.elements[i], elementsOther[j]);
                                    i += DenseFloatMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseFloatMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else if (function == FloatFunctions.mult) {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    int n = i;
                    this.elements[n] = this.elements[n] * elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        } else if (function == FloatFunctions.div) {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    int n = i;
                    this.elements[n] = this.elements[n] / elementsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        } else if (function instanceof FloatPlusMultSecond) {
            float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
            if (multiplicator == 0.0f) {
                return this;
            }
            if (multiplicator == 1.0f) {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] + elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else if (multiplicator == -1.0f) {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] - elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] + multiplicator * elementsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = function.apply(this.elements[i], elementsOther[j]);
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, final FloatFloatFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final float[] elementsOther = (float[])y.elements();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + rowElements[i] * DenseFloatMatrix2D.this.rowStride + columnElements[i] * DenseFloatMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseFloatMatrix2D.this.elements[idx] = function.apply(DenseFloatMatrix2D.this.elements[idx], elementsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                if (DenseFloatMatrix2D.this.elements[i] != 0.0f) {
                                    ++cardinality;
                                }
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    if (this.elements[i] != 0.0f) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return cardinality;
    }

    public void dct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.forward(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dct2.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dctColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).dct(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dct(scale);
                ++c;
            }
        }
    }

    public void dctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).dct(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dct(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.forward(this.elements);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dht2.forward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).dht();
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dht();
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dhtRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).dht();
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dht();
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.forward(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dst2.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).dst(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).dst(scale);
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).dst(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).dst(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realForward(this.elements);
        } else {
            FloatMatrix2D copy = this.copy();
            this.fft2.realForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public FloatMatrix2D forEachNonZero(final IntIntFloatFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                float value = DenseFloatMatrix2D.this.elements[i];
                                if (value != 0.0f) {
                                    DenseFloatMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    float value = this.elements[i];
                    if (value != 0.0f) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    public DenseColumnFloatMatrix2D getColumnMajor() {
        DenseColumnFloatMatrix2D R = new DenseColumnFloatMatrix2D(this.rows, this.columns);
        final int zeroR = (int)R.index(0, 0);
        final int rowStrideR = R.rowStride();
        final int columnStrideR = R.columnStride();
        final float[] elementsR = R.elements();
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + (firstRow - 1) * DenseFloatMatrix2D.this.rowStride;
                        int idxR = zeroR + (firstRow - 1) * rowStrideR;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxR;
                            int c = 0;
                            while (r < DenseFloatMatrix2D.this.columns) {
                                elementsR[j] = DenseFloatMatrix2D.this.elements[i];
                                i += DenseFloatMatrix2D.this.rowStride;
                                j += rowStrideR;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.columnStride;
                            idxR += columnStrideR;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxR = zeroR;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxR;
                int c = 0;
                while (r < this.columns) {
                    elementsR[j] = this.elements[i];
                    i += this.rowStride;
                    j += rowStrideR;
                    ++c;
                }
                idx += this.columnStride;
                idxR += columnStrideR;
                ++r;
            }
        }
        return R;
    }

    public DenseFComplexMatrix2D getFft2() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        final float[] elementsA = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] elementsC = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            System.arraycopy(elementsA, r * DenseFloatMatrix2D.this.columns, elementsC, r * DenseFloatMatrix2D.this.columns, DenseFloatMatrix2D.this.columns);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                System.arraycopy(elementsA, r * this.columns, elementsC, r * this.columns, this.columns);
                ++r;
            }
        }
        this.fft2.realForwardFull(elementsC);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getFftColumns() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            C.viewColumn(c).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).getFft());
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                C.viewColumn(c).assign(((DenseFloatMatrix1D)this.viewColumn(c)).getFft());
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getFftRows() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            C.viewRow(r).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).getFft());
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                C.viewRow(r).assign(((DenseFloatMatrix1D)this.viewRow(r)).getFft());
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getIfft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        final float[] elementsC = C.elements();
        final float[] elementsA = this.isNoView ? this.elements : (float[])this.copy().elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            System.arraycopy(elementsA, r * DenseFloatMatrix2D.this.columns, elementsC, r * DenseFloatMatrix2D.this.columns, DenseFloatMatrix2D.this.columns);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                System.arraycopy(elementsA, r * this.columns, elementsC, r * this.columns, this.columns);
                ++r;
            }
        }
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        this.fft2.realInverseFull(elementsC, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getIfftColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            C.viewColumn(c).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).getIfft(scale));
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                C.viewColumn(c).assign(((DenseFloatMatrix1D)this.viewColumn(c)).getIfft(scale));
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix2D getIfftRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix2D C = new DenseFComplexMatrix2D(this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            C.viewRow(r).assign(((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).getIfft(scale));
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                C.viewRow(r).assign(((DenseFloatMatrix1D)this.viewRow(r)).getIfft(scale));
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    @Override
    public float[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float maxValue = DenseFloatMatrix2D.this.elements[zero + firstRow * DenseFloatMatrix2D.this.rowStride];
                        int rowLocation = firstRow;
                        int colLocation = 0;
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                float elem = DenseFloatMatrix2D.this.elements[zero + r * DenseFloatMatrix2D.this.rowStride + c * DenseFloatMatrix2D.this.columnStride];
                                if (maxValue < elem) {
                                    maxValue = elem;
                                    rowLocation = r;
                                    colLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new float[]{maxValue, rowLocation, colLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    float elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (maxValue < elem) {
                        maxValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new float[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public float[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        float minValue = DenseFloatMatrix2D.this.elements[zero + firstRow * DenseFloatMatrix2D.this.rowStride];
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                float elem = DenseFloatMatrix2D.this.elements[zero + r * DenseFloatMatrix2D.this.rowStride + c * DenseFloatMatrix2D.this.columnStride];
                                if (minValue > elem) {
                                    minValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new float[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = (int)results[0][1];
                columnLocation = (int)results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = (int)results[j][1];
                        columnLocation = (int)results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    float elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (minValue > elem) {
                        minValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new float[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                float value = this.elements[i];
                if (value < 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                float value = this.elements[i];
                if (value != 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                float value = this.elements[i];
                if (value > 0.0f) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public float getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct2 == null) {
            this.dct2 = new FloatDCT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct2.inverse(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dct2.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).idct(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idct(scale);
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idctRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).idct(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idct(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht2 == null) {
            this.dht2 = new FloatDHT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht2.inverse(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dht2.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).idht(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idht(scale);
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idhtRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).idht(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idht(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst2 == null) {
            this.dst2 = new FloatDST_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst2.inverse(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.dst2.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstColumns(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewColumn(c)).idst(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseFloatMatrix1D)this.viewColumn(c)).idst(scale);
                ++c;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idstRows(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseFloatMatrix1D)DenseFloatMatrix2D.this.viewRow(r)).idst(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseFloatMatrix1D)this.viewRow(r)).idst(scale);
                ++r;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft2(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new FloatFFT_2D(this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft2.realInverse(this.elements, scale);
        } else {
            FloatMatrix2D copy = this.copy();
            this.fft2.realInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return new DenseFloatMatrix2D(rows, columns);
    }

    @Override
    public FloatMatrix1D like1D(int size) {
        return new DenseFloatMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, float value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public float[][] toArray() {
        final float[][] values = new float[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            float[] currentRow = values[r];
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                currentRow[c] = DenseFloatMatrix2D.this.elements[i];
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                float[] currentRow = values[r];
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    currentRow[c] = this.elements[i];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return values;
    }

    @Override
    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D v = new DenseFloatMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)v.index(0);
        final int strideOther = v.stride();
        final float[] elementsOther = v.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + firstColumn * DenseFloatMatrix2D.this.rows;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            idx = zero + c * DenseFloatMatrix2D.this.columnStride;
                            int r = 0;
                            while (r < DenseFloatMatrix2D.this.rows) {
                                elementsOther[idxOther] = DenseFloatMatrix2D.this.elements[idx];
                                idx += DenseFloatMatrix2D.this.rowStride;
                                idxOther += strideOther;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                idx = zero + c * this.columnStride;
                int r = 0;
                while (r < this.rows) {
                    elementsOther[idxOther] = this.elements[idx];
                    idx += this.rowStride;
                    idxOther += strideOther;
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public void zAssign8Neighbors(FloatMatrix2D B, Float9Function function) {
        if (!(B instanceof DenseFloatMatrix2D)) {
            super.zAssign8Neighbors(B, function);
            return;
        }
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        int r = this.rows - 1;
        int c = this.columns - 1;
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        DenseFloatMatrix2D BB = (DenseFloatMatrix2D)B;
        int A_rs = this.rowStride;
        int B_rs = BB.rowStride;
        int A_cs = this.columnStride;
        int B_cs = BB.columnStride;
        float[] elems = this.elements;
        float[] B_elems = BB.elements;
        if (elems == null || B_elems == null) {
            throw new InternalError();
        }
        int A_index = (int)this.index(1, 1);
        int B_index = (int)BB.index(1, 1);
        int i = 1;
        while (i < r) {
            int B11 = B_index;
            int A02 = A_index - A_rs - A_cs;
            int A12 = A02 + A_rs;
            int A22 = A12 + A_rs;
            float a00 = elems[A02];
            float a01 = elems[A02 += A_cs];
            float a10 = elems[A12];
            float a11 = elems[A12 += A_cs];
            float a20 = elems[A22];
            float a21 = elems[A22 += A_cs];
            int j = 1;
            while (j < c) {
                float a02 = elems[A02 += A_cs];
                float a12 = elems[A12 += A_cs];
                float a22 = elems[A22 += A_cs];
                B_elems[B11] = function.apply(a00, a01, a02, a10, a11, a12, a20, a21, a22);
                B11 += B_cs;
                a00 = a01;
                a01 = a02;
                a10 = a11;
                a11 = a12;
                a20 = a21;
                a21 = a22;
                ++j;
            }
            A_index += A_rs;
            B_index += B_rs;
            ++i;
        }
    }

    @Override
    public FloatMatrix1D zMult(FloatMatrix1D y, FloatMatrix1D z, final float alpha, final float beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseFloatMatrix1D(this.rows);
        }
        if (!(y instanceof DenseFloatMatrix1D) || !(z instanceof DenseFloatMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)this.columns != y.size() || (long)this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        final float[] elemsY = (float[])y.elements();
        final float[] elemsZ = (float[])z.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = z.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)z.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxZero = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        int r = firstRow;
                        while (r < lastRow) {
                            float sum = 0.0f;
                            int idx = idxZero;
                            int idxY = zeroY;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                sum += DenseFloatMatrix2D.this.elements[idx] * elemsY[idxY];
                                idx += DenseFloatMatrix2D.this.columnStride;
                                idxY += strideY;
                                ++c;
                            }
                            elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                            idxZero += DenseFloatMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            int r = 0;
            while (r < this.rows) {
                float sum = 0.0f;
                int idx = idxZero;
                int idxY = zeroY;
                int c = 0;
                while (c < this.columns) {
                    sum += this.elements[idx] * elemsY[idxY];
                    idx += this.columnStride;
                    idxY += strideY;
                    ++c;
                }
                elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
                ++r;
            }
        }
        return z;
    }

    @Override
    public FloatMatrix2D zMult(FloatMatrix2D B, FloatMatrix2D C, final float alpha, final float beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseFloatMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseFloatMatrix2D || B instanceof SparseRCFloatMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        if (!(C instanceof DenseFloatMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSequential(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        int i = 0;
        while (i < noOfTasks) {
            FloatMatrix2D CC;
            FloatMatrix2D BB;
            FloatMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseFloatMatrix2D)AA).zMultSequential(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    @Override
    public float zSum() {
        float sum = 0.0f;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        int idx = zero + firstRow * DenseFloatMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseFloatMatrix2D.this.columns) {
                                sum += DenseFloatMatrix2D.this.elements[i];
                                i += DenseFloatMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseFloatMatrix2D.this.rowStride;
                            ++r;
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Float)futures[j].get()).floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    sum += this.elements[i];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return sum;
    }

    private FloatMatrix2D zMultSequential(FloatMatrix2D B, FloatMatrix2D C, float alpha, float beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseFloatMatrix2D || B instanceof SparseRCFloatMatrix2D || B instanceof SparseCCFloatMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseFloatMatrix2D(rowsA, p);
        }
        if (!(B instanceof DenseFloatMatrix2D) || !(C instanceof DenseFloatMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseFloatMatrix2D BB = (DenseFloatMatrix2D)B;
        DenseFloatMatrix2D CC = (DenseFloatMatrix2D)C;
        float[] AElems = this.elements;
        float[] BElems = BB.elements;
        float[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - columnsA) / (columnsA + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = rowsA / m_optimal;
        int rr = 0;
        if (rowsA % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += rowsA - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    int kA = iA;
                    int kB = jB;
                    float s = 0.0f;
                    kA -= cA;
                    kB -= rB;
                    int k = columnsA % 4;
                    while (--k >= 0) {
                        s += AElems[kA += cA] * BElems[kB += rB];
                    }
                    k = columnsA / 4;
                    while (--k >= 0) {
                        int n = kA + cA;
                        kA = n;
                        int n2 = kB + rB;
                        kB = n2;
                        int n3 = kA + cA;
                        kA = n3;
                        int n4 = kB + rB;
                        kB = n4;
                        kA = kA + cA;
                        kB = kB + rB;
                        s += AElems[n] * BElems[n2] + AElems[n3] * BElems[n4] + AElems[kA] * BElems[kB] + AElems[kA += cA] * BElems[kB += rB];
                    }
                    CElems[iC] = alpha * s + beta * CElems[iC];
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix2D other) {
        if (other instanceof SelectedDenseFloatMatrix2D) {
            SelectedDenseFloatMatrix2D otherMatrix = (SelectedDenseFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFloatMatrix2D) {
            DenseFloatMatrix2D otherMatrix = (DenseFloatMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix1D like1D(int size, int zero, int stride) {
        return new DenseFloatMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected FloatMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseFloatMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

