/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class IntFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory2D dense = new IntFactory2D();
    public static final IntFactory2D sparse = new IntFactory2D();
    public static final IntFactory2D rowCompressed = new IntFactory2D();

    protected IntFactory2D() {
    }

    public IntMatrix2D appendColumns(IntMatrix2D A, IntMatrix2D B) {
        if (B.rows() > A.rows()) {
            B = B.viewPart(0, 0, A.rows(), B.columns());
        } else if (B.rows() < A.rows()) {
            A = A.viewPart(0, 0, B.rows(), A.columns());
        }
        int ac = A.columns();
        int bc = B.columns();
        int r = A.rows();
        IntMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public IntMatrix2D appendColumn(IntMatrix2D A, IntMatrix1D b) {
        if (b.size() > (long)A.rows()) {
            b = b.viewPart(0, A.rows());
        } else if (b.size() < (long)A.rows()) {
            A = A.viewPart(0, 0, (int)b.size(), A.columns());
        }
        int ac = A.columns();
        int bc = 1;
        int r = A.rows();
        IntMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A);
        matrix.viewColumn(ac).assign(b);
        return matrix;
    }

    public IntMatrix2D appendRows(IntMatrix2D A, IntMatrix2D B) {
        if (B.columns() > A.columns()) {
            B = B.viewPart(0, 0, B.rows(), A.columns());
        } else if (B.columns() < A.columns()) {
            A = A.viewPart(0, 0, A.rows(), B.columns());
        }
        int ar = A.rows();
        int br = B.rows();
        int c = A.columns();
        IntMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public IntMatrix2D appendRow(IntMatrix2D A, IntMatrix1D b) {
        if (b.size() > (long)A.columns()) {
            b = b.viewPart(0, A.columns());
        } else if (b.size() < (long)A.columns()) {
            A = A.viewPart(0, 0, A.rows(), (int)b.size());
        }
        int ar = A.rows();
        int br = 1;
        int c = A.columns();
        IntMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A);
        matrix.viewRow(ar).assign(b);
        return matrix;
    }

    public IntMatrix2D ascending(int rows, int columns) {
        IntFunctions F = IntFunctions.intFunctions;
        return this.descending(rows, columns).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(columns * rows)));
    }

    protected static void checkRectangularShape(int[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(IntMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public IntMatrix2D reshape(IntMatrix1D a, int rows, int columns) {
        if (a.size() != (long)(rows * columns)) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        IntMatrix2D A = this == sparse ? new SparseIntMatrix2D(rows, columns) : new DenseIntMatrix2D(rows, columns);
        int c = 0;
        while (c < columns) {
            A.viewColumn(c).assign(a.viewPart(c * rows, rows));
            ++c;
        }
        return A;
    }

    public IntMatrix2D compose(IntMatrix2D[][] parts) {
        int row;
        IntFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        IntMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                IntMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                IntMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        IntMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        int row3 = 0;
        while (row3 < rows) {
            int c = 0;
            int column4 = 0;
            while (column4 < columns) {
                IntMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
                ++column4;
            }
            r += maxHeights[row3];
            ++row3;
        }
        return matrix;
    }

    public IntMatrix2D composeDiagonal(IntMatrix2D A, IntMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        IntMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public IntMatrix2D composeDiagonal(IntMatrix2D A, IntMatrix2D B, IntMatrix2D C) {
        IntMatrix2D diag = this.make(A.rows() + B.rows() + C.rows(), A.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A.rows(), A.columns()).assign(A);
        diag.viewPart(A.rows(), A.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A.rows() + B.rows(), A.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public IntMatrix2D composeBidiagonal(IntMatrix2D A, IntMatrix2D B) {
        int ar = A.rows();
        int ac = A.columns();
        int br = B.rows();
        int bc = B.columns();
        IntMatrix2D sum = this.make(ar + br - 1, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A);
        sum.viewPart(ar - 1, ac, br, bc).assign(B);
        return sum;
    }

    public void decompose(IntMatrix2D[][] parts, IntMatrix2D matrix) {
        int row;
        IntFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                IntMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                IntMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        int row3 = 0;
        while (row3 < rows) {
            int c = 0;
            int column4 = 0;
            while (column4 < columns) {
                IntMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
                ++column4;
            }
            r += maxHeights[row3];
            ++row3;
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        IntMatrix2D[][] intMatrix2DArray = new IntMatrix2D[3][];
        IntMatrix2D[] intMatrix2DArray2 = new IntMatrix2D[3];
        intMatrix2DArray2[1] = this.make(2, 2, 1);
        intMatrix2DArray[0] = intMatrix2DArray2;
        IntMatrix2D[] intMatrix2DArray3 = new IntMatrix2D[3];
        intMatrix2DArray3[0] = this.make(4, 4, 2);
        intMatrix2DArray3[2] = this.make(4, 3, 3);
        intMatrix2DArray[1] = intMatrix2DArray3;
        IntMatrix2D[] intMatrix2DArray4 = new IntMatrix2D[3];
        intMatrix2DArray4[1] = this.make(2, 2, 4);
        intMatrix2DArray[2] = intMatrix2DArray4;
        IntMatrix2D[][] parts1 = intMatrix2DArray;
        System.out.println("\n" + this.compose(parts1));
        IntMatrix2D[][] intMatrix2DArray5 = new IntMatrix2D[3][];
        IntMatrix2D[] intMatrix2DArray6 = new IntMatrix2D[2];
        intMatrix2DArray6[0] = this.identity(3);
        intMatrix2DArray5[0] = intMatrix2DArray6;
        IntMatrix2D[] intMatrix2DArray7 = new IntMatrix2D[2];
        intMatrix2DArray7[1] = this.identity(3).viewColumnFlip();
        intMatrix2DArray5[1] = intMatrix2DArray7;
        IntMatrix2D[] intMatrix2DArray8 = new IntMatrix2D[2];
        intMatrix2DArray8[0] = this.identity(3).viewRowFlip();
        intMatrix2DArray5[2] = intMatrix2DArray8;
        IntMatrix2D[][] parts3 = intMatrix2DArray5;
        System.out.println("\n" + this.compose(parts3));
        IntMatrix2D A = this.ascending(2, 2);
        IntMatrix2D B = this.descending(2, 2);
        Object _ = null;
        IntMatrix2D[][] parts4 = new IntMatrix2D[][]{{A, _, A, _}, {_, A, _, B}};
        System.out.println("\n" + this.compose(parts4));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        IntMatrix2D A = this.make(2, 2, 1);
        IntMatrix2D B = this.make(4, 4, 2);
        IntMatrix2D C = this.make(4, 3, 3);
        IntMatrix2D D = this.make(2, 2, 4);
        IntMatrix2D[][] parts1 = new IntMatrix2D[][]{{_, A, _}, {B, _, C}, {_, D, _}};
        IntMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A.assign(9);
        B.assign(9);
        C.assign(9);
        D.assign(9);
        this.decompose(parts1, matrix);
        System.out.println(A);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public IntMatrix2D descending(int rows, int columns) {
        IntMatrix2D matrix = this.make(rows, columns);
        int v = 0;
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                matrix.setQuick(row, column, v++);
            }
        }
        return matrix;
    }

    public IntMatrix2D diagonal(IntMatrix1D vector) {
        int size = (int)vector.size();
        IntMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public IntMatrix2D diagonal(int[] vector) {
        int size = vector.length;
        IntMatrix2D diag = this.make(size, size);
        int i = 0;
        while (i < size) {
            diag.setQuick(i, i, vector[i]);
            ++i;
        }
        return diag;
    }

    public IntMatrix1D diagonal(IntMatrix2D A) {
        int min = Math.min(A.rows(), A.columns());
        IntMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A.getQuick(i, i));
        }
        return diag;
    }

    public IntMatrix2D identity(int rowsAndColumns) {
        IntMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, 1);
        }
        return matrix;
    }

    public IntMatrix2D make(int[][] values) {
        if (this == sparse) {
            return new SparseIntMatrix2D(values);
        }
        return new DenseIntMatrix2D(values);
    }

    public IntMatrix2D make(int[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        IntMatrix2D matrix = this.make(rows, columns);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                matrix.setQuick(row, column, values[row + column * rows]);
                ++column;
            }
            ++row;
        }
        return matrix;
    }

    public IntMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseIntMatrix2D(rows, columns);
        }
        if (this == rowCompressed) {
            return new SparseRCIntMatrix2D(rows, columns);
        }
        return new DenseIntMatrix2D(rows, columns);
    }

    public IntMatrix2D make(int rows, int columns, int initialValue) {
        if (initialValue == 0) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected IntMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public IntMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(IntFunctions.random());
    }

    public IntMatrix2D repeat(IntMatrix2D A, int rowRepeat, int columnRepeat) {
        int r = A.rows();
        int c = A.columns();
        IntMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A);
            }
        }
        return matrix;
    }

    public IntMatrix2D sample(int rows, int columns, int value, int nonZeroFraction) {
        IntMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public IntMatrix2D sample(IntMatrix2D matrix, int value, int nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        double epsilon = 1.0E-9;
        if ((double)nonZeroFraction < 0.0 - epsilon || (double)nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0) {
            nonZeroFraction = 0;
        }
        if (nonZeroFraction > 1) {
            nonZeroFraction = 1;
        }
        matrix.assign(0);
        int size = rows * columns;
        int n = Math.round(size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        int i = 0;
        while (i < size) {
            if (sampler.sampleNextElement()) {
                int row = i / columns;
                int column = i % columns;
                matrix.set(row, column, value);
            }
            ++i;
        }
        return matrix;
    }
}

