/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.epifluorescence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import microTiPi.microUtils.Zernike;
import microTiPi.microscopy.MicroscopeModel;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.DoubleArray;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Float4D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.MathUtils;
import org.jtransforms.fft.DoubleFFT_2D;
import org.jtransforms.fft.FloatFFT_2D;

public class WideFieldModel
extends MicroscopeModel {
    protected double deltaX = 0.0;
    protected double deltaY = 0.0;
    protected int Nzern;
    protected boolean radial = false;
    protected double lambda;
    protected double NA;
    protected double ni;
    protected double lambda_ni;
    protected double radius;
    protected double pupil_area;
    protected double[] Z;
    protected boolean[] maskPupil;
    protected boolean[] mapPupil;
    protected double[] rho;
    protected double[] phi;
    protected double[] psi;
    protected Array4D cpxPsf;
    protected Shape cpxPsfShape;
    protected Shape aShape;
    protected Shape psf2DShape;
    protected int nModulus;
    protected int nDefocus;
    protected int nPhase;
    public static final int DEFOCUS = 0;
    public static final int PHASE = 1;
    public static final int MODULUS = 2;
    public static final int[] parametersFlag = new int[]{0, 1, 2};
    private boolean para = true;

    public WideFieldModel(Shape shape, double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2) {
        this(shape, 0, 1, d, d2, d3, d4, d5, bl, bl2);
    }

    public WideFieldModel(Shape shape, int n, int n2, double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2) {
        super(shape, d4, d5, bl2);
        if (this.Nx != this.Ny) {
            throw new IllegalArgumentException("Nx should equal Ny");
        }
        this.lambda = d2;
        this.ni = d3;
        this.Nzern = 4;
        this.NA = d;
        this.radius = d / d2;
        this.lambda_ni = d3 / d2;
        this.phi = new double[this.Ny * this.Nx];
        this.psi = new double[this.Ny * this.Nx];
        this.radial = bl;
        this.cpxPsfShape = new Shape(2, this.Nx, this.Ny, this.Nz);
        this.aShape = new Shape(2, this.Nx, this.Ny);
        this.psf2DShape = new Shape(this.Nx, this.Ny);
        this.computeMaskPupil();
        this.nModulus = n2;
        if (this.nModulus < 1) {
            this.nModulus = 1;
        }
        this.parameterSpace = new DoubleShapedVectorSpace[3];
        this.parameterCoefs = new DoubleShapedVector[3];
        this.nPhase = n;
        this.setNModulus();
        this.setNPhase();
        this.setDefocus();
    }

    protected void computeZernike() {
        this.Z = Zernike.zernikeArray(this.Nzern, this.Nx, this.Ny, this.radius * this.dxy * (double)this.Nx, true, this.radial);
        this.Z = MathUtils.gram_schmidt_orthonormalization((double[])this.Z, (int)this.Nx, (int)this.Ny, (int)this.Nzern);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computePsf() {
        if (this.PState > 0) {
            return;
        }
        if (this.single) {
            this.cpxPsf = Float4D.create((Shape)this.cpxPsfShape);
            this.psf = Float3D.create((Shape)this.psfShape);
            final float f = (float)(1.0 / (double)(this.Nx * this.Ny * this.Nz));
            final int n = this.Nx * this.Ny;
            int n2 = Runtime.getRuntime().availableProcessors();
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            ArrayList<Future<GetPsfParaOut>> arrayList = new ArrayList<Future<GetPsfParaOut>>();
            int n3 = 0;
            while (n3 < this.Nz) {
                final int n4 = n3++;
                Callable<GetPsfParaOut> n7 = new Callable<GetPsfParaOut>(){

                    @Override
                    public GetPsfParaOut call() throws Exception {
                        GetPsfParaOut getPsfParaOut = new GetPsfParaOut(n, n4, WideFieldModel.this.single);
                        float[] fArray = new float[2 * n];
                        double d = n4 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(n4 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)n4 * WideFieldModel.this.dz;
                        for (int i = 0; i < n; ++i) {
                            double d2 = WideFieldModel.this.phi[i] + d * WideFieldModel.this.psi[i];
                            fArray[2 * i] = (float)(WideFieldModel.this.rho[i] * Math.cos(d2));
                            fArray[2 * i + 1] = (float)(WideFieldModel.this.rho[i] * Math.sin(d2));
                        }
                        FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        floatFFT_2D.complexForward(fArray);
                        for (int i = 0; i < n; ++i) {
                            ((float[])getPsfParaOut.outA)[2 * i] = fArray[2 * i];
                            ((float[])getPsfParaOut.outA)[2 * i + 1] = -fArray[2 * i + 1];
                            ((float[])getPsfParaOut.outPsf)[i] = (fArray[2 * i] * fArray[2 * i] + fArray[2 * i + 1] * fArray[2 * i + 1]) * f;
                        }
                        return getPsfParaOut;
                    }
                };
                arrayList.add(executorService.submit(n7));
            }
            executorService.shutdown();
            for (Future future : arrayList) {
                try {
                    GetPsfParaOut d3 = (GetPsfParaOut)future.get();
                    this.cpxPsf.slice(d3.idxz).assign((ShapedArray)Float3D.wrap((float[])((float[])d3.outA), (Shape)this.aShape));
                    this.psf.slice(d3.idxz).assign((ShapedArray)Float2D.wrap((float[])((float[])d3.outPsf), (Shape)this.psf2DShape));
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        } else if (this.para) {
            Object object;
            void var7_21;
            this.cpxPsf = Double4D.create((Shape)this.cpxPsfShape);
            this.psf = Double3D.create((Shape)this.psfShape);
            double d = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
            final int n = this.Nx * this.Ny;
            int n5 = Runtime.getRuntime().availableProcessors();
            ExecutorService executorService = Executors.newFixedThreadPool(n5);
            ArrayList<Future<GetPsfParaOut>> arrayList = new ArrayList<Future<GetPsfParaOut>>();
            boolean n6 = false;
            while (var7_21 < this.Nz) {
                void var8_26 = var7_21++;
                object = new Callable<GetPsfParaOut>((int)var8_26, d){
                    final /* synthetic */ int val$iz1;
                    final /* synthetic */ double val$PSFnorm;
                    {
                        this.val$iz1 = n2;
                        this.val$PSFnorm = d;
                    }

                    @Override
                    public GetPsfParaOut call() throws Exception {
                        GetPsfParaOut getPsfParaOut = new GetPsfParaOut(n, this.val$iz1, WideFieldModel.this.single);
                        double[] dArray = new double[2 * n];
                        double d = this.val$iz1 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(this.val$iz1 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)this.val$iz1 * WideFieldModel.this.dz;
                        for (int i = 0; i < n; ++i) {
                            double d2 = WideFieldModel.this.phi[i] + d * WideFieldModel.this.psi[i];
                            dArray[2 * i] = WideFieldModel.this.rho[i] * Math.cos(d2);
                            dArray[2 * i + 1] = WideFieldModel.this.rho[i] * Math.sin(d2);
                        }
                        DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        doubleFFT_2D.complexForward(dArray);
                        for (int i = 0; i < n; ++i) {
                            ((double[])getPsfParaOut.outA)[2 * i] = dArray[2 * i];
                            ((double[])getPsfParaOut.outA)[2 * i + 1] = -dArray[2 * i + 1];
                            ((double[])getPsfParaOut.outPsf)[i] = (dArray[2 * i] * dArray[2 * i] + dArray[2 * i + 1] * dArray[2 * i + 1]) * this.val$PSFnorm;
                        }
                        return getPsfParaOut;
                    }
                };
                arrayList.add(executorService.submit(object));
            }
            executorService.shutdown();
            for (Future future : arrayList) {
                try {
                    object = (GetPsfParaOut)future.get();
                    this.cpxPsf.slice(((GetPsfParaOut)object).idxz).assign((ShapedArray)Double3D.wrap((double[])((double[])((GetPsfParaOut)object).outA), (Shape)this.aShape));
                    this.psf.slice(((GetPsfParaOut)object).idxz).assign((ShapedArray)Double2D.wrap((double[])((double[])((GetPsfParaOut)object).outPsf), (Shape)this.psf2DShape));
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        } else {
            this.cpxPsf = Double4D.create((Shape)this.cpxPsfShape);
            this.psf = Double3D.create((Shape)this.psfShape);
            double d = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
            int n = this.Nx * this.Ny;
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (int i = 0; i < this.Nz; ++i) {
                int n2;
                double[] dArray = new double[2 * n];
                double d2 = i > this.Nz / 2 ? Math.PI * 2 * (double)(i - this.Nz) * this.dz : Math.PI * 2 * (double)i * this.dz;
                for (n2 = 0; n2 < n; ++n2) {
                    double d3 = this.phi[n2] + d2 * this.psi[n2];
                    dArray[2 * n2] = this.rho[n2] * Math.cos(d3);
                    dArray[2 * n2 + 1] = this.rho[n2] * Math.sin(d3);
                }
                doubleFFT_2D.complexForward(dArray);
                for (n2 = 0; n2 < this.Ny; ++n2) {
                    for (int j = 0; j < this.Nx; ++j) {
                        int n3 = j + this.Nx * n2;
                        ((Double4D)this.cpxPsf).set(0, j, n2, i, dArray[2 * n3]);
                        ((Double4D)this.cpxPsf).set(1, j, n2, i, -dArray[2 * n3 + 1]);
                        ((Double3D)this.psf).set(j, n2, i, (dArray[2 * n3] * dArray[2 * n3] + dArray[2 * n3 + 1] * dArray[2 * n3 + 1]) * d);
                    }
                }
            }
        }
        this.PState = 1;
    }

    @Override
    public DoubleShapedVector apply_Jacobian(ShapedVector shapedVector, ShapedVectorSpace shapedVectorSpace) {
        if (shapedVectorSpace == this.parameterSpace[0]) {
            return this.apply_J_defocus(shapedVector);
        }
        if (shapedVectorSpace == this.parameterSpace[1]) {
            return this.apply_J_phase(shapedVector);
        }
        if (shapedVectorSpace == this.parameterSpace[2]) {
            return this.apply_J_modulus(shapedVector);
        }
        throw new IllegalArgumentException("DoubleShapedVector grad does not belong to any space");
    }

    @Override
    public void setParam(DoubleShapedVector doubleShapedVector) {
        if (doubleShapedVector.getOwner() == this.parameterSpace[0]) {
            this.setDefocus(doubleShapedVector);
        } else if (doubleShapedVector.getOwner() == this.parameterSpace[1]) {
            this.setPhase(doubleShapedVector);
        } else if (doubleShapedVector.getOwner() == this.parameterSpace[2]) {
            this.setModulus(doubleShapedVector);
        } else {
            throw new IllegalArgumentException("DoubleShapedVector param does not belong to any space");
        }
    }

    public DoubleShapedVector apply_J_modulus(ShapedVector shapedVector) {
        final int n = this.Nx * this.Ny;
        double d = 0.0;
        final double d2 = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        final double d3 = 1.0 / this.parameterCoefs[2].norm2();
        Double1D double1D = Double1D.create((Shape)this.parameterSpace[2].getShape());
        double1D.fill(0.0);
        if (this.single) {
            if (this.para) {
                int n2 = Runtime.getRuntime().availableProcessors();
                ExecutorService executorService = Executors.newFixedThreadPool(n2);
                ArrayList<Future<ApplyJPhaOut>> arrayList = new ArrayList<Future<ApplyJPhaOut>>();
                int n3 = 0;
                while (n3 < this.Nz) {
                    final Float2D object = ((Float3D)shapedVector.asShapedArray()).slice(n3);
                    final int i = n3++;
                    Callable<ApplyJPhaOut> n8 = new Callable<ApplyJPhaOut>(){

                        @Override
                        public ApplyJPhaOut call() throws Exception {
                            int n6;
                            int n2;
                            double d = 0.0;
                            float[] fArray = new float[2 * n];
                            ApplyJPhaOut applyJPhaOut = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[2].getNumber());
                            d = i > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(i - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)i * WideFieldModel.this.dz;
                            for (int i2 = 0; i2 < WideFieldModel.this.Ny; ++i2) {
                                for (n2 = 0; n2 < WideFieldModel.this.Nx; ++n2) {
                                    n6 = n2 + WideFieldModel.this.Nx * i2;
                                    float f = object.get(n2, i2);
                                    fArray[2 * n6] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, n2, i2, i) * f;
                                    fArray[2 * n6 + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, n2, i2, i) * f;
                                }
                            }
                            FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            floatFFT_2D.complexForward(fArray);
                            for (n2 = 0; n2 < WideFieldModel.this.Ny; ++n2) {
                                for (n6 = 0; n6 < WideFieldModel.this.Nx; ++n6) {
                                    int n3 = n6 + n2 * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[n3]) continue;
                                    double d22 = WideFieldModel.this.phi[n3] + d * WideFieldModel.this.psi[n3];
                                    double d32 = WideFieldModel.this.rho[n3] * ((double)fArray[2 * n3] * Math.sin(d22) + (double)fArray[2 * n3 + 1] * Math.cos(d22));
                                    for (int i3 = 0; i3 < WideFieldModel.this.parameterSpace[2].getNumber(); ++i3) {
                                        int n4 = i3 * n + n3;
                                        int n5 = i3;
                                        applyJPhaOut.grd[n5] = applyJPhaOut.grd[n5] + 2.0 * d2 * d32 * WideFieldModel.this.Z[n4] * (1.0 - Math.pow(WideFieldModel.this.parameterCoefs[2].get(i3) * d3, 2.0)) * d3;
                                    }
                                }
                            }
                            return applyJPhaOut;
                        }
                    };
                    arrayList.add(executorService.submit(n8));
                }
                executorService.shutdown();
                for (Future object : arrayList) {
                    try {
                        ApplyJPhaOut n11 = (ApplyJPhaOut)object.get();
                        for (int callable = 0; callable < this.parameterSpace[2].getNumber(); ++callable) {
                            double1D.set(callable, double1D.get(callable) + n11.grd[callable]);
                        }
                    }
                    catch (InterruptedException i) {
                        i.printStackTrace();
                    }
                    catch (ExecutionException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            } else {
                int n2;
                int n6;
                double[] dArray = new double[this.Ny * this.Nx];
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                for (n6 = 0; n6 < this.Nz; ++n6) {
                    int n16;
                    float[] fArray = new float[2 * n];
                    d = n6 > this.Nz / 2 ? Math.PI * 2 * (double)(n6 - this.Nz) * this.dz : Math.PI * 2 * (double)n6 * this.dz;
                    for (n16 = 0; n16 < this.Ny; ++n16) {
                        for (int dArray2 = 0; dArray2 < this.Nx; ++dArray2) {
                            int executionException = dArray2 + this.Nx * n16;
                            float f = ((Float3D)shapedVector.asShapedArray()).get(dArray2, n16, n6);
                            fArray[2 * executionException] = ((Float4D)this.cpxPsf).get(0, dArray2, n16, n6) * f;
                            fArray[2 * executionException + 1] = ((Float4D)this.cpxPsf).get(1, dArray2, n16, n6) * f;
                        }
                    }
                    floatFFT_2D.complexForward(fArray);
                    for (n16 = 0; n16 < n; ++n16) {
                        n2 = n6 * n + n16;
                        double i = this.phi[n16] + d * this.psi[n16];
                        dArray[n16] = dArray[n16] + (double)fArray[2 * n16] * Math.cos(i) - (double)fArray[2 * n16 + 1] * Math.sin(i);
                    }
                }
                for (n6 = 0; n6 < this.parameterSpace[2].getNumber(); ++n6) {
                    double d5 = 0.0;
                    for (int d8 = 0; d8 < n; ++d8) {
                        n2 = n6 * n + d8;
                        d5 += dArray[d8] * this.Z[n2];
                    }
                    double1D.set(n6, 2.0 * d2 * d5 * (1.0 - Math.pow(this.parameterCoefs[2].get(n6) * d3, 2.0)) * d3);
                }
            }
        } else if (this.para) {
            int n9 = Runtime.getRuntime().availableProcessors();
            ExecutorService executorService = Executors.newFixedThreadPool(n9);
            ArrayList<Future<double[]>> arrayList = new ArrayList<Future<double[]>>();
            int n10 = 0;
            while (n10 < this.Nz) {
                final Double2D d9 = ((Double3D)shapedVector.asShapedArray()).slice(n10);
                final int n3 = n10++;
                Callable<double[]> n14 = new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n4;
                        double d = 0.0;
                        double[] dArray = new double[2 * n];
                        double[] dArray2 = new double[n];
                        d = n3 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(n3 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)n3 * WideFieldModel.this.dz;
                        for (int i = 0; i < WideFieldModel.this.Ny; ++i) {
                            for (n4 = 0; n4 < WideFieldModel.this.Nx; ++n4) {
                                int n2 = n4 + WideFieldModel.this.Nx * i;
                                double d2 = d9.get(n4, i);
                                dArray[2 * n2] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, n4, i, n3) * d2;
                                dArray[2 * n2 + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, n4, i, n3) * d2;
                            }
                        }
                        DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        doubleFFT_2D.complexForward(dArray);
                        for (n4 = 0; n4 < n; ++n4) {
                            double d3 = WideFieldModel.this.phi[n4] + d * WideFieldModel.this.psi[n4];
                            dArray2[n4] = dArray2[n4] + dArray[2 * n4] * Math.cos(d3) - dArray[2 * n4 + 1] * Math.sin(d3);
                        }
                        return dArray2;
                    }
                };
                arrayList.add(executorService.submit(n14));
            }
            executorService.shutdown();
            for (Future future : arrayList) {
                try {
                    double[] dArray = (double[])future.get();
                    for (int i = 0; i < this.parameterSpace[2].getNumber(); ++i) {
                        double d4 = 0.0;
                        for (int j = 0; j < n; ++j) {
                            int n4 = i * n + j;
                            d4 += dArray[j] * this.Z[n4];
                        }
                        double1D.set(i, 2.0 * d2 * d4 * (1.0 - Math.pow(this.parameterCoefs[2].get(i) * d3, 2.0)) * d3);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        } else {
            int n5;
            int n6;
            int n15;
            double[] dArray = new double[this.Ny * this.Nx];
            double[] dArray2 = new double[2 * n];
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (n15 = 0; n15 < this.Nz; ++n15) {
                int n7;
                d = n15 > this.Nz / 2 ? Math.PI * 2 * (double)(n15 - this.Nz) * this.dz : Math.PI * 2 * (double)n15 * this.dz;
                for (n7 = 0; n7 < this.Ny; ++n7) {
                    for (int i = 0; i < this.Nx; ++i) {
                        n6 = i + this.Nx * n7;
                        double d5 = ((Double3D)shapedVector.asShapedArray()).get(i, n7, n15);
                        dArray2[2 * n6] = ((Double4D)this.cpxPsf).get(0, i, n7, n15) * d5;
                        dArray2[2 * n6 + 1] = ((Double4D)this.cpxPsf).get(1, i, n7, n15) * d5;
                    }
                }
                doubleFFT_2D.complexForward(dArray2);
                for (n7 = 0; n7 < n; ++n7) {
                    n5 = n15 * n + n7;
                    double d6 = this.phi[n7] + d * this.psi[n7];
                    dArray[n7] = dArray[n7] + dArray2[2 * n7] * Math.cos(d6) - dArray2[2 * n7 + 1] * Math.sin(d6);
                }
            }
            for (n15 = 0; n15 < this.parameterSpace[2].getNumber(); ++n15) {
                double d7 = 0.0;
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = n15 * n + n6;
                    d7 += dArray[n6] * this.Z[n5];
                }
                double1D.set(n15, 2.0 * d2 * d7 * (1.0 - Math.pow(this.parameterCoefs[2].get(n15) * d3, 2.0)) * d3);
            }
        }
        return this.parameterSpace[2].create((DoubleArray)double1D);
    }

    public DoubleShapedVector apply_J_phase(ShapedVector shapedVector) {
        final int n = this.Nx * this.Ny;
        final double d = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        Double1D double1D = Double1D.create((Shape)this.parameterSpace[1].getShape());
        double1D.fill(0.0);
        if (this.single) {
            if (this.para) {
                int n2 = Runtime.getRuntime().availableProcessors();
                ExecutorService executorService = Executors.newFixedThreadPool(n2);
                ArrayList<Future<ApplyJPhaOut>> arrayList = new ArrayList<Future<ApplyJPhaOut>>();
                int n3 = 0;
                while (n3 < this.Nz) {
                    final Float2D object = ((Float3D)shapedVector.asShapedArray()).slice(n3);
                    final int n4 = n3++;
                    Callable<ApplyJPhaOut> n6 = new Callable<ApplyJPhaOut>(){

                        @Override
                        public ApplyJPhaOut call() throws Exception {
                            int n7;
                            int n2;
                            double d4 = 0.0;
                            float[] fArray = new float[2 * n];
                            ApplyJPhaOut applyJPhaOut = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[1].getNumber());
                            d4 = n4 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(n4 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)n4 * WideFieldModel.this.dz;
                            for (int i = 0; i < WideFieldModel.this.Ny; ++i) {
                                for (n2 = 0; n2 < WideFieldModel.this.Nx; ++n2) {
                                    n7 = n2 + WideFieldModel.this.Nx * i;
                                    float f = object.get(n2, i);
                                    fArray[2 * n7] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, n2, i, n4) * f;
                                    fArray[2 * n7 + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, n2, i, n4) * f;
                                }
                            }
                            FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            floatFFT_2D.complexForward(fArray);
                            for (n2 = 0; n2 < WideFieldModel.this.Ny; ++n2) {
                                for (n7 = 0; n7 < WideFieldModel.this.Nx; ++n7) {
                                    int n3 = n7 + n2 * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[n3]) continue;
                                    double d2 = WideFieldModel.this.phi[n3] + d4 * WideFieldModel.this.psi[n3];
                                    double d3 = WideFieldModel.this.rho[n3] * ((double)fArray[2 * n3] * Math.sin(d2) + (double)fArray[2 * n3 + 1] * Math.cos(d2));
                                    int n42 = 0;
                                    while (n42 < WideFieldModel.this.parameterSpace[1].getNumber()) {
                                        int n5 = WideFieldModel.this.radial ? (n42 + 1) * n + n3 : (n42 + 3) * n + n3;
                                        int n6 = n42++;
                                        applyJPhaOut.grd[n6] = applyJPhaOut.grd[n6] - 2.0 * d * d3 * WideFieldModel.this.Z[n5];
                                    }
                                }
                            }
                            return applyJPhaOut;
                        }
                    };
                    arrayList.add(executorService.submit(n6));
                }
                executorService.shutdown();
                for (Future object : arrayList) {
                    try {
                        ApplyJPhaOut applyJPhaOut = (ApplyJPhaOut)object.get();
                        for (int callable = 0; callable < this.parameterSpace[1].getNumber(); ++callable) {
                            double1D.set(callable, double1D.get(callable) + applyJPhaOut.grd[callable]);
                        }
                    }
                    catch (InterruptedException i) {
                        i.printStackTrace();
                    }
                    catch (ExecutionException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            } else {
                int n5;
                int executionException;
                double d4;
                int n7;
                double[] dArray = new double[this.Ny * this.Nx];
                float[] fArray = new float[2 * n];
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                for (n7 = 0; n7 < this.Nz; ++n7) {
                    double d4 = 0.0;
                    d4 = n7 > this.Nz / 2 ? Math.PI * 2 * (double)(n7 - this.Nz) * this.dz : Math.PI * 2 * (double)n7 * this.dz;
                    for (executionException = 0; executionException < this.Ny; ++executionException) {
                        for (int i = 0; i < this.Nx; ++i) {
                            int n6 = i + this.Nx * executionException;
                            float f = ((Float3D)shapedVector.asShapedArray()).get(i, executionException, n7);
                            fArray[2 * n6] = ((Float4D)this.cpxPsf).get(0, i, executionException, n7) * f;
                            fArray[2 * n6 + 1] = ((Float4D)this.cpxPsf).get(1, i, executionException, n7) * f;
                        }
                    }
                    floatFFT_2D.complexForward(fArray);
                    for (executionException = 0; executionException < n; ++executionException) {
                        n5 = n7 * n + executionException;
                        double d2 = this.phi[executionException] + d4 * this.psi[executionException];
                        dArray[executionException] = dArray[executionException] + this.rho[executionException] * ((double)fArray[2 * executionException] * Math.sin(d2) + (double)fArray[2 * executionException + 1] * Math.cos(d2));
                    }
                }
                for (n7 = 0; n7 < this.parameterSpace[1].getNumber(); ++n7) {
                    d4 = 0.0;
                    for (executionException = 0; executionException < n; ++executionException) {
                        n5 = n7 * n + executionException;
                        if (this.radial) {
                            d4 += dArray[executionException] * this.Z[n5 + 1 * n];
                            continue;
                        }
                        d4 += dArray[executionException] * this.Z[n5 + 3 * n];
                    }
                    double1D.set(n7, -2.0 * d * d4);
                }
            }
        } else if (this.para) {
            int n9 = Runtime.getRuntime().availableProcessors();
            ExecutorService executorService = Executors.newFixedThreadPool(n9);
            ArrayList<Future<ApplyJPhaOut>> arrayList = new ArrayList<Future<ApplyJPhaOut>>();
            int n10 = 0;
            while (n10 < this.Nz) {
                final Double2D double2D = ((Double3D)shapedVector.asShapedArray()).slice(n10);
                final int n7 = n10++;
                Callable<ApplyJPhaOut> n13 = new Callable<ApplyJPhaOut>(){

                    @Override
                    public ApplyJPhaOut call() throws Exception {
                        int n8;
                        int n2;
                        double d5 = 0.0;
                        double[] dArray = new double[2 * n];
                        ApplyJPhaOut applyJPhaOut = new ApplyJPhaOut(WideFieldModel.this.parameterSpace[1].getNumber());
                        d5 = n7 > WideFieldModel.this.Nz / 2 ? Math.PI * 2 * (double)(n7 - WideFieldModel.this.Nz) * WideFieldModel.this.dz : Math.PI * 2 * (double)n7 * WideFieldModel.this.dz;
                        for (int i = 0; i < WideFieldModel.this.Ny; ++i) {
                            for (n2 = 0; n2 < WideFieldModel.this.Nx; ++n2) {
                                n8 = n2 + WideFieldModel.this.Nx * i;
                                double d2 = double2D.get(n2, i);
                                dArray[2 * n8] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, n2, i, n7) * d2;
                                dArray[2 * n8 + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, n2, i, n7) * d2;
                            }
                        }
                        DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        doubleFFT_2D.complexForward(dArray);
                        for (n2 = 0; n2 < WideFieldModel.this.Ny; ++n2) {
                            for (n8 = 0; n8 < WideFieldModel.this.Nx; ++n8) {
                                int n3 = n8 + n2 * WideFieldModel.this.Nx;
                                if (!WideFieldModel.this.maskPupil[n3]) continue;
                                double d3 = WideFieldModel.this.phi[n3] + d5 * WideFieldModel.this.psi[n3];
                                double d4 = WideFieldModel.this.rho[n3] * (dArray[2 * n3] * Math.sin(d3) + dArray[2 * n3 + 1] * Math.cos(d3));
                                int n4 = 0;
                                while (n4 < WideFieldModel.this.parameterSpace[1].getNumber()) {
                                    int n5 = WideFieldModel.this.radial ? (n4 + 1) * n + n3 : (n4 + 3) * n + n3;
                                    int n6 = n4++;
                                    applyJPhaOut.grd[n6] = applyJPhaOut.grd[n6] - 2.0 * d * d4 * WideFieldModel.this.Z[n5];
                                }
                            }
                        }
                        return applyJPhaOut;
                    }
                };
                arrayList.add(executorService.submit(n13));
            }
            executorService.shutdown();
            for (Future future : arrayList) {
                try {
                    ApplyJPhaOut applyJPhaOut = (ApplyJPhaOut)future.get();
                    for (int i = 0; i < this.parameterSpace[1].getNumber(); ++i) {
                        double1D.set(i, double1D.get(i) + applyJPhaOut.grd[i]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        } else {
            int n8;
            int n9;
            double d3;
            int n14;
            double[] dArray = new double[this.Ny * this.Nx];
            double[] dArray2 = new double[2 * n];
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)this.Ny, (long)this.Nx);
            for (n14 = 0; n14 < this.Nz; ++n14) {
                double d3 = 0.0;
                d3 = n14 > this.Nz / 2 ? Math.PI * 2 * (double)(n14 - this.Nz) * this.dz : Math.PI * 2 * (double)n14 * this.dz;
                for (n9 = 0; n9 < this.Ny; ++n9) {
                    for (int i = 0; i < this.Nx; ++i) {
                        int n10 = i + this.Nx * n9;
                        double d4 = ((Double3D)shapedVector.asShapedArray()).get(i, n9, n14);
                        dArray2[2 * n10] = ((Double4D)this.cpxPsf).get(0, i, n9, n14) * d4;
                        dArray2[2 * n10 + 1] = ((Double4D)this.cpxPsf).get(1, i, n9, n14) * d4;
                    }
                }
                doubleFFT_2D.complexForward(dArray2);
                for (n9 = 0; n9 < n; ++n9) {
                    n8 = n14 * n + n9;
                    double d5 = this.phi[n9] + d3 * this.psi[n9];
                    dArray[n9] = dArray[n9] + this.rho[n9] * (dArray2[2 * n9] * Math.sin(d5) + dArray2[2 * n9 + 1] * Math.cos(d5));
                }
            }
            for (n14 = 0; n14 < this.parameterSpace[1].getNumber(); ++n14) {
                d3 = 0.0;
                for (n9 = 0; n9 < n; ++n9) {
                    n8 = n14 * n + n9;
                    if (this.radial) {
                        d3 += dArray[n9] * this.Z[n8 + 1 * n];
                        continue;
                    }
                    d3 += dArray[n9] * this.Z[n8 + 3 * n];
                }
                double1D.set(n14, -2.0 * d * d3);
            }
        }
        return this.parameterSpace[1].create((DoubleArray)double1D);
    }

    public DoubleShapedVector apply_J_defocus(ShapedVector shapedVector) {
        int n;
        double d = 1.0 / ((double)this.Nx * this.dxy);
        double d2 = 1.0 / ((double)this.Ny * this.dxy);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        final double[] dArray = new double[this.Nx];
        final double[] dArray2 = new double[this.Ny];
        final int n2 = this.Nx * this.Ny;
        final double d6 = 1.0 / (double)(this.Nx * this.Ny * this.Nz);
        double[] dArray3 = new double[this.parameterSpace[0].getNumber()];
        for (n = 0; n < this.Nx; ++n) {
            dArray[n] = n > this.Nx / 2 ? (double)(n - this.Nx) * d - this.deltaX : (double)n * d - this.deltaX;
        }
        for (n = 0; n < this.Ny; ++n) {
            dArray2[n] = n > this.Ny / 2 ? (double)(n - this.Ny) * d2 - this.deltaY : (double)n * d2 - this.deltaY;
        }
        if (this.single) {
            if (this.para) {
                n = Runtime.getRuntime().availableProcessors();
                ExecutorService executorService = Executors.newFixedThreadPool(n);
                ArrayList<Future<ApplyJDefOut>> arrayList = new ArrayList<Future<ApplyJDefOut>>();
                int n3 = 0;
                while (n3 < this.Nz) {
                    final Float2D object = ((Float3D)shapedVector.asShapedArray()).slice(n3);
                    final int dArray4 = n3++;
                    Callable<ApplyJDefOut> interruptedException = new Callable<ApplyJDefOut>(){

                        @Override
                        public ApplyJDefOut call() throws Exception {
                            int n;
                            int n22;
                            double d;
                            double d2 = 0.0;
                            float[] fArray = new float[2 * n2];
                            ApplyJDefOut applyJDefOut = new ApplyJDefOut(0.0, 0.0, 0.0);
                            if (dArray4 > WideFieldModel.this.Nz / 2) {
                                d = (double)(dArray4 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                                d2 = Math.PI * 2 * (double)(dArray4 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                            } else {
                                d = (double)dArray4 * WideFieldModel.this.dz;
                                d2 = Math.PI * 2 * (double)dArray4 * WideFieldModel.this.dz;
                            }
                            for (int i = 0; i < WideFieldModel.this.Ny; ++i) {
                                for (n22 = 0; n22 < WideFieldModel.this.Nx; ++n22) {
                                    n = n22 + WideFieldModel.this.Nx * i;
                                    float f = object.get(n22, i);
                                    fArray[2 * n] = ((Float4D)WideFieldModel.this.cpxPsf).get(0, n22, i, dArray4) * f;
                                    fArray[2 * n + 1] = ((Float4D)WideFieldModel.this.cpxPsf).get(1, n22, i, dArray4) * f;
                                }
                            }
                            FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                            floatFFT_2D.complexForward(fArray);
                            for (n22 = 0; n22 < WideFieldModel.this.Ny; ++n22) {
                                for (n = 0; n < WideFieldModel.this.Nx; ++n) {
                                    int n3 = n + n22 * WideFieldModel.this.Nx;
                                    if (!WideFieldModel.this.maskPupil[n3]) continue;
                                    double d3 = 1.0 / WideFieldModel.this.psi[n3];
                                    double d4 = WideFieldModel.this.phi[n3] + d2 * WideFieldModel.this.psi[n3];
                                    double d5 = Math.PI * -2 * WideFieldModel.this.rho[n3] * ((double)fArray[2 * n3] * Math.sin(d4) + (double)fArray[2 * n3 + 1] * Math.cos(d4)) * d6;
                                    applyJDefOut.d1 -= d5 * (dArray[n] * (d * d3));
                                    applyJDefOut.d2 -= d5 * (dArray2[n22] * (d * d3));
                                    applyJDefOut.d0 += d5 * (d3 * WideFieldModel.this.lambda_ni * d);
                                }
                            }
                            return applyJDefOut;
                        }
                    };
                    arrayList.add(executorService.submit(interruptedException));
                }
                executorService.shutdown();
                for (Future d14 : arrayList) {
                    try {
                        ApplyJDefOut applyJDefOut = (ApplyJDefOut)d14.get();
                        d3 += applyJDefOut.d0;
                        d4 -= applyJDefOut.d1;
                        d5 -= applyJDefOut.d2;
                    }
                    catch (InterruptedException executionException) {
                        executionException.printStackTrace();
                    }
                    catch (ExecutionException dArray5) {
                        dArray5.printStackTrace();
                    }
                }
            } else {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D((long)this.Nx, (long)this.Ny);
                float[] fArray = new float[2 * n2];
                for (int i = 0; i < this.Nz; ++i) {
                    int n3;
                    int n4;
                    int n5;
                    double d7;
                    double d8 = 0.0;
                    if (i > this.Nz / 2) {
                        d7 = (double)(i - this.Nz) * this.dz;
                        d8 = Math.PI * 2 * d7;
                    } else {
                        d7 = (double)i * this.dz;
                        d8 = Math.PI * 2 * d7;
                    }
                    for (n5 = 0; n5 < this.Ny; ++n5) {
                        for (n4 = 0; n4 < this.Nx; ++n4) {
                            n3 = n4 + this.Nx * n5;
                            float f = ((Float3D)shapedVector.asShapedArray()).get(n4, n5, i);
                            fArray[2 * n3] = ((Float4D)this.cpxPsf).get(0, n4, n5, i) * f;
                            fArray[2 * n3 + 1] = ((Float4D)this.cpxPsf).get(1, n4, n5, i) * f;
                        }
                    }
                    floatFFT_2D.complexForward(fArray);
                    for (n5 = 0; n5 < this.Ny; ++n5) {
                        for (n4 = 0; n4 < this.Nx; ++n4) {
                            n3 = n4 + n5 * this.Nx;
                            if (!this.maskPupil[n3]) continue;
                            double d9 = 1.0 / this.psi[n3];
                            double d10 = this.phi[n3] + d8 * this.psi[n3];
                            double d11 = Math.PI * -2 * this.rho[n3] * ((double)fArray[2 * n3] * Math.sin(d10) + (double)fArray[2 * n3 + 1] * Math.cos(d10)) * d6;
                            d4 -= d11 * (dArray[n4] * (d7 * d9));
                            d5 -= d11 * (dArray2[n5] * (d7 * d9));
                            d3 += d11 * (d9 * this.lambda_ni * d7);
                        }
                    }
                }
            }
        } else if (this.para) {
            n = Runtime.getRuntime().availableProcessors();
            ExecutorService executorService = Executors.newFixedThreadPool(n);
            ArrayList<Future<double[]>> arrayList = new ArrayList<Future<double[]>>();
            int n8 = 0;
            while (n8 < this.Nz) {
                final Double2D double2D = ((Double3D)shapedVector.asShapedArray()).slice(n8);
                final int n6 = n8++;
                Callable<double[]> callable = new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n;
                        int n22;
                        double d;
                        double d2 = 0.0;
                        double[] dArray3 = new double[2 * n2];
                        double[] dArray22 = new double[3];
                        if (n6 > WideFieldModel.this.Nz / 2) {
                            d = (double)(n6 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                            d2 = Math.PI * 2 * (double)(n6 - WideFieldModel.this.Nz) * WideFieldModel.this.dz;
                        } else {
                            d = (double)n6 * WideFieldModel.this.dz;
                            d2 = Math.PI * 2 * (double)n6 * WideFieldModel.this.dz;
                        }
                        for (int i = 0; i < WideFieldModel.this.Ny; ++i) {
                            for (n22 = 0; n22 < WideFieldModel.this.Nx; ++n22) {
                                n = n22 + WideFieldModel.this.Nx * i;
                                double d3 = double2D.get(n22, i);
                                dArray3[2 * n] = ((Double4D)WideFieldModel.this.cpxPsf).get(0, n22, i, n6) * d3;
                                dArray3[2 * n + 1] = ((Double4D)WideFieldModel.this.cpxPsf).get(1, n22, i, n6) * d3;
                            }
                        }
                        DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)WideFieldModel.this.Nx, (long)WideFieldModel.this.Ny);
                        doubleFFT_2D.complexForward(dArray3);
                        for (n22 = 0; n22 < WideFieldModel.this.Ny; ++n22) {
                            for (n = 0; n < WideFieldModel.this.Nx; ++n) {
                                int n3 = n + n22 * WideFieldModel.this.Nx;
                                if (!WideFieldModel.this.maskPupil[n3]) continue;
                                double d4 = 1.0 / WideFieldModel.this.psi[n3];
                                double d5 = WideFieldModel.this.phi[n3] + d2 * WideFieldModel.this.psi[n3];
                                double d62 = Math.PI * -2 * WideFieldModel.this.rho[n3] * (dArray3[2 * n3] * Math.sin(d5) + dArray3[2 * n3 + 1] * Math.cos(d5)) * d6;
                                dArray22[1] = dArray22[1] - d62 * (dArray[n] * (d * d4));
                                dArray22[2] = dArray22[2] - d62 * (dArray2[n22] * (d * d4));
                                dArray22[0] = dArray22[0] + d62 * (d4 * WideFieldModel.this.lambda_ni * d);
                            }
                        }
                        return dArray22;
                    }
                };
                arrayList.add(executorService.submit(callable));
            }
            executorService.shutdown();
            for (Future future : arrayList) {
                try {
                    double[] dArray4 = (double[])future.get();
                    d3 += dArray4[0];
                    d4 -= dArray4[1];
                    d5 -= dArray4[2];
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        } else {
            DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D((long)this.Nx, (long)this.Ny);
            for (int i = 0; i < this.Nz; ++i) {
                double d12;
                int n7;
                int n8;
                int n9;
                double d13;
                Double2D double2D = ((Double3D)shapedVector.asShapedArray()).slice(i);
                int n13 = i;
                double d14 = 0.0;
                double[] dArray5 = new double[2 * n2];
                if (n13 > this.Nz / 2) {
                    d13 = (double)(n13 - this.Nz) * this.dz;
                    d14 = Math.PI * 2 * (double)(n13 - this.Nz) * this.dz;
                } else {
                    d13 = (double)n13 * this.dz;
                    d14 = Math.PI * 2 * (double)n13 * this.dz;
                }
                for (n9 = 0; n9 < this.Ny; ++n9) {
                    for (n8 = 0; n8 < this.Nx; ++n8) {
                        n7 = n8 + this.Nx * n9;
                        d12 = double2D.get(n8, n9);
                        dArray5[2 * n7] = ((Double4D)this.cpxPsf).get(0, n8, n9, n13) * d12;
                        dArray5[2 * n7 + 1] = ((Double4D)this.cpxPsf).get(1, n8, n9, n13) * d12;
                    }
                }
                doubleFFT_2D.complexForward(dArray5);
                for (n9 = 0; n9 < this.Ny; ++n9) {
                    for (n8 = 0; n8 < this.Nx; ++n8) {
                        n7 = n8 + n9 * this.Nx;
                        if (!this.maskPupil[n7]) continue;
                        d12 = 1.0 / this.psi[n7];
                        double d15 = this.phi[n7] + d14 * this.psi[n7];
                        double d16 = Math.PI * -2 * this.rho[n7] * (dArray5[2 * n7] * Math.sin(d15) + dArray5[2 * n7 + 1] * Math.cos(d15)) * d6;
                        d4 -= d16 * (dArray[n8] * (d13 * d12));
                        d5 -= d16 * (dArray2[n9] * (d13 * d12));
                        d3 += d16 * (d12 * this.lambda_ni * d13);
                    }
                }
            }
        }
        switch (this.parameterSpace[0].getNumber()) {
            case 3: {
                dArray3[2] = d5;
                dArray3[1] = d4;
            }
            case 1: {
                dArray3[0] = d3;
                break;
            }
            case 2: {
                dArray3[2] = d5;
                dArray3[1] = d4;
            }
        }
        return this.parameterSpace[0].create((DoubleArray)Double1D.wrap((double[])dArray3, (Shape)this.parameterSpace[0].getShape()));
    }

    protected void computeMaskPupil() {
        this.maskPupil = new boolean[this.Nx * this.Ny];
        this.mapPupil = new boolean[this.Nx * this.Ny];
        double d = Math.pow(1.0 / this.dxy / (double)this.Ny, 2.0);
        double d2 = Math.pow(1.0 / this.dxy / (double)this.Nx, 2.0);
        double d3 = this.radius * this.radius;
        this.pupil_area = 0.0;
        for (int i = 0; i < this.Ny; ++i) {
            double d4 = Math.min(i, this.Ny - i);
            double d5 = d4 * d4 * d;
            for (int j = 0; j < this.Nx; ++j) {
                double d6 = Math.min(j, this.Nx - j);
                double d7 = d6 * d6 * d2;
                if (d7 + d5 < d3) {
                    this.maskPupil[j + i * this.Nx] = true;
                    this.mapPupil[j + i * this.Nx] = true;
                    this.pupil_area += 1.0;
                    continue;
                }
                this.maskPupil[j + i * this.Nx] = false;
                this.mapPupil[j + i * this.Nx] = false;
            }
        }
        this.pupil_area = Math.sqrt(this.pupil_area);
        this.freeMem();
    }

    public void computeDefocus() {
        double d = this.lambda_ni * this.lambda_ni;
        double d2 = 1.0 / ((double)this.Nx * this.dxy);
        double d3 = 1.0 / ((double)this.Ny * this.dxy);
        for (int i = 0; i < this.Ny; ++i) {
            double d4 = i > this.Ny / 2 ? Math.pow(d3 * (double)(i - this.Ny) - this.deltaY, 2.0) : Math.pow(d3 * (double)i - this.deltaY, 2.0);
            for (int j = 0; j < this.Nx; ++j) {
                int n = j + i * this.Nx;
                if (!this.mapPupil[n]) continue;
                double d5 = j > this.Nx / 2 ? Math.pow(d2 * (double)(j - this.Nx) - this.deltaX, 2.0) : Math.pow(d2 * (double)j - this.deltaX, 2.0);
                double d6 = d - d5 - d4;
                if (d6 < 0.0) {
                    this.psi[n] = 0.0;
                    this.maskPupil[n] = false;
                    continue;
                }
                this.psi[n] = Math.sqrt(d6);
                this.maskPupil[n] = true;
            }
        }
    }

    public void setDefocus(DoubleShapedVector doubleShapedVector) {
        if (!doubleShapedVector.belongsTo((VectorSpace)this.parameterSpace[0])) {
            throw new IllegalArgumentException("defocus  does not belong to the parameterSpace[DEFOCUS]");
        }
        this.parameterCoefs[0] = doubleShapedVector;
        switch (doubleShapedVector.getNumber()) {
            case 3: {
                this.deltaX = doubleShapedVector.get(1);
                this.deltaY = doubleShapedVector.get(2);
            }
            case 1: {
                this.lambda_ni = doubleShapedVector.get(0);
                this.ni = this.lambda_ni * this.lambda;
                break;
            }
            case 2: {
                this.deltaX = doubleShapedVector.get(1);
                this.deltaY = doubleShapedVector.get(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad defocus  parameters");
            }
        }
        this.computeDefocus();
        this.freeMem();
    }

    public void setDefocus(double[] dArray) {
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(dArray);
        this.setDefocus(this.parameterCoefs[0]);
    }

    protected void setDefocus() {
        this.setDefocus(new double[]{this.ni / this.lambda, this.deltaX, this.deltaY});
    }

    public void setPupilAxis(double[] dArray) {
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(new double[]{this.ni / this.lambda, dArray[0], dArray[1]});
        this.setDefocus(this.parameterCoefs[0]);
    }

    public void setModulus(DoubleShapedVector doubleShapedVector) {
        if (!doubleShapedVector.belongsTo((VectorSpace)this.parameterSpace[2])) {
            throw new IllegalArgumentException("DoubleShapedVector beta does not belong to the modulus space");
        }
        this.parameterCoefs[2] = doubleShapedVector;
        int n = this.Nx * this.Ny;
        this.rho = new double[n];
        double d = 1.0 / doubleShapedVector.norm2();
        for (int i = 0; i < n; ++i) {
            if (!this.maskPupil[i]) continue;
            for (int j = 0; j < doubleShapedVector.getNumber(); ++j) {
                int n2 = i;
                this.rho[n2] = this.rho[n2] + this.Z[i + j * n] * doubleShapedVector.get(j) * d;
            }
        }
        this.freeMem();
    }

    public void setModulus(double[] dArray) {
        this.setNModulus(dArray.length);
        this.parameterCoefs[2] = this.parameterSpace[2].wrap(dArray);
        this.setModulus(this.parameterCoefs[2]);
    }

    public void setPhase(DoubleShapedVector doubleShapedVector) {
        if (!doubleShapedVector.belongsTo((VectorSpace)this.parameterSpace[1])) {
            throw new IllegalArgumentException("phase parameter does not belong to the right space  ");
        }
        this.parameterCoefs[1] = doubleShapedVector;
        int n = this.Nx * this.Ny;
        this.phi = new double[n];
        for (int i = 0; i < n; ++i) {
            if (!this.maskPupil[i]) continue;
            for (int j = 0; j < doubleShapedVector.getNumber(); ++j) {
                if (this.radial) {
                    int n2 = i;
                    this.phi[n2] = this.phi[n2] + this.Z[i + (j + 1) * n] * doubleShapedVector.get(j);
                    continue;
                }
                int n3 = i;
                this.phi[n3] = this.phi[n3] + this.Z[i + (j + 3) * n] * doubleShapedVector.get(j);
            }
        }
        this.freeMem();
    }

    public void setPhase(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            this.nPhase = 0;
            this.parameterCoefs[1] = null;
        } else {
            this.setNPhase(dArray.length);
            this.parameterCoefs[1] = this.parameterSpace[1].wrap(dArray);
            this.setPhase(this.parameterCoefs[1]);
        }
    }

    public double[] getRho() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.rho;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getNi() {
        return this.ni;
    }

    public void setNi(Double d) {
        this.ni = d;
        this.lambda_ni = this.ni / this.lambda;
        if (this.parameterSpace[0] == null) {
            this.parameterSpace[0] = new DoubleShapedVectorSpace(new int[]{3});
        }
        this.parameterCoefs[0] = this.parameterSpace[0].wrap(new double[]{this.ni / this.lambda, this.deltaX, this.deltaY});
        this.setDefocus(this.parameterCoefs[0]);
    }

    public double[] getPhi() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.phi;
    }

    public double[] getPsi() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.psi;
    }

    public DoubleShapedVector getModulusCoefs() {
        return this.parameterCoefs[2];
    }

    public DoubleShapedVector getPhaseCoefs() {
        return this.parameterCoefs[1];
    }

    public double[] getDefocusMultiplyByLambda() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] dArray = new double[]{this.lambda_ni * this.lambda, this.deltaX * this.lambda, this.deltaY * this.lambda};
        return dArray;
    }

    public double[] getDefocus() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] dArray = new double[]{this.lambda_ni, this.deltaX, this.deltaY};
        return dArray;
    }

    public double[] getPupilShift() {
        if (this.PState < 1) {
            this.computePsf();
        }
        double[] dArray = new double[]{this.deltaX, this.deltaY};
        return dArray;
    }

    public boolean[] getMaskPupil() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.maskPupil;
    }

    @Override
    public Array3D getPsf() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.psf;
    }

    public double[] getZernike() {
        return this.Z;
    }

    public int getNZern() {
        return this.Nzern;
    }

    public double[] getZernike(int n) {
        return MathUtils.getArray((double[])this.Z, (int)this.Nx, (int)this.Ny, (int)n);
    }

    public Array4D get_cpxPsf() {
        if (this.PState < 1) {
            this.computePsf();
        }
        return this.cpxPsf;
    }

    public void getInfo() {
        System.out.println("----PSF----");
        MathUtils.stat((double[])this.psf.toDouble().getData());
        System.out.println();
        System.out.println("----PHI----");
        MathUtils.stat((double[])this.phi);
        System.out.println();
        System.out.println("----RHO----");
        MathUtils.stat((double[])this.rho);
        System.out.println();
        System.out.println("----PSI----");
        MathUtils.stat((double[])this.psi);
        System.out.println();
        System.out.println("----a----");
        MathUtils.statC((double[])this.cpxPsf.toDouble().getData());
        System.out.println();
        System.out.println("----ZERNIKES----");
        MathUtils.stat((double[])this.Z);
    }

    protected void setNPhase() {
        if (this.nPhase > 0) {
            this.parameterSpace[1] = new DoubleShapedVectorSpace(new int[]{this.nPhase});
            this.Nzern = this.radial ? Math.max(this.nPhase + 1, this.parameterSpace[2].getNumber()) : Math.max(this.nPhase + 3, this.parameterSpace[2].getNumber());
            this.computeZernike();
            this.parameterCoefs[1] = this.parameterSpace[1].create(0.0);
            this.setPhase(this.parameterCoefs[1]);
        } else {
            this.parameterSpace[1] = null;
            this.parameterCoefs[1] = null;
        }
    }

    public void setNPhase(int n) {
        this.nPhase = n;
        this.setNPhase();
    }

    public void setNModulus(int n) {
        this.nModulus = n;
        this.setNModulus();
    }

    protected void setNModulus() {
        if (this.nModulus < 1) {
            this.nModulus = 1;
        }
        this.parameterSpace[2] = new DoubleShapedVectorSpace(new int[]{this.nModulus});
        this.Nzern = this.parameterSpace[1] == null ? this.nModulus : (this.radial ? Math.max(this.parameterSpace[1].getNumber() + 1, this.nModulus) : Math.max(this.parameterSpace[1].getNumber() + 3, this.nModulus));
        this.computeZernike();
        this.parameterCoefs[2] = this.parameterSpace[2].create(0.0);
        this.parameterCoefs[2].set(0, 1.0);
        this.setModulus(this.parameterCoefs[2]);
    }

    @Override
    public void freeMem() {
        this.PState = 0;
        this.cpxPsf = null;
        this.psf = null;
    }

    public int getNModulus() {
        return this.parameterCoefs[2].getNumber();
    }

    public int getNPhase() {
        if (this.parameterCoefs[1] == null) {
            return 0;
        }
        return this.parameterCoefs[1].getNumber();
    }

    @Override
    public int[] getParametersFlags() {
        return parametersFlag;
    }

    private class GetPsfParaOut {
        Object outA;
        Object outPsf;
        int idxz;

        public GetPsfParaOut(int n, int n2, boolean bl) {
            this.idxz = n2;
            if (bl) {
                this.outA = new float[2 * n];
                this.outPsf = new float[2 * n];
            } else {
                this.outA = new double[2 * n];
                this.outPsf = new double[2 * n];
            }
        }
    }

    private class ApplyJPhaOut {
        double[] grd;

        public ApplyJPhaOut(int n) {
            this.grd = new double[n];
            Arrays.fill(this.grd, 0.0);
        }
    }

    private class ApplyJDefOut {
        double d0;
        double d1;
        double d2;

        public ApplyJDefOut(double d, double d2, double d3) {
            this.d0 = d;
            this.d1 = d2;
            this.d2 = d3;
        }
    }
}

