/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microscopy;

import microTiPi.microscopy.MicroscopeModel;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.WeightedConvolutionCost;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;
import mitiv.optim.VMLMB;

public class PSF_Estimation {
    private double gatol = 0.0;
    private double grtol = 0.001;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private int maxiter = 20;
    private int maxeval = 20;
    private ShapedArray data = null;
    private ShapedArray obj = null;
    private double fcost = 0.0;
    private ShapedVector gcost = null;
    private MicroscopeModel pupil = null;
    private ReverseCommunicationOptimizer minimizer = null;
    private ShapedArray weights = null;
    private boolean single;
    private boolean run = true;
    private boolean debug = false;

    public PSF_Estimation(MicroscopeModel microscopeModel) {
        if (microscopeModel != null) {
            this.pupil = microscopeModel;
            this.single = microscopeModel.single;
        } else {
            PSF_Estimation.fatal("pupil not specified");
        }
    }

    public void enablePositivity(Boolean bl) {
        this.setLowerBound(bl != false ? 0.0 : Double.NEGATIVE_INFINITY);
    }

    private static void fatal(String string) {
        throw new IllegalArgumentException(string);
    }

    public void fitPSF(int n) {
        FloatShapedVectorSpace floatShapedVectorSpace;
        FloatShapedVectorSpace floatShapedVectorSpace2;
        this.run = true;
        DoubleShapedVector doubleShapedVector = null;
        double d = Double.POSITIVE_INFINITY;
        if (this.data == null) {
            PSF_Estimation.fatal("Input data not specified.");
        }
        doubleShapedVector = this.pupil.parameterCoefs[n];
        Shape shape = this.data.getShape();
        int n2 = this.data.getRank();
        DoubleShapedVector doubleShapedVector2 = doubleShapedVector.clone();
        if (this.obj == null) {
            PSF_Estimation.fatal("Object not specified.");
        }
        if (this.obj.getRank() != n2) {
            PSF_Estimation.fatal("Obj must have same rank as data.");
        }
        if (this.single) {
            floatShapedVectorSpace2 = new FloatShapedVectorSpace(shape);
            floatShapedVectorSpace = new FloatShapedVectorSpace(shape);
        } else {
            floatShapedVectorSpace2 = new DoubleShapedVectorSpace(shape);
            floatShapedVectorSpace = new DoubleShapedVectorSpace(shape);
        }
        DoubleShapedVectorSpace doubleShapedVectorSpace = doubleShapedVector.getSpace();
        int[] nArray = new int[]{0, 0, 0};
        WeightedConvolutionCost weightedConvolutionCost = WeightedConvolutionCost.build((ShapedVectorSpace)floatShapedVectorSpace, (ShapedVectorSpace)floatShapedVectorSpace2);
        weightedConvolutionCost.setPSF(this.obj, nArray);
        weightedConvolutionCost.setData(this.data);
        weightedConvolutionCost.setWeights(this.weights);
        if (this.debug) {
            System.out.println("Vector space initialization complete.");
        }
        this.gcost = floatShapedVectorSpace.create();
        d = this.fcost = weightedConvolutionCost.computeCostAndGradient(1.0, (Vector)floatShapedVectorSpace.create((ShapedArray)this.pupil.getPsf()), (Vector)this.gcost, true);
        doubleShapedVector2 = doubleShapedVector.clone();
        if (this.debug) {
            System.out.println("Cost function initialization complete.");
        }
        MoreThuenteLineSearch moreThuenteLineSearch = null;
        VMLMB vMLMB = null;
        BoundProjector boundProjector = null;
        int n3 = 0;
        this.limitedMemorySize = 0;
        if (this.lowerBound != Double.NEGATIVE_INFINITY) {
            n3 |= 1;
        }
        if (this.upperBound != Double.POSITIVE_INFINITY) {
            n3 |= 2;
        }
        if (this.debug) {
            System.out.println("bounded");
            System.out.println(n3);
        }
        moreThuenteLineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-17);
        int n4 = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
        vMLMB = new VMLMB((VectorSpace)doubleShapedVectorSpace, boundProjector, n4, (LineSearch)moreThuenteLineSearch);
        vMLMB.setAbsoluteTolerance(this.gatol);
        vMLMB.setRelativeTolerance(this.grtol);
        this.minimizer = vMLMB;
        if (this.debug) {
            System.out.println("Optimization method initialization complete.");
        }
        DoubleShapedVector doubleShapedVector3 = doubleShapedVectorSpace.create();
        OptimTask optimTask = this.minimizer.start();
        while (this.run) {
            if (optimTask == OptimTask.COMPUTE_FG) {
                this.pupil.setParam(doubleShapedVector);
                this.pupil.computePsf();
                this.fcost = weightedConvolutionCost.computeCostAndGradient(1.0, (Vector)floatShapedVectorSpace.create((ShapedArray)this.pupil.getPsf()), (Vector)this.gcost, true);
                if (this.fcost < d) {
                    d = this.fcost;
                    doubleShapedVector2 = doubleShapedVector.clone();
                    if (this.debug) {
                        System.out.println("Cost: " + d);
                    }
                }
                doubleShapedVector3 = this.pupil.apply_Jacobian(this.gcost, (ShapedVectorSpace)doubleShapedVector.getSpace());
            } else if (optimTask == OptimTask.NEW_X || optimTask == OptimTask.FINAL_X) {
                boolean bl;
                boolean bl2 = bl = optimTask == OptimTask.FINAL_X;
                if (!bl && this.maxiter >= 0 && this.minimizer.getIterations() >= this.maxiter) {
                    if (this.debug) {
                        System.out.format("Warning: too many iterations (%d).\n", this.maxiter);
                    }
                    bl = true;
                }
                if (bl) {
                    break;
                }
            } else {
                if (!this.debug) break;
                System.out.println("TiPi: PSF_Estimation, " + optimTask + " : " + this.minimizer.getReason());
                break;
            }
            if (this.debug) {
                System.out.println("Evaluations");
                System.out.println(this.minimizer.getEvaluations());
                System.out.println("Iterations");
                System.out.println(this.minimizer.getIterations());
            }
            if (this.minimizer.getEvaluations() >= this.maxeval) {
                if (!this.debug) break;
                System.out.format("Warning: too many evaluation (%d).\n", this.maxeval);
                break;
            }
            optimTask = this.minimizer.iterate((Vector)doubleShapedVector, this.fcost, (Vector)doubleShapedVector3);
        }
        this.pupil.setParam(doubleShapedVector2);
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    public void setMaximumIterations(int n) {
        this.maxiter = n;
        this.maxeval = 2 * n;
    }

    public void setLimitedMemorySize(int n) {
        this.limitedMemorySize = n;
    }

    public void setAbsoluteTolerance(double d) {
        this.gatol = d;
    }

    public void setRelativeTolerance(double d) {
        this.grtol = d;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
    }

    public void abort() {
        this.run = false;
    }

    public void setWeight(ShapedArray shapedArray) {
        this.weights = shapedArray;
    }

    public void setPupil(MicroscopeModel microscopeModel) {
        this.pupil = microscopeModel;
    }

    public MicroscopeModel getPupil() {
        return this.pupil;
    }

    public ShapedArray getData() {
        return this.data;
    }

    public void setData(ShapedArray shapedArray) {
        this.data = shapedArray;
    }

    public ShapedArray getPsf() {
        return this.pupil.getPsf();
    }

    public int getIterations() {
        return this.minimizer == null ? 0 : this.minimizer.getIterations();
    }

    public int getEvaluations() {
        return this.minimizer == null ? 0 : this.minimizer.getEvaluations();
    }

    public double getCost() {
        return this.fcost;
    }

    public void setObj(ShapedArray shapedArray) {
        this.obj = shapedArray;
    }

    public MicroscopeModel getModel() {
        return this.pupil;
    }

    public void freeMem() {
        this.pupil.freeMem();
    }
}

