/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.util.OMEUtil;
import loci.common.services.ServiceException;
import loci.formats.ome.OMEXMLMetadataImpl;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.WeightedData;
import mitiv.utils.FFTUtils;
import mitiv.utils.WeightFactory;
import ome.xml.meta.OMEXMLMetadata;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.Icy2TiPi;

public abstract class DEMICSPlug
extends EzPlug
implements Block {
    protected EzVarSequence data;
    protected EzVarChannel channel;
    protected EzVarDouble logmu;
    protected EzVarDouble mu;
    protected EzVarSequence restart;
    protected EzVarChannel channelRestart;
    protected EzVarBoolean positivity;
    protected EzButton startDec;
    protected EzButton showFullObject;
    protected EzVarText dataSize;
    protected EzVarText outputSize;
    protected EzVarDouble dxy_nm;
    protected EzVarDouble dz_nm;
    protected EzVarDouble na;
    protected EzVarDouble lambda;
    protected EzVarDouble ni;
    protected EzVarInteger nbIterDeconv;
    protected EzVarBoolean singlePrecision;
    protected EzVarDoubleArrayNative scale;
    protected EzVarInteger paddingSizeXY;
    protected EzVarInteger paddingSizeZ;
    protected int sizeX = 128;
    protected int sizeY = 128;
    protected int sizeZ = 64;
    protected int Nx = 128;
    protected int Ny = 128;
    protected int Nz = 64;
    protected Shape psfShape = new Shape(this.Nx, this.Ny, this.Nz);
    protected Shape outputShape;
    protected Sequence dataSeq;
    protected Sequence cursequence;
    protected Shape dataShape;
    protected ShapedArray wgtArray;
    protected ShapedArray dataArray;
    protected ShapedArray psfArray;
    protected ShapedArray objArray;
    protected EzVarText weightsMethod;
    protected final String[] weightOptions = new String[]{"None", "Inverse covariance map", "Variance map", "Computed variance"};
    protected EzVarDouble gain;
    protected EzVarDouble noise;
    protected EzVarSequence weights;
    protected EzVarSequence deadPixel;
    protected EzButton showWeight;
    protected EzVarFile saveFile;
    protected EzVarFile loadFile;
    protected EzVarBoolean showIteration;
    protected EzVarSequence outputHeadlessImage = null;
    protected EzVarSequence outputHeadlessWght = null;
    protected String outputPath = null;
    private boolean debug = false;
    private boolean verbose = false;

    protected ShapedArray createWeights(ShapedArray shapedArray, ShapedArray shapedArray2) {
        ShapedArray shapedArray3 = null;
        WeightedData weightedData = new WeightedData(shapedArray);
        if (this.weightsMethod.getValue() == this.weightOptions[1]) {
            Sequence sequence = (Sequence)this.weights.getValue();
            if (sequence != null) {
                shapedArray3 = Icy2TiPi.sequenceToArray(sequence);
                weightedData.setWeights(shapedArray3);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[2]) {
            Sequence sequence = (Sequence)this.weights.getValue();
            if (sequence != null) {
                ShapedArray shapedArray4 = Icy2TiPi.sequenceToArray(sequence);
                shapedArray3 = WeightFactory.computeWeightsFromVariance((ShapedArray)shapedArray4);
                weightedData.setWeights(shapedArray3);
            }
        } else if (this.weightsMethod.getValue() == this.weightOptions[3]) {
            double d = (Double)this.gain.getValue();
            double d2 = (Double)this.noise.getValue();
            double d3 = 1.0 / d;
            double d4 = d2 / d * (d2 / d);
            weightedData.computeWeightsFromData(d3, d4);
        }
        if (shapedArray2 != null) {
            weightedData.markBadData(shapedArray2);
        }
        return weightedData.getWeights().asShapedArray();
    }

    protected void dataChanged() {
        this.dataSeq = (Sequence)this.data.getValue();
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            if (this.sizeZ == 1) {
                this.throwError("Input data must be 3D");
                return;
            }
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    public void declareInput(VarList varList) {
        varList.add("image", (Var)this.data.getVariable());
        varList.add("image channel", this.channel.getVariable());
        varList.add("starting point", (Var)this.restart.getVariable());
        this.channelRestart = new EzVarChannel("Initialization channel :", (Var)this.restart.getVariable(), false);
        varList.add("starting point channel", this.channelRestart.getVariable());
        varList.add("weights Method", this.weightsMethod.getVariable());
        varList.add("deadPixel", (Var)this.deadPixel.getVariable());
        varList.add("gain", this.gain.getVariable());
        varList.add("noise", this.noise.getVariable());
        varList.add("mu", this.mu.getVariable());
        varList.add("scale", this.scale.getVariable());
        varList.add("Postivity", this.positivity.getVariable());
        varList.add("nbIteration", this.nbIterDeconv.getVariable());
        varList.add("positivity", this.positivity.getVariable());
        varList.add("single precision", this.singlePrecision.getVariable());
        this.saveFile = new EzVarFile("Save parameters in", "");
        varList.add("saveFile", this.saveFile.getVariable());
    }

    public void declareOutput(VarList varList) {
        varList.add("outputSize", this.outputSize.getVariable());
        varList.add("output", (Var)this.outputHeadlessImage.getVariable());
        varList.add("weightmap", (Var)this.outputHeadlessWght.getVariable());
    }

    protected void setDefaultValue() {
        this.weightsMethod.setValue((Object)this.weightOptions[3]);
        this.data.setNoSequenceSelection();
        this.deadPixel.setNoSequenceSelection();
        this.paddingSizeZ.setValue((Object)30);
        this.deadPixel.setNoSequenceSelection();
        if (!this.isHeadLess()) {
            this.outputSize.setEnabled(false);
            this.dataSize.setEnabled(false);
            this.mu.setEnabled(false);
        }
    }

    protected void updateImageSize() {
        String string = this.Nz == 1 ? this.sizeX + "x" + this.sizeY : this.sizeX + "x" + this.sizeY + "x" + this.sizeZ;
        this.dataSize.setValue((Object)string);
    }

    protected void updateMetaData() {
        Sequence sequence = (Sequence)this.data.getValue();
        if (sequence != null) {
            try {
                OMEXMLMetadata oMEXMLMetadata = MetaDataUtil.generateMetaData((Sequence)sequence, (boolean)false);
                oMEXMLMetadata.setPixelsPhysicalSizeX(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 0.001)), 0);
                oMEXMLMetadata.setPixelsPhysicalSizeY(OMEUtil.getLength((double)((Double)this.dxy_nm.getValue() * 0.001)), 0);
                oMEXMLMetadata.setPixelsPhysicalSizeZ(OMEUtil.getLength((double)((Double)this.dz_nm.getValue() * 0.001)), 0);
                sequence.setMetaData((OMEXMLMetadataImpl)oMEXMLMetadata);
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
        } else {
            new AnnounceFrame("Nothing to save");
        }
    }

    protected void updateOutputSize() {
        String string = this.Nx + "x" + this.Ny + "x" + this.Nz;
        this.outputSize.setValue((Object)string);
        if (1.0 * (double)this.Nx * (double)this.Ny * (double)this.Nz > Math.pow(2.0, 30.0)) {
            this.throwError("Padded image is too large (>2^30)");
        }
    }

    protected void updatePaddedSize() {
        if ((double)((Integer)this.paddingSizeXY.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        if ((double)((Integer)this.paddingSizeZ.getValue()).intValue() < 0.0) {
            this.throwError("Padding value cannot be negative");
            return;
        }
        this.Nx = FFTUtils.bestDimension((int)(this.sizeX + (Integer)this.paddingSizeXY.getValue()));
        this.Ny = FFTUtils.bestDimension((int)(this.sizeY + (Integer)this.paddingSizeXY.getValue()));
        this.Nz = FFTUtils.bestDimension((int)(this.sizeZ + (Integer)this.paddingSizeZ.getValue()));
        this.outputShape = new Shape(this.Nx, this.Ny, this.Nz);
        if (this.debug) {
            System.out.println(" UpdatePaddedSize" + this.paddingSizeXY.getValue() + this.outputShape.toString());
        }
    }

    protected void throwError(String string) {
        if (this.isHeadLess()) {
            throw new IllegalArgumentException(string);
        }
        new FailedAnnounceFrame(string);
    }
}

