/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.Filter;
import java.util.Arrays;
import javax.media.opengl.GLContext;

public class CLPlatformFilters {
    public static Filter<CLPlatform> version(final CLVersion cLVersion) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                return cLPlatform.isAtLeast(cLVersion);
            }
        };
    }

    public static Filter<CLPlatform> type(final CLDevice.Type type) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                return cLPlatform.listCLDevices(type).length > 0;
            }
        };
    }

    public static Filter<CLPlatform> glSharing() {
        return new Filter<CLPlatform>(){
            private final Filter<CLDevice> glFilter = CLDeviceFilters.glSharing();

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                CLDevice[] cLDeviceArray;
                for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                    if (!this.glFilter.accept(cLDevice)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter<CLPlatform> glSharing(final GLContext gLContext) {
        return new Filter<CLPlatform>(){
            private final Filter<CLPlatform> glFilter = CLPlatformFilters.glSharing();

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                String string = gLContext.getGL().glGetString(7936);
                String string2 = cLPlatform.getVendor();
                return string2.equals(string) && this.glFilter.accept(cLPlatform);
            }
        };
    }

    public static Filter<CLPlatform> extension(final String ... stringArray) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                return cLPlatform.getExtensions().containsAll(Arrays.asList(stringArray));
            }
        };
    }

    public static Filter<CLPlatform> queueMode(final CLCommandQueue.Mode ... modeArray) {
        return new Filter<CLPlatform>(){
            private final Filter<CLDevice> queueModeFilter;
            {
                this.queueModeFilter = CLDeviceFilters.queueMode(modeArray);
            }

            @Override
            public boolean accept(CLPlatform cLPlatform) {
                for (CLDevice cLDevice : cLPlatform.listCLDevices()) {
                    if (!this.queueModeFilter.accept(cLDevice)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

