/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.TextField;
import java.util.Vector;

public class PlotContentsStyleDialog
implements DialogListener {
    private Plot plot;

    public PlotContentsStyleDialog(Plot plot) {
        this.plot = plot;
    }

    public void showDialog(Frame parent) {
        String[] designations = this.plot.getPlotObjectDesignations();
        if (designations.length == 0) {
            IJ.error("Empty Plot");
            return;
        }
        String[] stylesBackup = new String[designations.length];
        for (int i = 0; i < stylesBackup.length; ++i) {
            stylesBackup[i] = this.plot.getPlotObjectStyles(i);
        }
        GenericDialog gd = new GenericDialog("Plot Contents Style", parent);
        IJ.wait(100);
        gd.addChoice("Item:", designations, designations[0]);
        gd.addStringField("Color:", "#########");
        gd.addStringField("Secondary (fill) color:", "#########");
        gd.addNumericField("Line width: ", 1.0, 1);
        gd.addChoice("Symbol:", Plot.SORTED_SHAPES, Plot.SORTED_SHAPES[2]);
        gd.addDialogListener(this);
        IJ.wait(100);
        this.updateDialog(gd, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            for (int i = 0; i < stylesBackup.length; ++i) {
                this.plot.setPlotObjectStyles(i, stylesBackup[i]);
            }
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (e == null) {
            return true;
        }
        int index = gd.getNextChoiceIndex();
        String color = gd.getNextString();
        String color2 = gd.getNextString();
        double width = gd.getNextNumber();
        String symbol = gd.getNextChoice();
        Choice designationsC = (Choice)gd.getChoices().get(0);
        if (e.getSource() == designationsC) {
            this.updateDialog(gd, index);
        } else {
            this.plot.setPlotObjectStyles(index, color.trim() + "," + color2.trim() + "," + (float)width + "," + symbol);
        }
        return true;
    }

    private void updateDialog(GenericDialog gd, int index) {
        Vector stringFields = gd.getStringFields();
        Vector choices = gd.getChoices();
        Choice designationsC = (Choice)choices.get(0);
        TextField colorF = (TextField)stringFields.get(0);
        TextField color2F = (TextField)stringFields.get(1);
        TextField widthF = (TextField)gd.getNumericFields().get(0);
        Choice symbolC = (Choice)choices.get(1);
        String styleString = this.plot.getPlotObjectStyles(index);
        String[] items = styleString.split(",");
        colorF.setText(items[0]);
        color2F.setText(items[1]);
        widthF.setText(items[2]);
        if (items.length >= 4) {
            symbolC.select(items[3]);
        }
        String designation = designationsC.getSelectedItem();
        boolean isData = designation.startsWith("Data");
        boolean isText = designation.startsWith("Text");
        color2F.setEnabled(isData);
        widthF.setEnabled(!isText);
        symbolC.setEnabled(isData);
    }

    public void setNPasses(int nPasses) {
    }
}

