/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.TextReader;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Convolver
implements ExtendedPlugInFilter,
DialogListener,
ActionListener {
    private ImagePlus imp;
    private int kw;
    private int kh;
    private boolean canceled;
    private float[] kernel;
    private boolean isLineRoi;
    private Button open;
    private Button save;
    private GenericDialog gd;
    private boolean normalize = true;
    private int nSlices;
    private int flags = 16867423;
    private int nPasses = 1;
    private boolean kernelError;
    private PlugInFilterRunner pfr;
    private Thread mainThread;
    private int pass;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalizeFlag = true;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.mainThread = Thread.currentThread();
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        if (arg.equals("final") && imp.getRoi() == null) {
            imp.getProcessor().resetMinAndMax();
            imp.updateAndDraw();
            return 4096;
        }
        IJ.resetEscape();
        Roi roi = imp.getRoi();
        this.isLineRoi = roi != null && roi.isLine();
        this.nSlices = imp.getStackSize();
        this.flags = imp.getStackSize() == 1 ? (this.flags |= 0x40000) : (this.flags |= 0x8000);
        imp.startTiming();
        return this.flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        if (!this.kernelError) {
            this.convolve(ip, this.kernel, this.kw, this.kh);
        }
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.gd = new GenericDialog("Convolver...");
        this.gd.addTextAreas(kernelText, null, 10, 30);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Normalize Kernel", normalizeFlag);
        this.gd.addPreviewCheckbox(pfr);
        this.gd.addDialogListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return 4096;
        }
        this.pfr = pfr;
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        kernelText = gd.getNextText();
        this.normalize = normalizeFlag = gd.getNextBoolean();
        boolean bl = this.kernelError = !this.decodeKernel(kernelText);
        if (!this.kernelError) {
            IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
            return true;
        }
        return !gd.isPreviewActive();
    }

    boolean decodeKernel(String text) {
        if (Macro.getOptions() != null && !this.hasNewLine(text)) {
            return this.decodeSquareKernel(text);
        }
        String[] rows = Tools.split(text, "\n");
        this.kh = rows.length;
        if (this.kh == 0) {
            return false;
        }
        String[] values = Tools.split(rows[0]);
        this.kw = values.length;
        this.kernel = new float[this.kw * this.kh];
        boolean done = this.gd.wasOKed();
        int i = 0;
        for (int y = 0; y < this.kh; ++y) {
            values = Tools.split(rows[y]);
            if (values.length != this.kw) {
                String err = "Row " + (y + 1) + " is not the same length as the first row";
                if (done) {
                    IJ.error("Convolver", err);
                } else {
                    IJ.showStatus(err);
                }
                return false;
            }
            for (int x = 0; x < this.kw; ++x) {
                this.kernel[i++] = (float)Tools.parseDouble(values[x], 0.0);
            }
        }
        if ((this.kw & 1) != 1 || (this.kh & 1) != 1) {
            String err = "Kernel must have odd width and height. This one is " + this.kw + "x" + this.kh + ".";
            if (done) {
                IJ.error("Convolver", err);
            } else {
                IJ.showStatus(err);
            }
            return false;
        }
        return true;
    }

    boolean hasNewLine(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    boolean decodeSquareKernel(String text) {
        String[] values = Tools.split(text);
        int n = values.length;
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        this.kernel = new float[n];
        for (int i = 0; i < n; ++i) {
            this.kernel[i] = (float)Tools.parseDouble(values[i]);
        }
        if (this.kw >= 3 && (this.kw & 1) == 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (int y = 0; y < this.kh; ++y) {
                for (int x = 0; x < this.kw; ++x) {
                    sb.append("" + this.kernel[i++]);
                    if (x >= this.kw - 1) continue;
                    sb.append(" ");
                }
                sb.append("\n");
            }
            kernelText = new String(sb);
            this.gd.getTextArea1().setText(new String(sb));
            return true;
        }
        IJ.error("Kernel must be square with odd width. This one is " + this.kw + "x" + this.kh + ".");
        return false;
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        buttons.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        return buttons;
    }

    public boolean convolve(ImageProcessor ip, float[] kernel, int kw, int kh) {
        if (this.canceled || kw * kh != kernel.length) {
            return false;
        }
        if ((kw & 1) != 1 || (kh & 1) != 1) {
            throw new IllegalArgumentException("Kernel width or height not odd (" + kw + "x" + kh + ")");
        }
        boolean notFloat = !(ip instanceof FloatProcessor);
        ImageProcessor ip2 = ip;
        if (notFloat) {
            if (ip2 instanceof ColorProcessor) {
                throw new IllegalArgumentException("RGB images not supported");
            }
            ip2 = ip2.convertToFloat();
        }
        if (kw == 1 || kh == 1) {
            this.convolveFloat1D((FloatProcessor)ip2, kernel, kw, kh, this.normalize ? Convolver.getScale(kernel) : 1.0);
        } else {
            this.convolveFloat(ip2, kernel, kw, kh);
        }
        if (notFloat) {
            ip2 = ip instanceof ByteProcessor ? ip2.convertToByte(false) : ip2.convertToShort(false);
            ip.setPixels(ip2.getPixels());
        }
        return !this.canceled;
    }

    public void setNormalize(boolean normalizeKernel) {
        this.normalize = normalizeKernel;
    }

    public boolean convolveFloat(ImageProcessor ip, float[] kernel, int kw, int kh) {
        boolean isMainThread;
        if (!(ip instanceof FloatProcessor)) {
            throw new IllegalArgumentException("FloatProcessor required");
        }
        if (this.canceled) {
            return false;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getSnapshotPixels();
        if (pixels2 == null) {
            pixels2 = (float[])ip.getPixelsCopy();
        }
        double scale = this.normalize ? Convolver.getScale(kernel) : 1.0;
        Thread thread = Thread.currentThread();
        boolean bl = isMainThread = thread == this.mainThread || thread.getName().indexOf("Preview") != -1;
        if (isMainThread) {
            ++this.pass;
        }
        int xedge = width - uc;
        int yedge = height - vc;
        long lastTime = System.currentTimeMillis();
        for (int y = y1; y < y2; ++y) {
            long time = System.currentTimeMillis();
            if (time - lastTime > 100L) {
                lastTime = time;
                if (thread.isInterrupted()) {
                    return false;
                }
                if (isMainThread) {
                    if (IJ.escapePressed()) {
                        this.canceled = true;
                        ip.reset();
                        ImageProcessor originalIp = this.imp.getProcessor();
                        if (originalIp.getNChannels() > 1) {
                            originalIp.reset();
                        }
                        return false;
                    }
                    this.showProgress((double)(y - y1) / (double)(y2 - y1));
                }
            }
            for (int x = x1; x < x2; ++x) {
                if (this.canceled) {
                    return false;
                }
                double sum = 0.0;
                int i = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                for (int v = -vc; v <= vc; ++v) {
                    int offset = x + (y + v) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (edgePixel) {
                            if (i >= kernel.length) {
                                IJ.log("kernel index error: " + i);
                            }
                            sum += (double)(this.getPixel(x + u, y + v, pixels2, width, height) * kernel[i++]);
                            continue;
                        }
                        sum += (double)(pixels2[offset + u] * kernel[i++]);
                    }
                }
                pixels[x + y * width] = (float)(sum * scale);
            }
        }
        return true;
    }

    public void convolveFloat1D(FloatProcessor ip, float[] kernel, int kw, int kh) {
        this.convolveFloat1D(ip, kernel, kw, kh, this.normalize ? Convolver.getScale(kernel) : 1.0);
    }

    public void convolveFloat1D(FloatProcessor ip, float[] kernel, int kw, int kh, double scale) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getSnapshotPixels();
        if (pixels2 == null) {
            pixels2 = (float[])ip.getPixelsCopy();
        }
        boolean vertical = kw == 1;
        int xedge = width - uc;
        int yedge = height - vc;
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int offset;
                boolean edgePixel;
                double sum = 0.0;
                int i = 0;
                if (vertical) {
                    edgePixel = y < vc || y >= yedge;
                    offset = x + (y - vc) * width;
                    for (int v = -vc; v <= vc; ++v) {
                        sum = edgePixel ? (sum += (double)(this.getPixel(x + uc, y + v, pixels2, width, height) * kernel[i++])) : (sum += (double)(pixels2[offset + uc] * kernel[i++]));
                        offset += width;
                    }
                } else {
                    edgePixel = x < uc || x >= xedge;
                    offset = x + (y - vc) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (edgePixel) {
                            sum += (double)(this.getPixel(x + u, y + vc, pixels2, width, height) * kernel[i++]);
                            continue;
                        }
                        sum += (double)(pixels2[offset + u] * kernel[i++]);
                    }
                }
                pixels[x + y * width] = (float)(sum * scale);
            }
        }
    }

    public static double getScale(float[] kernel) {
        double scale = 1.0;
        double sum = 0.0;
        for (int i = 0; i < kernel.length; ++i) {
            sum += (double)kernel[i];
        }
        if (sum != 0.0) {
            scale = 1.0 / sum;
        }
        return scale;
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }

    void save() {
        TextArea ta1 = this.gd.getTextArea1();
        ta1.selectAll();
        String text = ta1.getText();
        ta1.select(0, 0);
        if (text == null || text.length() == 0) {
            return;
        }
        text = text + "\n";
        SaveDialog sd = new SaveDialog("Save as Text...", "kernel", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        pw.print(text);
        pw.close();
    }

    void open() {
        double v;
        int x;
        int y;
        OpenDialog od = new OpenDialog("Open Kernel...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        TextReader tr = new TextReader();
        String path = directory + name;
        ImageProcessor ip = tr.open(path);
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if ((width & 1) != 1 || (height & 1) != 1) {
            IJ.error("Convolver", "Kernel must be have odd width and height");
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean integers = true;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                v = ip.getPixelValue(x, y);
                if ((double)((int)v) == v) continue;
                integers = false;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (x != 0) {
                    sb.append(" ");
                }
                v = ip.getPixelValue(x, y);
                if (integers) {
                    sb.append(IJ.d2s(ip.getPixelValue(x, y), 0));
                    continue;
                }
                sb.append("" + ip.getPixelValue(x, y));
            }
            if (y == height - 1) continue;
            sb.append("\n");
        }
        this.gd.getTextArea1().setText(new String(sb));
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
        this.pass = 0;
    }

    private void showProgress(double percent) {
        percent = (double)(this.pass - 1) / (double)this.nPasses + percent / (double)this.nPasses;
        IJ.showProgress(percent);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Recorder.disablePathRecording();
        if (source == this.save) {
            this.save();
        } else if (source == this.open) {
            this.open();
        }
    }
}

