/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.Collator;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

public class GatanReader
extends FormatReader {
    public static final int DM3_MAGIC_BYTES = 3;
    public static final int DM4_MAGIC_BYTES = 4;
    private static final int GROUP = 20;
    private static final int VALUE = 21;
    private static final int ARRAY = 15;
    private static final int SHORT = 2;
    private static final int USHORT = 4;
    private static final int INT = 3;
    private static final int UINT = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final int BYTE = 8;
    private static final int UBYTE = 9;
    private static final int CHAR = 10;
    private static final int UNKNOWN = 11;
    private static final int UNKNOWN2 = 12;
    private long pixelOffset;
    private List<Double> pixelSizes;
    private List<String> units;
    private int numPixelBytes;
    private boolean signed;
    private long timestamp;
    private double gamma;
    private double mag;
    private double voltage;
    private String info;
    private Length posX;
    private Length posY;
    private Length posZ;
    private double sampleTime;
    private boolean adjustEndianness = true;
    private int version;

    public GatanReader() {
        super("Gatan Digital Micrograph", new String[]{"dm3", "dm4"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        int check = stream.readInt();
        return check == 3 || check == 4;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
            this.numPixelBytes = 0;
            this.pixelSizes = null;
            this.signed = false;
            this.timestamp = 0L;
            this.voltage = 0.0;
            this.mag = 0.0;
            this.gamma = 0.0;
            this.info = null;
            this.adjustEndianness = true;
            this.version = 0;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.sampleTime = 0.0;
            this.units = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelOffset = 0L;
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying Gatan format");
        m.littleEndian = false;
        this.pixelSizes = new ArrayList<Double>();
        this.units = new ArrayList<String>();
        this.in.order(this.isLittleEndian());
        this.version = this.in.readInt();
        if (this.version != 3 && this.version != 4) {
            throw new FormatException("invalid header");
        }
        LOGGER.info("Reading tags");
        this.in.skipBytes(4);
        this.skipPadding();
        m.littleEndian = this.in.readInt() != 1;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(2);
        this.skipPadding();
        int numTags = this.in.readInt();
        if ((long)numTags > this.in.length()) {
            m.littleEndian = !this.isLittleEndian();
            this.in.order(this.isLittleEndian());
            this.adjustEndianness = false;
        }
        LOGGER.debug("tags ({}) {", (Object)numTags);
        try {
            this.parseTags(numTags, null, "  ");
        }
        catch (Exception e) {
            throw new FormatException("Unable to parse metadata tag", e);
        }
        LOGGER.debug("}");
        LOGGER.info("Populating metadata");
        m.littleEndian = true;
        if (this.getSizeX() == 0 || this.getSizeY() == 0) {
            throw new FormatException("Dimensions information not found");
        }
        int bytes = this.numPixelBytes / (this.getSizeX() * this.getSizeY());
        if (bytes != FormatTools.getBytesPerPixel(this.getPixelType())) {
            m.pixelType = FormatTools.pixelTypeFromBytes(bytes, this.signed, false);
        }
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYZTC";
        m.imageCount = 1;
        m.rgb = false;
        m.interleaved = false;
        m.metadataComplete = true;
        m.indexed = false;
        m.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String[] scopeInfo;
            int index = 0;
            if (this.pixelSizes.size() >= 3) {
                index = this.pixelSizes.size() - 3;
            } else if (this.pixelSizes.size() >= 2) {
                index = this.pixelSizes.size() - 2;
            }
            if (Math.abs(this.pixelSizes.get(index + 1) - this.pixelSizes.get(index + 2)) < 1.0E-6 && Math.abs(this.pixelSizes.get(index) - this.pixelSizes.get(index + 1)) > 1.0E-6 && this.getSizeY() > 1) {
                ++index;
            }
            if (index < this.pixelSizes.size() - 1) {
                String zUnits;
                Double z;
                Length sizeZ;
                Double x = this.pixelSizes.get(index);
                Double y = this.pixelSizes.get(index + 1);
                String xUnits = index < this.units.size() ? this.units.get(index) : "";
                String yUnits = index + 1 < this.units.size() ? this.units.get(index + 1) : "";
                Length sizeX = FormatTools.getPhysicalSizeX(x, this.convertUnits(xUnits));
                Length sizeY = FormatTools.getPhysicalSizeY(y, this.convertUnits(yUnits));
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, 0);
                }
                if (sizeY != null) {
                    store.setPixelsPhysicalSizeY(sizeY, 0);
                }
                if (index < this.pixelSizes.size() - 2 && (sizeZ = FormatTools.getPhysicalSizeZ(z = this.pixelSizes.get(index + 2), this.convertUnits(zUnits = index + 2 < this.units.size() ? this.units.get(index + 2) : ""))) != null) {
                    store.setPixelsPhysicalSizeZ(sizeZ, 0);
                }
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveCorrection(this.getCorrection("Unknown"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Unknown"), 0, 0);
            store.setObjectiveNominalMagnification(this.mag, 0, 0);
            store.setObjectiveSettingsID(objective, 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            store.setDetectorSettingsID(detector, 0, 0);
            store.setDetectorSettingsVoltage(new ElectricPotential(this.voltage, UNITS.VOLT), 0, 0);
            if (this.info == null) {
                this.info = "";
            }
            for (String token : scopeInfo = this.info.split("\\(")) {
                if (!(token = token.trim()).startsWith("Mode")) continue;
                String mode = (token = token.substring(token.indexOf(32)).trim()).substring(0, token.indexOf(32)).trim();
                if (mode.equals("TEM")) {
                    mode = "Other";
                }
                store.setChannelAcquisitionMode(this.getAcquisitionMode(mode), 0, 0);
            }
            store.setPlanePositionX(this.posX, 0, 0);
            store.setPlanePositionY(this.posY, 0, 0);
            store.setPlanePositionZ(this.posZ, 0, 0);
            store.setPlaneExposureTime(new Time(this.sampleTime, UNITS.SECOND), 0, 0);
        }
    }

    private void parseTags(int numTags, String parent, String indent) throws FormatException, IOException, ParseException {
        for (int i = 0; i < numTags && this.in.getFilePointer() < this.in.length(); ++i) {
            byte type = this.in.readByte();
            int length = this.in.readShort();
            String labelString = null;
            String value = null;
            if (type == 21) {
                int j;
                long baseFP;
                int numFields;
                labelString = this.in.readByteToString(length);
                this.skipPadding();
                this.skipPadding();
                int skip = this.in.readInt();
                this.skipPadding();
                int n = this.in.readInt();
                this.skipPadding();
                int dataType = this.in.readInt();
                String sb = labelString;
                if (sb.length() > 32) {
                    sb = sb.substring(0, 20) + "... (" + sb.length() + ")";
                }
                LOGGER.debug("{}{}: n={}, dataType={}, label={}", indent, i, n, dataType, sb);
                if (skip != 0x25252525) {
                    LOGGER.warn("Skip mismatch: {}", (Object)skip);
                }
                if (n == 1) {
                    if ("Dimensions".equals(parent) && labelString.length() == 0) {
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                        if (i == 0) {
                            ((CoreMetadata)this.core.get((int)0)).sizeX = this.in.readInt();
                        } else if (i == 1) {
                            ((CoreMetadata)this.core.get((int)0)).sizeY = this.in.readInt();
                        }
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                    } else {
                        value = String.valueOf(this.readValue(dataType));
                    }
                } else if (n == 2) {
                    if (dataType == 18) {
                        length = this.in.readInt();
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                    value = this.in.readString(length);
                } else if (n == 3) {
                    if (dataType == 20) {
                        this.skipPadding();
                        dataType = this.in.readInt();
                        this.skipPadding();
                        length = this.in.readInt();
                        if (labelString.equals("Data")) {
                            this.pixelOffset = this.in.getFilePointer();
                            this.in.skipBytes(this.getNumBytes(dataType) * length);
                            this.numPixelBytes = (int)(this.in.getFilePointer() - this.pixelOffset);
                        } else if (dataType == 10) {
                            this.in.skipBytes(length);
                        } else {
                            value = this.in.readByteToString(length * 2);
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                } else if (dataType == 15) {
                    boolean lastTag;
                    this.in.skipBytes(4);
                    this.skipPadding();
                    this.skipPadding();
                    numFields = this.in.readInt();
                    StringBuilder s = new StringBuilder();
                    this.in.skipBytes(4);
                    this.skipPadding();
                    baseFP = this.in.getFilePointer() + 4L;
                    for (j = 0; j < numFields; ++j) {
                        if (this.version == 4) {
                            this.in.seek(baseFP + (long)(j * 16));
                        }
                        dataType = this.in.readInt();
                        s.append(this.readValue(dataType));
                        if (j >= numFields - 1) continue;
                        s.append(", ");
                    }
                    value = s.toString();
                    boolean bl = lastTag = parent == null && i == numTags - 1;
                    if (!lastTag) {
                        int b = 0;
                        int[] jumps = new int[]{4, 3, 3, 5, 5, 3};
                        for (int j2 = 0; j2 < jumps.length; ++j2) {
                            this.in.skipBytes(jumps[j2]);
                            if (this.in.getFilePointer() >= this.in.length()) {
                                return;
                            }
                            b = this.in.readByte();
                            if (b == 20 || b == 21) break;
                        }
                        if (b != 20 && b != 21) {
                            throw new FormatException("Cannot find next tag (pos=" + this.in.getFilePointer() + ", label=" + labelString + ")");
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                } else if (dataType == 20) {
                    this.skipPadding();
                    dataType = this.in.readInt();
                    if (dataType == 15) {
                        this.in.skipBytes(4);
                        this.skipPadding();
                        this.skipPadding();
                        numFields = this.in.readInt();
                        int[] dataTypes = new int[numFields];
                        baseFP = this.in.getFilePointer() + 12L;
                        for (j = 0; j < numFields; ++j) {
                            this.in.skipBytes(4);
                            if (this.version == 4) {
                                this.in.seek(baseFP + (long)(j * 16));
                            }
                            dataTypes[j] = this.in.readInt();
                        }
                        this.skipPadding();
                        int len = this.in.readInt();
                        double[][] values = new double[numFields][len];
                        for (int k = 0; k < len; ++k) {
                            for (int q = 0; q < numFields; ++q) {
                                values[q][k] = this.readValue(dataTypes[q]);
                            }
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                }
            } else if (type == 20) {
                labelString = this.in.readByteToString(length);
                this.in.skipBytes(2);
                this.skipPadding();
                this.skipPadding();
                this.skipPadding();
                int num = this.in.readInt();
                LOGGER.debug("{}{}: group({}) {} {", indent, i, num, labelString);
                this.parseTags(num, labelString, indent + "  ");
                LOGGER.debug("{}}", (Object)indent);
            } else {
                LOGGER.debug("{}{}: unknown type: {}", indent, i, type);
            }
            NumberFormat f = NumberFormat.getInstance(Locale.ENGLISH);
            if (value == null) continue;
            this.addGlobalMeta(labelString, value);
            if (labelString.equals("Scale") && !parent.equals("Calibration")) {
                if (value.indexOf(44) == -1) {
                    this.pixelSizes.add(f.parse(value).doubleValue());
                }
            } else if (labelString.equals("Units") && !parent.equals("Calibration")) {
                if (this.pixelSizes.size() == this.units.size() + 1) {
                    this.units.add(value);
                }
            } else if (labelString.equals("LowLimit")) {
                this.signed = f.parse(value).doubleValue() < 0.0;
            } else if (labelString.equals("Acquisition Start Time (epoch)")) {
                this.timestamp = f.parse(value).longValue();
            } else if (labelString.equals("Voltage")) {
                this.voltage = f.parse(value).doubleValue();
            } else if (labelString.equals("Microscope Info")) {
                this.info = value;
            } else if (labelString.equals("Indicated Magnification")) {
                this.mag = f.parse(value).doubleValue();
            } else if (labelString.equals("Gamma")) {
                this.gamma = f.parse(value).doubleValue();
            } else if (labelString.startsWith("xPos")) {
                Double number = f.parse(value).doubleValue();
                this.posX = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.startsWith("yPos")) {
                Double number = f.parse(value).doubleValue();
                this.posY = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.startsWith("Specimen position")) {
                Double number = f.parse(value).doubleValue();
                this.posZ = new Length(number, UNITS.REFERENCEFRAME);
            } else if (labelString.equals("Sample Time")) {
                this.sampleTime = f.parse(value).doubleValue();
            } else if (labelString.equals("DataType")) {
                int pixelType = f.parse(value).intValue();
                switch (pixelType) {
                    case 1: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 2;
                        break;
                    }
                    case 10: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 3;
                        break;
                    }
                    case 2: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 6;
                        break;
                    }
                    case 12: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 7;
                        break;
                    }
                    case 9: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 0;
                        break;
                    }
                    case 6: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 1;
                        break;
                    }
                    case 7: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 4;
                        break;
                    }
                    case 11: {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = 5;
                    }
                }
            }
            value = null;
        }
    }

    private double readValue(int type) throws IOException {
        switch (type) {
            case 2: 
            case 4: {
                return this.in.readShort();
            }
            case 3: 
            case 5: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                int i = this.in.readInt();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return i;
            }
            case 6: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                float f = this.in.readFloat();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return f;
            }
            case 7: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                double dbl = this.in.readDouble();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return dbl;
            }
            case 8: 
            case 9: 
            case 10: {
                return this.in.readByte();
            }
            case 11: 
            case 12: {
                return this.in.readLong();
            }
        }
        return 0.0;
    }

    private int getNumBytes(int type) {
        switch (type) {
            case 2: 
            case 4: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
        }
        return 0;
    }

    private void skipPadding() throws IOException {
        if (this.version == 4) {
            this.in.skipBytes(4);
        }
    }

    private Unit<Length> convertUnits(String units) {
        Collator c = Collator.getInstance(Locale.ENGLISH);
        if (units != null) {
            if (c.compare("nm", units) == 0) {
                return UNITS.NANOMETER;
            }
            if (c.compare("um", units) != 0 && c.compare("\u00b5m", units) != 0) {
                LOGGER.warn("Not adjusting for unknown units: {}", (Object)units);
            }
        }
        return UNITS.MICROMETER;
    }
}

