/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.services.ServiceException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JPEGTurboService;
import loci.formats.services.JPEGTurboServiceImpl;

public class TileJPEGReader
extends FormatReader {
    private JPEGTileDecoder decoder;
    private JPEGTurboService service;

    public TileJPEGReader() {
        super("Tile JPEG", new String[]{"jpg", "jpeg"});
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.service != null) {
            this.service.getTile(buf, x, y, w, h);
        } else {
            int c = this.getRGBChannelCount();
            for (int ty = y; ty < y + h; ++ty) {
                byte[] scanline = this.decoder.getScanline(ty);
                if (scanline == null) {
                    this.decoder.initialize(this.currentId, 0);
                    scanline = this.decoder.getScanline(ty);
                }
                System.arraycopy(scanline, c * x, buf, (ty - y) * c * w, c * w);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.decoder != null) {
                this.decoder.close();
            }
            this.decoder = null;
            if (this.service != null) {
                this.service.close();
            }
            this.service = null;
        }
    }

    @Override
    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.decoder = new JPEGTileDecoder();
        this.decoder.initialize(this.in, 0, 1, 0);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.interleaved = true;
        m.littleEndian = false;
        m.sizeX = this.decoder.getWidth();
        m.sizeY = this.decoder.getHeight();
        m.sizeZ = 1;
        m.sizeT = 1;
        try {
            m.sizeC = this.decoder.getScanline(0).length / this.getSizeX();
        }
        catch (Exception e) {
            this.decoder.close();
            this.in = new RandomAccessInputStream(id);
            this.in.seek(0L);
            this.service = new JPEGTurboServiceImpl();
            try {
                this.service.initialize(this.in, m.sizeX, m.sizeY);
            }
            catch (ServiceException se) {
                throw new FormatException("Could not initialize JPEG service", se);
            }
            m.sizeC = 3;
        }
        m.rgb = this.getSizeC() > 1;
        m.imageCount = 1;
        m.pixelType = 1;
        m.dimensionOrder = "XYCZT";
        m.metadataComplete = true;
        m.indexed = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

