/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public abstract class StationFeatureImpl
extends PointCollectionImpl
implements StationTimeSeriesFeature {
    protected Station s;
    protected DateUnit timeUnit;

    public StationFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, DateUnit timeUnit, int npts) {
        super(name);
        this.s = new StationImpl(name, desc, wmoId, lat, lon, alt);
        this.timeUnit = timeUnit;
        this.npts = npts;
    }

    public StationFeatureImpl(Station s, DateUnit timeUnit, int npts) {
        super(s.getName());
        this.s = s;
        this.timeUnit = timeUnit;
        this.npts = npts;
        this.setBoundingBox(new LatLonRect(s.getLatLon(), 1.0E-4, 1.0E-4));
    }

    @Override
    public String getWmoId() {
        return this.s.getWmoId();
    }

    @Override
    public int size() {
        return this.npts;
    }

    public void setNumberPoints(int npts) {
        this.npts = npts;
    }

    @Override
    public String getName() {
        return this.s.getName();
    }

    @Override
    public String getDescription() {
        return this.s.getDescription();
    }

    @Override
    public double getLatitude() {
        return this.s.getLatitude();
    }

    @Override
    public double getLongitude() {
        return this.s.getLongitude();
    }

    @Override
    public double getAltitude() {
        return this.s.getAltitude();
    }

    @Override
    public LatLonPoint getLatLon() {
        return this.s.getLatLon();
    }

    @Override
    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    @Override
    public FeatureType getCollectionFeatureType() {
        return FeatureType.STATION;
    }

    public String toString() {
        return "StationFeatureImpl{s=" + this.s + ", timeUnit=" + this.timeUnit + ", npts=" + this.npts + '}';
    }

    @Override
    public StationTimeSeriesFeature subset(CalendarDateRange dateRange) throws IOException {
        if (dateRange == null) {
            return this;
        }
        return new StationFeatureSubset(this, dateRange);
    }

    @Override
    public StationTimeSeriesFeature subset(DateRange dateRange) throws IOException {
        if (dateRange == null) {
            return this;
        }
        return new StationFeatureSubset(this, CalendarDateRange.of(dateRange));
    }

    @Override
    public int compareTo(Station so) {
        return this.name.compareTo(so.getName());
    }

    private class StationFeatureSubset
    extends StationFeatureImpl {
        StationFeatureImpl from;

        StationFeatureSubset(StationFeatureImpl from, CalendarDateRange filter_date) {
            super(from.s, from.timeUnit, -1);
            this.from = from;
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(bufferSize), null, this.dateRange);
        }
    }
}

