/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.dense.decomposition.DecompositionInterface;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;

public class BaseDecompositionBlock64
implements DecompositionInterface<DenseMatrix64F> {
    protected DecompositionInterface<BlockMatrix64F> alg;
    protected double[] tmp;
    protected BlockMatrix64F Ablock = new BlockMatrix64F();
    protected int blockLength;

    public BaseDecompositionBlock64(DecompositionInterface<BlockMatrix64F> decompositionInterface, int n) {
        this.alg = decompositionInterface;
        this.blockLength = n;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.Ablock.numRows = denseMatrix64F.numRows;
        this.Ablock.numCols = denseMatrix64F.numCols;
        this.Ablock.blockLength = this.blockLength;
        this.Ablock.data = denseMatrix64F.data;
        int n = Math.min(this.Ablock.blockLength, denseMatrix64F.numRows) * denseMatrix64F.numCols;
        if (this.tmp == null || this.tmp.length < n) {
            this.tmp = new double[n];
        }
        BlockMatrixOps.convertRowToBlock(denseMatrix64F.numRows, denseMatrix64F.numCols, this.Ablock.blockLength, denseMatrix64F.data, this.tmp);
        boolean bl = this.alg.decompose(this.Ablock);
        if (!this.alg.inputModified()) {
            BlockMatrixOps.convertBlockToRow(denseMatrix64F.numRows, denseMatrix64F.numCols, this.Ablock.blockLength, denseMatrix64F.data, this.tmp);
        }
        return bl;
    }

    public void convertBlockToRow(int n, int n2, int n3, double[] dArray) {
        int n4 = Math.min(n3, n) * n2;
        if (this.tmp == null || this.tmp.length < n4) {
            this.tmp = new double[n4];
        }
        BlockMatrixOps.convertBlockToRow(n, n2, this.Ablock.blockLength, dArray, this.tmp);
    }

    @Override
    public boolean inputModified() {
        return this.alg.inputModified();
    }
}

