/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import java.util.ArrayList;
import mcib3d.geom.GeomTransform3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;

public class ObjectCreator3D {
    ImageHandler img;
    double resXY = 1.0;
    double resZ = 1.0;
    String unit = "pix";

    public ObjectCreator3D(ImageHandler image) {
        this.img = image;
    }

    public ObjectCreator3D(ImageStack stack) {
        this.img = ImageHandler.wrap(stack);
    }

    public ObjectCreator3D(int sizex, int sizey, int sizez) {
        this.img = new ImageShort("creator", sizex, sizey, sizez);
    }

    public void setResolution(double rxy, double rz, String u) {
        this.resXY = rxy;
        this.resZ = rz;
        this.unit = u;
    }

    public Calibration getCalibration() {
        Calibration cal = new Calibration();
        cal.pixelWidth = this.resXY;
        cal.pixelHeight = this.resXY;
        cal.pixelDepth = this.resZ;
        cal.setUnit(this.unit);
        return cal;
    }

    public void setCalibration(Calibration cal) {
        if (cal != null) {
            this.resXY = cal.pixelWidth;
            this.resZ = cal.pixelDepth;
            this.unit = cal.getUnits();
        }
    }

    public void createSphereUnit(double centerx, double centery, double centerz, double radius, float value, boolean gauss) {
        double rx = radius / this.resXY;
        double ry = radius / this.resXY;
        double rz = radius / this.resZ;
        this.createEllipsoid((int)Math.round(centerx /= this.resXY), (int)Math.round(centery /= this.resXY), (int)Math.round(centerz /= this.resZ), rx, ry, rz, value, gauss);
    }

    public void createSphere(double centerx, double centery, double centerz, double radius, float value, boolean gauss) {
        this.createEllipsoid((int)Math.round(centerx), (int)Math.round(centery), (int)Math.round(centerz), radius, radius, radius, value, gauss);
    }

    public void createEllipsoidUnit(double centerx, double centery, double centerz, double rx, double ry, double rz, float value, boolean gauss) {
        this.createEllipsoid((int)Math.round(centerx /= this.resXY), (int)Math.round(centery /= this.resXY), (int)Math.round(centerz /= this.resZ), rx /= this.resXY, ry /= this.resXY, rz /= this.resZ, value, gauss);
    }

    public void createEllipsoid(Vector3D V, double rx, double ry, double rz, float col) {
        this.createEllipsoid(V.getRoundX(), V.getRoundY(), V.getRoundZ(), rx, ry, rz, col, false);
    }

    public void createEllipsoidUnit(Vector3D V, double rx, double ry, double rz, float col) {
        this.createEllipsoid((int)Math.round(V.getX() / this.resXY), (int)Math.round(V.getY() / this.resXY), (int)Math.round(V.getZ() / this.resZ), rx / this.resXY, ry / this.resXY, rz / this.resZ, col, false);
    }

    public void createEllipsoid(int centerx, int centery, int centerz, double rx, double ry, double rz, float value, boolean gauss) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        int startx = (int)Math.round((double)centerx - rx);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)Math.round((double)centery - ry)) < 0) {
            starty = 0;
        }
        if ((startz = (int)Math.round((double)centerz - rz)) < 0) {
            startz = 0;
        }
        if ((endx = (int)Math.round((double)centerx + rx)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)Math.round((double)centery + ry)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)Math.round((double)centerz + rz)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        double rz2 = rz * rz;
        for (int k = startz; k <= endz; ++k) {
            float dz = k - centerz;
            for (int j = starty; j <= endy; ++j) {
                float dy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    float dx = i - centerx;
                    double d = (double)(dx * dx) / rx2 + (double)(dy * dy) / ry2 + (double)(dz * dz) / rz2;
                    if (!(d <= 1.0)) continue;
                    if (gauss) {
                        this.img.setPixel(i, j, k, (float)((double)value * (1.0 - d / 2.0)));
                        continue;
                    }
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createEllipsoidAxes(int centerx, int centery, int centerz, double rx, double ry, double rz, float value, Matrix M, boolean gauss) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        double radius = Math.max(rx, Math.max(ry, rz));
        int startx = (int)((double)centerx - radius);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)((double)centery - radius)) < 0) {
            starty = 0;
        }
        if ((startz = (int)((double)centerz - radius)) < 0) {
            startz = 0;
        }
        if ((endx = (int)((double)centerx + radius)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)((double)centery + radius)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)((double)centerz + radius)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        double rz2 = rz * rz;
        Matrix MM = M.inverse();
        Matrix V1 = new Matrix(3, 1);
        for (int k = startz; k <= endz; ++k) {
            IJ.showStatus((String)("Ellipsoid " + k + "/" + endz));
            double ddz = k - centerz;
            for (int j = starty; j <= endy; ++j) {
                double ddy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    double ddx = i - centerx;
                    V1.set(0, 0, ddx);
                    V1.set(1, 0, ddy);
                    V1.set(2, 0, ddz);
                    Matrix V2 = MM.times(V1);
                    double dx = V2.get(0, 0);
                    double dy = V2.get(1, 0);
                    double dz = V2.get(2, 0);
                    double d = dx * dx / rx2 + dy * dy / ry2 + dz * dz / rz2;
                    if (!(d <= 1.0)) continue;
                    if (gauss) {
                        this.img.setPixel(i, j, k, (float)((double)value * (1.0 - d / 2.0)));
                        continue;
                    }
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createBrickAxes(int centerx, int centery, int centerz, double rx, double ry, double rz, float value, Matrix M) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        double radius = Math.max(rx, Math.max(ry, rz));
        int startx = (int)((double)centerx - radius);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)((double)centery - radius)) < 0) {
            starty = 0;
        }
        if ((startz = (int)((double)centerz - radius)) < 0) {
            startz = 0;
        }
        if ((endx = (int)((double)centerx + radius)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)((double)centery + radius)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)((double)centerz + radius)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        Matrix MM = M.inverse();
        Matrix V1 = new Matrix(3, 1);
        for (int k = startz; k <= endz; ++k) {
            IJ.showStatus((String)("Brick " + k + "/" + endz));
            double ddz = this.resZ * (double)(k - centerz);
            for (int j = starty; j <= endy; ++j) {
                double ddy = this.resXY * (double)(j - centery);
                for (int i = startx; i <= endx; ++i) {
                    double ddx = this.resXY * (double)(i - centerx);
                    V1.set(0, 0, ddx);
                    V1.set(1, 0, ddy);
                    V1.set(2, 0, ddz);
                    Matrix V2 = MM.times(V1);
                    double dx = V2.get(0, 0);
                    double dy = V2.get(1, 0);
                    double dz = V2.get(2, 0);
                    if (!(Math.abs(dx) <= rx) || !(Math.abs(dy) <= ry) || !(Math.abs(dz) <= rz)) continue;
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createEllipsoidAxesUnit(double centerx, double centery, double centerz, double rx, double ry, double rz, float value, Vector3D V, Vector3D W, boolean gauss) {
        this.ComputeEllipsoidAxesUnit(centerx, centery, centerz, rx, ry, rz, value, V, W, gauss);
    }

    public void createBrickAxesUnit(double centerx, double centery, double centerz, double rx, double ry, double rz, float value, Vector3D V) {
        this.createBrickAxes((int)Math.round(centerx /= this.resXY), (int)Math.round(centery /= this.resXY), (int)Math.round(centerz /= this.resZ), rx /= this.resXY, ry /= this.resXY, rz /= this.resZ, value, V);
    }

    private void ComputeEllipsoidAxesUnit(double centerx, double centery, double centerz, double rx, double ry, double rz, float value, Vector3D V, Vector3D W, boolean gradient) {
        V.normalize();
        W.normalize();
        Vector3D X = V.crossProduct(W);
        X.normalize();
        GeomTransform3D transform = new GeomTransform3D(new double[][]{{rx * V.getX(), ry * W.getX(), rz * X.getX(), centerx}, {rx * V.getY(), ry * W.getY(), rz * X.getY(), centery}, {rx * V.getZ(), ry * W.getZ(), rz * X.getZ(), centerz}, {0.0, 0.0, 0.0, 1.0}});
        Vector3D zero_vector = new Vector3D(0.0f, 0.0f, 0.0f);
        double rad = Math.max(rx, Math.max(ry, rz));
        double reso = Math.min(this.resXY, this.resZ);
        double radpix = rad / reso;
        double step = 0.5 / radpix;
        float k = -1.0f;
        while (k <= 1.0f) {
            IJ.showStatus((String)("Ellipsoid generation " + k));
            float j = -1.0f;
            while (j <= 1.0f) {
                float i = -1.0f;
                while (i <= 1.0f) {
                    double d = i * i + j * j + k * k;
                    if (d <= 1.0) {
                        int iz;
                        int iy;
                        Vector3D point = new Vector3D(i, j, k);
                        Vector3D res = transform.getVectorTransformed(point, zero_vector);
                        double x = res.getX();
                        double y = res.getY();
                        double z = res.getZ();
                        int ix = (int)Math.round(x / this.resXY);
                        if (this.img.contains(ix, iy = (int)Math.round(y / this.resXY), iz = (int)Math.round(z / this.resZ))) {
                            if (gradient) {
                                this.img.setPixel(ix, iy, iz, (float)((double)value * (1.0 - d / 2.0)));
                            } else {
                                this.img.setPixel(ix, iy, iz, value);
                            }
                        }
                    }
                    i = (float)((double)i + step);
                }
                j = (float)((double)j + step);
            }
            k = (float)((double)k + step);
        }
    }

    public void createBrickAxes(int centerx, int centery, int centerz, double rx, double ry, double rz, float value, Vector3D V) {
        V.normalize();
        Vector3D W = V.getRandomPerpendicularVector();
        W.normalize();
        Vector3D X = V.crossProduct(W);
        X.normalize();
        Matrix M = new Matrix(3, 3);
        M.set(0, 0, V.getX());
        M.set(1, 0, V.getY());
        M.set(2, 0, V.getZ());
        M.set(0, 1, W.getX());
        M.set(1, 1, W.getY());
        M.set(2, 1, W.getZ());
        M.set(0, 2, X.getX());
        M.set(1, 2, X.getY());
        M.set(2, 2, X.getZ());
        this.createBrickAxes(centerx, centery, centerz, rx, ry, rz, value, M);
    }

    public void createBrick(Vector3D V, double rx, double ry, double rz, float val) {
        this.createBrick(V.getRoundX(), V.getRoundY(), V.getRoundZ(), rx, ry, rz, val);
    }

    public void createBrickUnit(Vector3D V, double rx, double ry, double rz, float val) {
        this.createBrick(V.multiply(1.0 / this.resXY, 1.0 / this.resXY, 1.0 / this.resZ), rx / this.resXY, ry / this.resXY, rz / this.resZ, val);
    }

    public void createBrickUnit(double centerx, double centery, double centerz, double rx, double ry, double rz, float value) {
        this.createBrick((int)Math.round(centerx / this.resXY), (int)Math.round(centery / this.resXY), (int)Math.round(centerz / this.resZ), rx / this.resXY, ry / this.resXY, rz / this.resZ, value);
    }

    public void createBrick(int centerx, int centery, int centerz, double rx, double ry, double rz, float value) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        int startx = (int)((double)centerx - rx);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)((double)centery - ry)) < 0) {
            starty = 0;
        }
        if ((startz = (int)((double)centerz - rz)) < 0) {
            startz = 0;
        }
        if ((endx = (int)((double)centerx + rx)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)((double)centery + ry)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)((double)centerz + rz)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        for (int k = startz; k <= endz; ++k) {
            for (int j = starty; j <= endy; ++j) {
                for (int i = startx; i <= endx; ++i) {
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createPixel(int x, int y, int z, int col) {
        this.img.setPixel(x, y, z, col);
    }

    public void createLine(int x0, int y0, int z0, int x1, int y1, int z1, float val, int rad) {
        Vector3D V = new Vector3D(x1 - x0, y1 - y0, z1 - z0);
        double len = V.getLength();
        V.normalize();
        double vx = V.getX();
        double vy = V.getY();
        double vz = V.getZ();
        for (int i = 0; i < (int)len; ++i) {
            if (rad == 0) {
                this.img.setPixel((int)((double)x0 + (double)i * vx), (int)((double)y0 + (double)i * vy), (int)((double)z0 + (double)i * vz), val);
                continue;
            }
            this.createEllipsoid((int)((double)x0 + (double)i * vx), (int)((double)y0 + (double)i * vy), (int)((double)z0 + (double)i * vz), rad, rad, rad, val, false);
        }
    }

    public void createLine(Vector3D V1, Vector3D V2, float val, int rad) {
        this.createLine(V1.getRoundX(), V1.getRoundY(), V1.getRoundZ(), V2.getRoundX(), V2.getRoundY(), V2.getRoundZ(), val, rad);
    }

    public void createLine(Point3D P1, Point3D P2, float val, int rad) {
        this.createLine(P1.getRoundX(), P1.getRoundY(), P1.getRoundZ(), P2.getRoundX(), P2.getRoundY(), P2.getRoundZ(), val, rad);
    }

    public void createLineUnit(Vector3D V1, Vector3D V2, float val, int rad) {
        this.createLine((int)(V1.getX() / this.resXY), (int)(V1.getY() / this.resXY), (int)(V1.getZ() / this.resZ), (int)(V2.getX() / this.resXY), (int)(V2.getY() / this.resXY), (int)(V2.getZ() / this.resZ), val, rad);
    }

    public void createCylinder(int centerx, int centery, int centerz, double rx, double ry, double height, float value) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        int startx = (int)Math.round((double)centerx - rx);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)Math.round((double)centery - ry)) < 0) {
            starty = 0;
        }
        if ((startz = (int)Math.round((double)centerz - height / 2.0)) < 0) {
            startz = 0;
        }
        if ((endx = (int)Math.round((double)centerx + rx)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)Math.round((double)centery + ry)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)Math.round((double)centerz + height / 2.0)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        for (int k = startz; k <= endz; ++k) {
            for (int j = starty; j <= endy; ++j) {
                float dy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    float dx = i - centerx;
                    double d = (double)(dx * dx) / rx2 + (double)(dy * dy) / ry2;
                    if (!(d <= 1.0)) continue;
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createCone(int centerx, int centery, int centerz, double rx0, double ry0, double rx1, double ry1, double height, float value) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        int startx = (int)Math.round((double)centerx - Math.max(rx0, rx1));
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)Math.round((double)centery - Math.max(ry0, ry1))) < 0) {
            starty = 0;
        }
        if ((startz = (int)Math.round((double)centerz - height / 2.0)) < 0) {
            startz = 0;
        }
        if ((endx = (int)Math.round((double)centerx + Math.max(rx0, rx1))) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)Math.round((double)centery + Math.max(ry0, ry1))) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)Math.round((double)centerz + height / 2.0)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        double ratio = 1.0 / (double)(endz - startz);
        for (int k = startz; k <= endz; ++k) {
            double rx = rx0 + (rx1 - rx0) * (double)(k - startz) * ratio;
            double rx2 = rx * rx;
            double ry = ry0 + (ry1 - ry0) * (double)(k - startz) * ratio;
            double ry2 = ry * ry;
            for (int j = starty; j <= endy; ++j) {
                float dy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    float dx = i - centerx;
                    double d = (double)(dx * dx) / rx2 + (double)(dy * dy) / ry2;
                    if (!(d <= 1.0)) continue;
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createConeAxes(int centerx, int centery, int centerz, double rx0, double ry0, double rx1, double ry1, double height, float value, Matrix M) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        double radius = Math.max(Math.max(rx0, rx1), Math.max(Math.max(ry0, ry1), height / 2.0));
        int startx = (int)((double)centerx - radius);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)((double)centery - radius)) < 0) {
            starty = 0;
        }
        if ((startz = (int)((double)centerz - radius)) < 0) {
            startz = 0;
        }
        if ((endx = (int)((double)centerx + radius)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)((double)centery + radius)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)((double)centerz + radius)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        Matrix MM = M.inverse();
        Matrix V1 = new Matrix(3, 1);
        for (int k = startz; k <= endz; ++k) {
            IJ.showStatus((String)("Cylinder " + k + "/" + endz));
            double ddz = k - centerz;
            for (int j = starty; j <= endy; ++j) {
                double ddy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    double ry;
                    double ry2;
                    double rx;
                    double rx2;
                    double d;
                    double ddx = i - centerx;
                    V1.set(0, 0, ddx);
                    V1.set(1, 0, ddy);
                    V1.set(2, 0, ddz);
                    Matrix V2 = MM.times(V1);
                    double dx = V2.get(0, 0);
                    double dy = V2.get(1, 0);
                    double dz = V2.get(2, 0);
                    if (!(Math.abs(dz) < height / 2.0) || !((d = dx * dx / (rx2 = (rx = rx0 + (rx1 - rx0) * (dz + height / 2.0) / height) * rx) + dy * dy / (ry2 = (ry = ry0 + (ry1 - ry0) * (dz + height / 2.0) / height) * ry)) <= 1.0)) continue;
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createCylinderAxes(int centerx, int centery, int centerz, double rx, double ry, double height, float value, Matrix M) {
        int endz;
        int endy;
        int endx;
        int startz;
        int starty;
        double radius = Math.max(rx, Math.max(ry, height / 2.0));
        int startx = (int)((double)centerx - radius);
        if (startx < 0) {
            startx = 0;
        }
        if ((starty = (int)((double)centery - radius)) < 0) {
            starty = 0;
        }
        if ((startz = (int)((double)centerz - radius)) < 0) {
            startz = 0;
        }
        if ((endx = (int)((double)centerx + radius)) >= this.img.sizeX) {
            endx = this.img.sizeX - 1;
        }
        if ((endy = (int)((double)centery + radius)) >= this.img.sizeY) {
            endy = this.img.sizeY - 1;
        }
        if ((endz = (int)((double)centerz + radius)) >= this.img.sizeZ) {
            endz = this.img.sizeZ - 1;
        }
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        Matrix MM = M.inverse();
        Matrix V1 = new Matrix(3, 1);
        for (int k = startz; k <= endz; ++k) {
            IJ.showStatus((String)("Cylinder " + k + "/" + endz));
            double ddz = k - centerz;
            for (int j = starty; j <= endy; ++j) {
                double ddy = j - centery;
                for (int i = startx; i <= endx; ++i) {
                    double d;
                    double ddx = i - centerx;
                    V1.set(0, 0, ddx);
                    V1.set(1, 0, ddy);
                    V1.set(2, 0, ddz);
                    Matrix V2 = MM.times(V1);
                    double dx = V2.get(0, 0);
                    double dy = V2.get(1, 0);
                    double dz = V2.get(2, 0);
                    if (!(Math.abs(dz) < height / 2.0) || !((d = dx * dx / rx2 + dy * dy / ry2) <= 1.0)) continue;
                    this.img.setPixel(i, j, k, value);
                }
            }
        }
    }

    public void createCylinderAxes(int centerx, int centery, int centerz, double rx, double ry, double height, float value, Vector3D V, Vector3D W) {
        V.normalize();
        W.normalize();
        Vector3D X = V.crossProduct(W);
        X.normalize();
        Matrix M = new Matrix(3, 3);
        M.set(0, 0, V.getX());
        M.set(1, 0, V.getY());
        M.set(2, 0, V.getZ());
        M.set(0, 1, W.getX());
        M.set(1, 1, W.getY());
        M.set(2, 1, W.getZ());
        M.set(0, 2, X.getX());
        M.set(1, 2, X.getY());
        M.set(2, 2, X.getZ());
        this.createCylinderAxes(centerx, centery, centerz, rx, ry, height, value, M);
    }

    public void createConeAxes(int centerx, int centery, int centerz, double rx0, double ry0, double rx1, double ry1, double height, float value, Vector3D V, Vector3D W) {
        V.normalize();
        W.normalize();
        Vector3D X = V.crossProduct(W);
        X.normalize();
        Matrix M = new Matrix(3, 3);
        M.set(0, 0, V.getX());
        M.set(1, 0, V.getY());
        M.set(2, 0, V.getZ());
        M.set(0, 1, W.getX());
        M.set(1, 1, W.getY());
        M.set(2, 1, W.getZ());
        M.set(0, 2, X.getX());
        M.set(1, 2, X.getY());
        M.set(2, 2, X.getZ());
        this.createConeAxes(centerx, centery, centerz, rx0, ry0, rx1, ry1, height, value, M);
    }

    public ImageStack getStack() {
        return this.img.getImageStack();
    }

    public ImagePlus getPlus() {
        ImagePlus plus = new ImagePlus("ObjectCreator3D", this.img.getImageStack());
        Calibration cal = new Calibration();
        cal.pixelWidth = this.resXY;
        cal.pixelHeight = this.resXY;
        cal.pixelDepth = this.resZ;
        cal.setUnit(this.unit);
        plus.setCalibration(cal);
        return plus;
    }

    public void clear() {
        this.img.fill(0.0);
    }

    public ImageHandler getImageHandler() {
        return this.img;
    }

    public Object3DVoxels getObject3DVoxels(int val) {
        return new Object3DVoxels(this.img, val);
    }

    public void reset() {
        this.img.erase();
    }

    public void drawVoxels(ArrayList<Voxel3D> voxels) {
        for (Voxel3D vox : voxels) {
            int z;
            int y;
            int x = vox.getRoundX();
            if (!this.img.contains(x, y = vox.getRoundY(), z = vox.getRoundZ())) continue;
            this.img.setPixel(x, y, z, (int)vox.getValue());
        }
    }

    public void drawObject(Object3D obj) {
        obj.draw(this.img);
    }

    public void reset(int nb) {
        this.img.fill(nb);
    }
}

