/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tfloat.AbstractFloatDistribution;
import cern.jet.random.tfloat.FloatUniform;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class WeightedFloatRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected FloatUniform generator;
    static final int UNDEFINED = -1;

    public WeightedFloatRandomSampler() {
        this(1, null);
    }

    public WeightedFloatRandomSampler(int weight, FloatRandomEngine randomGenerator) {
        if (randomGenerator == null) {
            randomGenerator = AbstractFloatDistribution.makeDefaultGenerator();
        }
        this.generator = new FloatUniform(randomGenerator);
        this.setWeight(weight);
    }

    @Override
    public Object clone() {
        WeightedFloatRandomSampler copy = (WeightedFloatRandomSampler)super.clone();
        copy.generator = (FloatUniform)this.generator.clone();
        return copy;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean sampleNextElement() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setWeight(int weight) {
        if (weight < 1) {
            throw new IllegalArgumentException("bad weight");
        }
        this.weight = weight;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }

    public static void test(int weight, int size) {
        WeightedFloatRandomSampler sampler = new WeightedFloatRandomSampler();
        sampler.setWeight(weight);
        IntArrayList sample = new IntArrayList();
        int i = 0;
        while (i < size) {
            if (sampler.sampleNextElement()) {
                sample.add(i);
            }
            ++i;
        }
        System.out.println("Sample = " + sample);
    }

    private void xsampleNextElements(BooleanArrayList acceptList) {
        int length = acceptList.size();
        boolean[] accept = acceptList.elements();
        int i = 0;
        while (i < length) {
            if (this.skip > 0) {
                --this.skip;
                accept[i] = false;
            } else {
                if (this.nextTriggerPos == -1) {
                    this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
                    this.nextSkip = this.weight - 1 - this.nextTriggerPos;
                }
                if (this.nextTriggerPos > 0) {
                    --this.nextTriggerPos;
                    accept[i] = false;
                } else {
                    this.nextTriggerPos = -1;
                    this.skip = this.nextSkip;
                    accept[i] = true;
                }
            }
            ++i;
        }
    }
}

