/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import loci.common.Location;
import loci.common.Region;
import loci.common.StatusEvent;
import loci.common.StatusListener;
import loci.common.StatusReporter;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.Modulo;
import loci.formats.meta.IMetadata;
import loci.plugins.Slicer;
import loci.plugins.in.Calibrator;
import loci.plugins.in.Colorizer;
import loci.plugins.in.Concatenator;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterOptions;
import loci.plugins.util.BFVirtualStack;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.LuraWave;
import loci.plugins.util.VirtualImagePlus;

public class ImagePlusReader
implements StatusReporter {
    public static final String PROP_SERIES = "Series";
    public static final String PROP_LUT = "LUT-";
    protected ImportProcess process;
    protected List<StatusListener> listeners = new Vector<StatusListener>();
    private long startTime;
    private long time;

    public ImagePlusReader() throws IOException {
        this(new ImportProcess());
    }

    public ImagePlusReader(ImportProcess process) {
        this.process = process;
    }

    public ImagePlus[] openImagePlus() throws FormatException, IOException {
        List<ImagePlus> imps = this.readImages();
        return imps.toArray(new ImagePlus[0]);
    }

    public ImagePlus[] openThumbImagePlus() throws FormatException, IOException {
        List<ImagePlus> imps = this.readThumbImages();
        return imps.toArray(new ImagePlus[imps.size()]);
    }

    @Override
    public void addStatusListener(StatusListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeStatusListener(StatusListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void notifyListeners(StatusEvent e) {
        for (StatusListener l : this.listeners) {
            l.statusUpdated(e);
        }
    }

    public static ImagePlus createImage(String title, List<ImageProcessor> procs) {
        ArrayList<LUT> luts = new ArrayList<LUT>();
        ImageStack stack = ImagePlusReader.createStack(procs, null, luts);
        return ImagePlusReader.createImage(title, stack, luts);
    }

    public static ImagePlus createImage(String title, ImageStack stack, List<LUT> luts) {
        ImagePlus imp = new ImagePlus(title, stack);
        ImagePlusReader.saveLUTs(imp, luts);
        return imp;
    }

    public static ImageStack createStack(List<ImageProcessor> procs, List<String> labels, List<LUT> luts) {
        if (procs == null || procs.size() == 0) {
            return null;
        }
        ImageProcessor ip0 = procs.get(0);
        ImageStack stack = new ImageStack(ip0.getWidth(), ip0.getHeight());
        for (int i = 0; i < procs.size(); ++i) {
            String label;
            ImageProcessor ip = procs.get(i);
            String string = label = labels == null ? null : labels.get(i);
            if (luts != null) {
                ColorModel cm = ip.getColorModel();
                if (cm instanceof LUT) {
                    LUT lut = (LUT)cm;
                    luts.add(lut);
                    ip.setColorModel((ColorModel)ip.getDefaultColorModel());
                } else {
                    luts.add(null);
                }
            }
            stack.addSlice(label, ip);
        }
        return stack;
    }

    private List<ImagePlus> readImages() throws FormatException, IOException {
        return this.readImages(false);
    }

    private List<ImagePlus> readThumbImages() throws FormatException, IOException {
        return this.readImages(true);
    }

    private List<ImagePlus> readImages(boolean thumbnail) throws FormatException, IOException {
        ImporterOptions options = this.process.getOptions();
        ImageProcessorReader reader = this.process.getReader();
        List<ImagePlus> imps = new ArrayList<ImagePlus>();
        this.startTiming();
        for (int s = 0; s < reader.getSeriesCount(); ++s) {
            if (!options.isSeriesOn(s)) continue;
            ImagePlus imp = this.readImage(s, thumbnail);
            imps.add(imp);
        }
        imps = this.concatenate(imps);
        imps = this.applyColors(imps);
        imps = this.splitDims(imps);
        if (options.isVirtual()) {
            this.process.getVirtualReader().setRefCount(imps.size());
        }
        this.finishTiming();
        return imps;
    }

    private ImagePlus readImage(int s, boolean thumbnail) throws FormatException, IOException {
        ImagePlus imp;
        ImporterOptions options = this.process.getOptions();
        int zCount = this.process.getZCount(s);
        int cCount = this.process.getCCount(s);
        int tCount = this.process.getTCount(s);
        ArrayList<LUT> luts = new ArrayList<LUT>();
        ImageStack stack = options.isVirtual() ? this.createVirtualStack(this.process, s, luts) : this.readPlanes(this.process, s, luts, thumbnail);
        this.notifyListeners(new StatusEvent(1, 1, "Creating image"));
        String seriesName = this.process.getOMEMetadata().getImageName(s);
        String file2 = this.process.getCurrentFile();
        ImageProcessorReader reader = this.process.getReader();
        String title = this.constructImageTitle(reader, file2, seriesName, options.isGroupFiles());
        if (stack.isVirtual()) {
            VirtualImagePlus vip = new VirtualImagePlus(title, stack);
            vip.setReader(reader);
            imp = vip;
            ImagePlusReader.saveLUTs(imp, luts);
        } else {
            imp = ImagePlusReader.createImage(title, stack, luts);
        }
        String metadata = this.process.getOriginalMetadata().toString();
        imp.setProperty("Info", (Object)metadata);
        imp.setProperty(PROP_SERIES, (Object)s);
        FileInfo fi = this.createFileInfo();
        new Calibrator(this.process).applyCalibration(imp);
        imp.setFileInfo(fi);
        imp.setDimensions(cCount, zCount, tCount);
        boolean hyper = !options.isViewStandard();
        imp.setOpenAsHyperStack(hyper);
        return imp;
    }

    private ImageStack createVirtualStack(ImportProcess process, int s, List<LUT> luts) throws FormatException, IOException {
        ImporterOptions options = process.getOptions();
        ImageProcessorReader reader = process.getReader();
        reader.setSeries(s);
        int zCount = process.getZCount(s);
        int cCount = process.getCCount(s);
        int tCount = process.getTCount(s);
        IMetadata meta = process.getOMEMetadata();
        int imageCount = reader.getImageCount();
        BFVirtualStack virtualStack = new BFVirtualStack(options.getId(), reader, false, false, false);
        for (int i = 0; i < imageCount; ++i) {
            String label = this.constructSliceLabel(i, reader, meta, s, zCount, cCount, tCount);
            virtualStack.addSlice(label);
        }
        if (luts != null) {
            for (int c = 0; c < cCount; ++c) {
                int index = reader.getIndex(0, c, 0);
                ImageProcessor ip = reader.openProcessors(index)[0];
                ColorModel cm = ip.getColorModel();
                LUT lut = cm instanceof LUT ? (LUT)cm : null;
                luts.add(lut);
            }
        }
        return virtualStack;
    }

    private ImageStack readPlanes(ImportProcess process, int s, List<LUT> luts, boolean thumbnail) throws FormatException, IOException {
        ImageProcessorReader reader = process.getReader();
        reader.setSeries(s);
        int zCount = process.getZCount(s);
        int cCount = process.getCCount(s);
        int tCount = process.getTCount(s);
        IMetadata meta = process.getOMEMetadata();
        boolean[] load = this.getPlanesToLoad(s);
        int current = 0;
        int total = 0;
        for (int j = 0; j < load.length; ++j) {
            if (!load[j]) continue;
            ++total;
        }
        ArrayList<ImageProcessor> procs = new ArrayList<ImageProcessor>();
        ArrayList<String> labels = new ArrayList<String>();
        Region region = process.getCropRegion(s);
        for (int i = 0; i < load.length; ++i) {
            if (!load[i]) continue;
            this.updateTiming(s, current, current++, total);
            ImageProcessor[] p = this.readProcessors(process, i, region, thumbnail);
            if (p == null || p.length == 0) {
                throw new FormatException("Cannot read plane #" + i);
            }
            String label = this.constructSliceLabel(i, reader, meta, s, zCount, cCount, tCount);
            for (ImageProcessor ip : p) {
                procs.add(ip);
                labels.add(label);
            }
        }
        return ImagePlusReader.createStack(procs, labels, luts);
    }

    private ImageProcessor[] readProcessors(ImportProcess process, int no, Region r, boolean thumbnail) throws FormatException, IOException {
        ImageProcessorReader reader = process.getReader();
        ImporterOptions options = process.getOptions();
        boolean first = true;
        for (int i = 0; i < 5; ++i) {
            String code = LuraWave.initLicenseCode();
            try {
                if (thumbnail) {
                    return reader.openThumbProcessors(no);
                }
                return reader.openProcessors(no, r.x, r.y, r.width, r.height);
            }
            catch (FormatException exc) {
                if (options.isQuiet() || options.isWindowless()) {
                    throw exc;
                }
                if (!LuraWave.isLicenseCodeException(exc)) {
                    throw exc;
                }
                if ((code = LuraWave.promptLicenseCode(code, first)) == null) {
                    throw exc;
                }
                if (!first) continue;
                first = false;
                continue;
            }
        }
        throw new FormatException("Too many LuraWave license code attempts; giving up.");
    }

    private List<ImagePlus> concatenate(List<ImagePlus> imps) {
        ImporterOptions options = this.process.getOptions();
        if (options.isConcatenate()) {
            imps = new Concatenator().concatenate(imps);
        }
        return imps;
    }

    private List<ImagePlus> applyColors(List<ImagePlus> imps) {
        return new Colorizer(this.process).applyColors(imps);
    }

    private List<ImagePlus> splitDims(List<ImagePlus> imps) {
        ImporterOptions options = this.process.getOptions();
        boolean sliceC = options.isSplitChannels();
        boolean sliceZ = options.isSplitFocalPlanes();
        boolean sliceT = options.isSplitTimepoints();
        if (sliceC || sliceZ || sliceT) {
            String stackOrder = this.process.getStackOrder();
            ArrayList<ImagePlus> slicedImps = new ArrayList<ImagePlus>();
            Slicer slicer = new Slicer();
            for (ImagePlus imp : imps) {
                ImagePlus[] results;
                for (ImagePlus result : results = slicer.reslice(imp, sliceC, sliceZ, sliceT, stackOrder)) {
                    slicedImps.add(result);
                }
            }
            imps = slicedImps;
        }
        return imps;
    }

    private void startTiming() {
        this.startTime = this.time = System.currentTimeMillis();
    }

    private void updateTiming(int s, int i, int current, int total) {
        ImageProcessorReader reader = this.process.getReader();
        long clock = System.currentTimeMillis();
        if (clock - this.time >= 100L) {
            String sLabel = reader.getSeriesCount() > 1 ? "series " + (s + 1) + ", " : "";
            String pLabel = "plane " + (i + 1) + "/" + total;
            this.notifyListeners(new StatusEvent("Reading " + sLabel + pLabel));
            this.time = clock;
        }
        this.notifyListeners(new StatusEvent(current, total, null));
    }

    private void finishTiming() {
        ImageProcessorReader reader = this.process.getReader();
        long endTime = System.currentTimeMillis();
        double elapsed = (double)(endTime - this.startTime) / 1000.0;
        if (reader.getImageCount() == 1) {
            this.notifyListeners(new StatusEvent("Bio-Formats: " + elapsed + " seconds"));
        } else {
            long average = (endTime - this.startTime) / (long)reader.getImageCount();
            this.notifyListeners(new StatusEvent("Bio-Formats: " + elapsed + " seconds (" + average + " ms per plane)"));
        }
    }

    private FileInfo createFileInfo() {
        String idDir;
        FileInfo fi = new FileInfo();
        String string = idDir = this.process.getIdLocation() == null ? null : this.process.getIdLocation().getParent();
        if (idDir != null && !idDir.endsWith(File.separator)) {
            idDir = idDir + File.separator;
        }
        fi.fileName = this.process.getIdName();
        fi.directory = idDir;
        fi.description = this.process.getOMEXML();
        return fi;
    }

    private boolean[] getPlanesToLoad(int s) {
        ImageProcessorReader reader = this.process.getReader();
        boolean[] load = new boolean[reader.getImageCount()];
        int cBegin = this.process.getCBegin(s);
        int cEnd = this.process.getCEnd(s);
        int cStep = this.process.getCStep(s);
        int zBegin = this.process.getZBegin(s);
        int zEnd = this.process.getZEnd(s);
        int zStep = this.process.getZStep(s);
        int tBegin = this.process.getTBegin(s);
        int tEnd = this.process.getTEnd(s);
        int tStep = this.process.getTStep(s);
        for (int c = cBegin; c <= cEnd; c += cStep) {
            for (int z = zBegin; z <= zEnd; z += zStep) {
                for (int t = tBegin; t <= tEnd; t += tStep) {
                    int index = reader.getIndex(z, c, t);
                    load[index] = true;
                }
            }
        }
        return load;
    }

    private String constructImageTitle(IFormatReader r, String file2, String seriesName, boolean groupFiles) {
        String[] used = r.getUsedFiles();
        String title = file2.substring(file2.lastIndexOf(File.separator) + 1);
        if (used.length > 1 && groupFiles) {
            FilePattern fp = new FilePattern(new Location(file2));
            title = fp.getPattern();
            if (title == null && (title = file2).indexOf(46) != -1) {
                title = title.substring(0, title.lastIndexOf("."));
            }
            title = title.substring(title.lastIndexOf(File.separator) + 1);
        }
        if (seriesName != null && !file2.endsWith(seriesName) && r.getSeriesCount() > 1) {
            title = title + " - " + seriesName;
        }
        if (title.length() > 128) {
            String a = title.substring(0, 62);
            String b = title.substring(title.length() - 62);
            title = a + "..." + b;
        }
        return title;
    }

    private String constructSliceLabel(int ndx, IFormatReader r, IMetadata meta, int series, int zCount, int cCount, int tCount) {
        String imageName;
        String[] subCTypes;
        int[] subC;
        r.setSeries(series);
        int[] zct = r.getZCTCoords(ndx);
        StringBuffer sb = new StringBuffer();
        Modulo moduloC = r.getModuloC();
        if (moduloC.length() > 1) {
            subC = new int[]{r.getSizeC() / moduloC.length(), moduloC.length()};
            subCTypes = new String[]{moduloC.parentType, moduloC.type};
        } else {
            subC = new int[]{r.getSizeC()};
            subCTypes = new String[]{"Channel"};
        }
        boolean first = true;
        if (cCount > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            int[] subCPos = FormatTools.rasterToPosition(subC, zct[1]);
            for (int i = 0; i < subC.length; ++i) {
                boolean ch = subCTypes[i] == null || "Channel".equals(subCTypes[i]);
                sb.append(ch ? "c" : subCTypes[i]);
                sb.append(":");
                sb.append(subCPos[i] + 1);
                sb.append("/");
                sb.append(subC[i]);
                if (i >= subC.length - 1) continue;
                sb.append(", ");
            }
        }
        if (zCount > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("z:");
            sb.append(zct[0] + 1);
            sb.append("/");
            sb.append(r.getSizeZ());
        }
        if (tCount > 1) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append("t:");
            sb.append(zct[2] + 1);
            sb.append("/");
            sb.append(r.getSizeT());
        }
        if ((imageName = meta.getImageName(series)) != null && !imageName.trim().equals("")) {
            sb.append(" - ");
            sb.append(imageName);
        }
        return sb.toString();
    }

    private static void saveLUTs(ImagePlus imp, List<LUT> luts) {
        for (int i = 0; i < luts.size(); ++i) {
            LUT lut = luts.get(i);
            if (lut == null) continue;
            imp.setProperty(PROP_LUT + i, (Object)lut);
        }
    }
}

