/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array4D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array5D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;
    protected final int dim5;

    protected Array5D(int n, int n2, int n3, int n4, int n5) {
        this.shape = new Shape(n, n2, n3, n4, n5);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
        this.dim3 = n3;
        this.dim4 = n4;
        this.dim5 = n5;
    }

    protected Array5D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array5D(Shape shape) {
        if (shape.rank() != 5) {
            throw new IllegalArgumentException("Bad number of dimensions for 5-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
        this.dim5 = shape.dimension(4);
    }

    @Override
    public final int getRank() {
        return 5;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array5D copy();

    public abstract Array4D slice(int var1);

    public abstract Array4D slice(int var1, int var2);

    public abstract Array5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    public abstract Array5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13;
        int n14;
        int n15 = (n8 - 1) * n3;
        if (n15 >= 0) {
            n14 = n2;
            n13 = n2 + n15;
        } else {
            n14 = n2 + n15;
            n13 = n2;
        }
        n15 = (n9 - 1) * n4;
        if (n15 >= 0) {
            n13 += n15;
        } else {
            n14 += n15;
        }
        n15 = (n10 - 1) * n5;
        if (n15 >= 0) {
            n13 += n15;
        } else {
            n14 += n15;
        }
        n15 = (n11 - 1) * n6;
        if (n15 >= 0) {
            n13 += n15;
        } else {
            n14 += n15;
        }
        n15 = (n12 - 1) * n7;
        if (n15 >= 0) {
            n13 += n15;
        } else {
            n14 += n15;
        }
        if (n14 < 0 || n13 >= n) {
            throw new IndexOutOfBoundsException("5D view is not within available space");
        }
        int n16 = Math.abs(n3);
        int n17 = Math.abs(n4);
        int n18 = Math.abs(n5);
        int n19 = Math.abs(n6);
        int n20 = Math.abs(n7);
        if (n16 <= n17 && n17 <= n18 && n18 <= n19 && n19 <= n20) {
            return 1;
        }
        if (n16 >= n17 && n17 >= n18 && n18 >= n19 && n19 >= n20) {
            return 2;
        }
        return 0;
    }
}

