/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte1D;
import mitiv.array.Byte3D;
import mitiv.array.ByteArray;
import mitiv.array.Double4D;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long4D;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatByte4D;
import mitiv.array.impl.StriddenByte4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte4D
extends Array4D
implements ByteArray {
    protected Byte4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected Byte4D(int[] nArray) {
        super(nArray);
    }

    protected Byte4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, byte var5);

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, by);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, by);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (byte)(this.get(i, j, k, i2) + by));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (byte)(this.get(i3, k, j, i) + by));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (byte)(this.get(i, j, k, i2) - by));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (byte)(this.get(i3, k, j, i) - by));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, (byte)(this.get(i, j, k, i2) * by));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (byte)(this.get(i3, k, j, i) * by));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, byteFunction.apply(this.get(i, j, k, i2)));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, byteFunction.apply(this.get(i3, k, j, i)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, byteGenerator.nextByte());
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, byteGenerator.nextByte());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                byteScanner.update(this.get(i, j, k, i2));
                                continue;
                            }
                            byteScanner.initialize(this.get(i, j, k, i2));
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                byteScanner.update(this.get(i3, k, j, i));
                                continue;
                            }
                            byteScanner.initialize(this.get(i3, k, j, i));
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n2 = this.get(i, j, k, i2) & 0xFF;
                            if (n2 >= n) continue;
                            n = n2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n3 = this.get(i3, k, j, i) & 0xFF;
                            if (n3 >= n) continue;
                            n = n3;
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n2 = this.get(i, j, k, i2) & 0xFF;
                            if (n2 <= n) continue;
                            n = n2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n3 = this.get(i3, k, j, i) & 0xFF;
                            if (n3 <= n) continue;
                            n = n3;
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n3 = this.get(i, j, k, i2) & 0xFF;
                            if (n3 < n) {
                                n = n3;
                            }
                            if (n3 <= n2) continue;
                            n2 = n3;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            int n4 = this.get(i3, k, j, i) & 0xFF;
                            if (n4 < n) {
                                n = n4;
                            }
                            if (n4 <= n2) continue;
                            n2 = n4;
                        }
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            n += this.get(i, j, k, i2) & 0xFF;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            n += this.get(i3, k, j, i) & 0xFF;
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        return this;
    }

    @Override
    public Short4D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            sArray[++n] = (short)(this.get(i2, k, j, i) & 0xFF);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(sArray, this.getShape());
    }

    @Override
    public Int4D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            nArray[++n] = this.get(i2, k, j, i) & 0xFF;
                        }
                    }
                }
            }
        }
        return Int4D.wrap(nArray, this.getShape());
    }

    @Override
    public Long4D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            lArray[++n] = this.get(i2, k, j, i) & 0xFF;
                        }
                    }
                }
            }
        }
        return Long4D.wrap(lArray, this.getShape());
    }

    @Override
    public Float4D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            fArray[++n] = this.get(i2, k, j, i) & 0xFF;
                        }
                    }
                }
            }
        }
        return Float4D.wrap(fArray, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            dArray[++n] = this.get(i2, k, j, i) & 0xFF;
                        }
                    }
                }
            }
        }
        return Double4D.wrap(dArray, this.getShape());
    }

    @Override
    public Byte4D copy() {
        return new FlatByte4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte4D byte4D = shapedArray.getType() == 0 ? (Byte4D)shapedArray : (Byte4D)shapedArray.toByte();
        if (this.getOrder() == 2 && byte4D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, byte4D.get(i, j, k, i2));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, byte4D.get(i3, k, j, i));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            this.set(i2, k, j, i, (byte)doubleShapedVector.get(++n));
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (byte)floatShapedVector.get(++n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte4D create() {
        return new FlatByte4D(this.getShape());
    }

    public static Byte4D create(int n, int n2, int n3, int n4) {
        return new FlatByte4D(n, n2, n3, n4);
    }

    public static Byte4D create(int[] nArray) {
        return new FlatByte4D(nArray);
    }

    public static Byte4D create(Shape shape) {
        return new FlatByte4D(shape);
    }

    public static Byte4D wrap(byte[] byArray, int n, int n2, int n3, int n4) {
        return new FlatByte4D(byArray, n, n2, n3, n4);
    }

    public static Byte4D wrap(byte[] byArray, int[] nArray) {
        return new FlatByte4D(byArray, nArray);
    }

    public static Byte4D wrap(byte[] byArray, Shape shape) {
        return new FlatByte4D(byArray, shape);
    }

    public static Byte4D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new StriddenByte4D(byArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public abstract Byte3D slice(int var1);

    @Override
    public abstract Byte3D slice(int var1, int var2);

    @Override
    public abstract Byte4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Byte4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Byte1D as1D();
}

