/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double1D
extends Array1D
implements DoubleArray {
    protected Double1D(int n) {
        super(n);
    }

    protected Double1D(int[] nArray) {
        super(nArray);
    }

    protected Double1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, d);
        }
    }

    @Override
    public void increment(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) + d);
        }
    }

    @Override
    public void decrement(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) - d);
        }
    }

    @Override
    public void scale(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) * d);
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, doubleFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, doubleGenerator.nextDouble());
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        doubleScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            doubleScanner.update(this.get(i));
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            double d2 = this.get(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            double d2 = this.get(i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            double d3 = this.get(i);
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            d += this.get(i);
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                byArray[++n] = (byte)this.get(i);
            }
        }
        return Byte1D.wrap(byArray, this.getShape());
    }

    @Override
    public Short1D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                sArray[++n] = (short)this.get(i);
            }
        }
        return Short1D.wrap(sArray, this.getShape());
    }

    @Override
    public Int1D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                nArray[++n] = (int)this.get(i);
            }
        }
        return Int1D.wrap(nArray, this.getShape());
    }

    @Override
    public Long1D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                lArray[++n] = (long)this.get(i);
            }
        }
        return Long1D.wrap(lArray, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                fArray[++n] = (float)this.get(i);
            }
        }
        return Float1D.wrap(fArray, this.getShape());
    }

    @Override
    public Double1D toDouble() {
        return this;
    }

    @Override
    public Double1D copy() {
        return new FlatDouble1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double1D double1D = shapedArray.getType() == 5 ? (Double1D)shapedArray : (Double1D)shapedArray.toDouble();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, double1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double1D create() {
        return new FlatDouble1D(this.getShape());
    }

    public static Double1D create(int n) {
        return new FlatDouble1D(n);
    }

    public static Double1D create(int[] nArray) {
        return new FlatDouble1D(nArray);
    }

    public static Double1D create(Shape shape) {
        return new FlatDouble1D(shape);
    }

    public static Double1D wrap(double[] dArray, int n) {
        return new FlatDouble1D(dArray, n);
    }

    public static Double1D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble1D(dArray, nArray);
    }

    public static Double1D wrap(double[] dArray, Shape shape) {
        return new FlatDouble1D(dArray, shape);
    }

    public static Double1D wrap(double[] dArray, int n, int n2, int n3) {
        return new StriddenDouble1D(dArray, n, n2, n3);
    }

    @Override
    public abstract DoubleScalar slice(int var1);

    @Override
    public abstract DoubleScalar slice(int var1, int var2);

    @Override
    public abstract Double1D view(Range var1);

    @Override
    public abstract Double1D view(int[] var1);

    @Override
    public abstract Double1D as1D();
}

