/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array8D;
import mitiv.array.Byte8D;
import mitiv.array.Double8D;
import mitiv.array.Float1D;
import mitiv.array.Float7D;
import mitiv.array.FloatArray;
import mitiv.array.Int8D;
import mitiv.array.Long8D;
import mitiv.array.ShapedArray;
import mitiv.array.Short8D;
import mitiv.array.impl.FlatFloat8D;
import mitiv.array.impl.StriddenFloat8D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float8D
extends Array8D
implements FloatArray {
    protected Float8D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n6, n7, n8);
    }

    protected Float8D(int[] nArray) {
        super(nArray);
    }

    protected Float8D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) + f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) + f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) - f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) - f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) * f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) * f);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, floatFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, floatFunction.apply(this.get(i11, i10, i9, i8, i7, k, j, i)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, floatGenerator.nextFloat());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, floatGenerator.nextFloat());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                floatScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6));
                                                continue;
                                            }
                                            floatScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                floatScanner.update(this.get(i11, i10, i9, i8, i7, k, j, i));
                                                continue;
                                            }
                                            floatScanner.initialize(this.get(i11, i10, i9, i8, i7, k, j, i));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float f = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (!(f2 < f)) continue;
                                            f = f2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (!(f3 < f)) continue;
                                            f = f3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float max() {
        float f = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (!(f2 > f)) continue;
                                            f = f2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (!(f3 > f)) continue;
                                            f = f3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        float f2 = f = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f3 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (f3 < f) {
                                                f = f3;
                                            }
                                            if (!(f3 > f2)) continue;
                                            f2 = f3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            float f4 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (f4 < f) {
                                                f = f4;
                                            }
                                            if (!(f4 > f2)) continue;
                                            f2 = f4;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    @Override
    public float sum() {
        float f = 0.0f;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            f += this.get(i, j, k, i2, i3, i4, i5, i6);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            f += this.get(i11, i10, i9, i8, i7, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte8D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            byArray[++n] = (byte)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte8D.wrap(byArray, this.getShape());
    }

    @Override
    public Short8D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            sArray[++n] = (short)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short8D.wrap(sArray, this.getShape());
    }

    @Override
    public Int8D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            nArray[++n] = (int)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int8D.wrap(nArray, this.getShape());
    }

    @Override
    public Long8D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            lArray[++n] = (long)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long8D.wrap(lArray, this.getShape());
    }

    @Override
    public Float8D toFloat() {
        return this;
    }

    @Override
    public Double8D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            dArray[++n] = this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double8D.wrap(dArray, this.getShape());
    }

    @Override
    public Float8D copy() {
        return new FlatFloat8D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float8D float8D = shapedArray.getType() == 4 ? (Float8D)shapedArray : (Float8D)shapedArray.toFloat();
        if (this.getOrder() == 2 && float8D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, float8D.get(i, j, k, i2, i3, i4, i5, i6));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, float8D.get(i11, i10, i9, i8, i7, k, j, i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            this.set(i6, i5, i4, i3, i2, k, j, i, (float)doubleShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, (float)floatShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float8D create() {
        return new FlatFloat8D(this.getShape());
    }

    public static Float8D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatFloat8D(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Float8D create(int[] nArray) {
        return new FlatFloat8D(nArray);
    }

    public static Float8D create(Shape shape) {
        return new FlatFloat8D(shape);
    }

    public static Float8D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatFloat8D(fArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Float8D wrap(float[] fArray, int[] nArray) {
        return new FlatFloat8D(fArray, nArray);
    }

    public static Float8D wrap(float[] fArray, Shape shape) {
        return new FlatFloat8D(fArray, shape);
    }

    public static Float8D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        return new StriddenFloat8D(fArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
    }

    @Override
    public abstract Float7D slice(int var1);

    @Override
    public abstract Float7D slice(int var1, int var2);

    @Override
    public abstract Float8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    @Override
    public abstract Float8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Float1D as1D();
}

