/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array6D;
import mitiv.array.Byte6D;
import mitiv.array.Double6D;
import mitiv.array.Float6D;
import mitiv.array.Int6D;
import mitiv.array.Long1D;
import mitiv.array.Long5D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short6D;
import mitiv.array.impl.FlatLong6D;
import mitiv.array.impl.StriddenLong6D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long6D
extends Array6D
implements LongArray {
    protected Long6D(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    protected Long6D(int[] nArray) {
        super(nArray);
    }

    protected Long6D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, l);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, l);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, this.get(i, j, k, i2, i3, i4) + l);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, this.get(i7, i6, i5, k, j, i) + l);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, this.get(i, j, k, i2, i3, i4) - l);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, this.get(i7, i6, i5, k, j, i) - l);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, this.get(i, j, k, i2, i3, i4) * l);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, this.get(i7, i6, i5, k, j, i) * l);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, longFunction.apply(this.get(i, j, k, i2, i3, i4)));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, longFunction.apply(this.get(i7, i6, i5, k, j, i)));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, longGenerator.nextLong());
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, longGenerator.nextLong());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        longScanner.update(this.get(i, j, k, i2, i3, i4));
                                        continue;
                                    }
                                    longScanner.initialize(this.get(i, j, k, i2, i3, i4));
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        longScanner.update(this.get(i7, i6, i5, k, j, i));
                                        continue;
                                    }
                                    longScanner.initialize(this.get(i7, i6, i5, k, j, i));
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l2 = this.get(i, j, k, i2, i3, i4);
                                    if (l2 >= l) continue;
                                    l = l2;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l3 = this.get(i7, i6, i5, k, j, i);
                                    if (l3 >= l) continue;
                                    l = l3;
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l2 = this.get(i, j, k, i2, i3, i4);
                                    if (l2 <= l) continue;
                                    l = l2;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l3 = this.get(i7, i6, i5, k, j, i);
                                    if (l3 <= l) continue;
                                    l = l3;
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l3 = this.get(i, j, k, i2, i3, i4);
                                    if (l3 < l) {
                                        l = l3;
                                    }
                                    if (l3 <= l2) continue;
                                    l2 = l3;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    long l4 = this.get(i7, i6, i5, k, j, i);
                                    if (l4 < l) {
                                        l = l4;
                                    }
                                    if (l4 <= l2) continue;
                                    l2 = l4;
                                }
                            }
                        }
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    l += this.get(i, j, k, i2, i3, i4);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    l += this.get(i7, i6, i5, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte6D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    byArray[++n] = (byte)this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte6D.wrap(byArray, this.getShape());
    }

    @Override
    public Short6D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    sArray[++n] = (short)this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short6D.wrap(sArray, this.getShape());
    }

    @Override
    public Int6D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    nArray[++n] = (int)this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int6D.wrap(nArray, this.getShape());
    }

    @Override
    public Long6D toLong() {
        return this;
    }

    @Override
    public Float6D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    fArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float6D.wrap(fArray, this.getShape());
    }

    @Override
    public Double6D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    dArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double6D.wrap(dArray, this.getShape());
    }

    @Override
    public Long6D copy() {
        return new FlatLong6D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long6D long6D = shapedArray.getType() == 3 ? (Long6D)shapedArray : (Long6D)shapedArray.toLong();
        if (this.getOrder() == 2 && long6D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, long6D.get(i, j, k, i2, i3, i4));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, long6D.get(i7, i6, i5, k, j, i));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    this.set(i4, i3, i2, k, j, i, (long)doubleShapedVector.get(++n));
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, (long)floatShapedVector.get(++n));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long6D create() {
        return new FlatLong6D(this.getShape());
    }

    public static Long6D create(int n, int n2, int n3, int n4, int n5, int n6) {
        return new FlatLong6D(n, n2, n3, n4, n5, n6);
    }

    public static Long6D create(int[] nArray) {
        return new FlatLong6D(nArray);
    }

    public static Long6D create(Shape shape) {
        return new FlatLong6D(shape);
    }

    public static Long6D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return new FlatLong6D(lArray, n, n2, n3, n4, n5, n6);
    }

    public static Long6D wrap(long[] lArray, int[] nArray) {
        return new FlatLong6D(lArray, nArray);
    }

    public static Long6D wrap(long[] lArray, Shape shape) {
        return new FlatLong6D(lArray, shape);
    }

    public static Long6D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        return new StriddenLong6D(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    @Override
    public abstract Long5D slice(int var1);

    @Override
    public abstract Long5D slice(int var1, int var2);

    @Override
    public abstract Long6D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6);

    @Override
    public abstract Long6D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    @Override
    public abstract Long1D as1D();
}

