/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array9D;
import mitiv.array.Byte9D;
import mitiv.array.Double9D;
import mitiv.array.Float9D;
import mitiv.array.Int9D;
import mitiv.array.Long9D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short8D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort9D;
import mitiv.array.impl.StriddenShort9D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short9D
extends Array9D
implements ShortArray {
    protected Short9D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    protected Short9D(int[] nArray) {
        super(nArray);
    }

    protected Short9D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, short var10);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, s);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, s);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, (short)(this.get(i, j, k, i2, i3, i4, i5, i6, i7) + s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, (short)(this.get(i13, i12, i11, i10, i9, i8, k, j, i) + s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, (short)(this.get(i, j, k, i2, i3, i4, i5, i6, i7) - s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, (short)(this.get(i13, i12, i11, i10, i9, i8, k, j, i) - s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, (short)(this.get(i, j, k, i2, i3, i4, i5, i6, i7) * s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, (short)(this.get(i13, i12, i11, i10, i9, i8, k, j, i) * s));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, shortFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6, i7)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, shortFunction.apply(this.get(i13, i12, i11, i10, i9, i8, k, j, i)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, shortGenerator.nextShort());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, shortGenerator.nextShort());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    shortScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                    continue;
                                                }
                                                shortScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    shortScanner.update(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                    continue;
                                                }
                                                shortScanner.initialize(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (s2 >= s) continue;
                                                s = s2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (s3 >= s) continue;
                                                s = s3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (s2 <= s) continue;
                                                s = s2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (s3 <= s) continue;
                                                s = s3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s3 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (s3 < s) {
                                                    s = s3;
                                                }
                                                if (s3 <= s2) continue;
                                                s2 = s3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                short s4 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (s4 < s) {
                                                    s = s4;
                                                }
                                                if (s4 <= s2) continue;
                                                s2 = s4;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                n += this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                n += this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte9D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                byArray[++n] = (byte)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte9D.wrap(byArray, this.getShape());
    }

    @Override
    public Short9D toShort() {
        return this;
    }

    @Override
    public Int9D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                nArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int9D.wrap(nArray, this.getShape());
    }

    @Override
    public Long9D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                lArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long9D.wrap(lArray, this.getShape());
    }

    @Override
    public Float9D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                fArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float9D.wrap(fArray, this.getShape());
    }

    @Override
    public Double9D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                dArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double9D.wrap(dArray, this.getShape());
    }

    @Override
    public Short9D copy() {
        return new FlatShort9D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short9D short9D = shapedArray.getType() == 1 ? (Short9D)shapedArray : (Short9D)shapedArray.toShort();
        if (this.getOrder() == 2 && short9D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, short9D.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, short9D.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                this.set(i7, i6, i5, i4, i3, i2, k, j, i, (short)doubleShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, (short)floatShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short9D create() {
        return new FlatShort9D(this.getShape());
    }

    public static Short9D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatShort9D(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Short9D create(int[] nArray) {
        return new FlatShort9D(nArray);
    }

    public static Short9D create(Shape shape) {
        return new FlatShort9D(shape);
    }

    public static Short9D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatShort9D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Short9D wrap(short[] sArray, int[] nArray) {
        return new FlatShort9D(sArray, nArray);
    }

    public static Short9D wrap(short[] sArray, Shape shape) {
        return new FlatShort9D(sArray, shape);
    }

    public static Short9D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        return new StriddenShort9D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19);
    }

    @Override
    public abstract Short8D slice(int var1);

    @Override
    public abstract Short8D slice(int var1, int var2);

    @Override
    public abstract Short9D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8, Range var9);

    @Override
    public abstract Short9D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    @Override
    public abstract Short1D as1D();
}

